/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.random;

import io.lumine.mythic.utils.random.RandomSelectorImpl;
import io.lumine.mythic.utils.random.Weigher;
import io.lumine.mythic.utils.random.Weighted;
import java.util.Collection;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Stream;

public interface RandomSelector<E> {
    public static <E> RandomSelector<E> uniform(Collection<E> elements) {
        return RandomSelectorImpl.uniform(elements);
    }

    public static <E extends Weighted> RandomSelector<E> weighted(Collection<E> elements) {
        return RandomSelector.weighted(elements, Weighted.WEIGHER);
    }

    public static <E> RandomSelector<E> weighted(Collection<E> elements, Weigher<? super E> weigher) {
        return RandomSelectorImpl.weighted(elements, weigher);
    }

    public E pick(Random var1);

    default public E pick() {
        return this.pick(ThreadLocalRandom.current());
    }

    public Stream<E> stream(Random var1);

    default public Stream<E> stream() {
        return this.stream(ThreadLocalRandom.current());
    }
}

