/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.redis.jedis;

import io.lumine.mythic.utils.redis.jedis.Builder;
import io.lumine.mythic.utils.redis.jedis.BuilderFactory;
import io.lumine.mythic.utils.redis.jedis.Client;
import io.lumine.mythic.utils.redis.jedis.MultiKeyPipelineBase;
import io.lumine.mythic.utils.redis.jedis.Response;
import io.lumine.mythic.utils.redis.jedis.exceptions.JedisDataException;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Pipeline
extends MultiKeyPipelineBase
implements Closeable {
    private MultiResponseBuilder currentMulti;

    @Override
    protected <T> Response<T> getResponse(Builder<T> builder) {
        if (this.currentMulti != null) {
            super.getResponse(BuilderFactory.STRING);
            Response<T> lr = new Response<T>(builder);
            this.currentMulti.addResponse(lr);
            return lr;
        }
        return super.getResponse(builder);
    }

    public void setClient(Client client) {
        this.client = client;
    }

    @Override
    protected Client getClient(byte[] key) {
        return this.client;
    }

    @Override
    protected Client getClient(String key) {
        return this.client;
    }

    public void clear() {
        if (this.isInMulti()) {
            this.discard();
        }
        this.sync();
    }

    public boolean isInMulti() {
        return this.currentMulti != null;
    }

    public void sync() {
        if (this.getPipelinedResponseLength() > 0) {
            List<Object> unformatted = this.client.getMany(this.getPipelinedResponseLength());
            for (Object o : unformatted) {
                this.generateResponse(o);
            }
        }
    }

    public List<Object> syncAndReturnAll() {
        if (this.getPipelinedResponseLength() > 0) {
            List<Object> unformatted = this.client.getMany(this.getPipelinedResponseLength());
            ArrayList<Object> formatted = new ArrayList<Object>();
            for (Object o : unformatted) {
                try {
                    formatted.add(this.generateResponse(o).get());
                }
                catch (JedisDataException e) {
                    formatted.add(e);
                }
            }
            return formatted;
        }
        return Collections.emptyList();
    }

    public Response<String> discard() {
        if (this.currentMulti == null) {
            throw new JedisDataException("DISCARD without MULTI");
        }
        this.client.discard();
        this.currentMulti = null;
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<List<Object>> exec() {
        if (this.currentMulti == null) {
            throw new JedisDataException("EXEC without MULTI");
        }
        this.client.exec();
        Response<List<Object>> response = super.getResponse(this.currentMulti);
        this.currentMulti.setResponseDependency(response);
        this.currentMulti = null;
        return response;
    }

    public Response<String> multi() {
        if (this.currentMulti != null) {
            throw new JedisDataException("MULTI calls can not be nested");
        }
        this.client.multi();
        Response<String> response = this.getResponse(BuilderFactory.STRING);
        this.currentMulti = new MultiResponseBuilder();
        return response;
    }

    @Override
    public void close() {
        this.clear();
    }

    public Response<Long> waitReplicas(int replicas, long timeout) {
        this.client.waitReplicas(replicas, timeout);
        return this.getResponse(BuilderFactory.LONG);
    }

    private class MultiResponseBuilder
    extends Builder<List<Object>> {
        private List<Response<?>> responses = new ArrayList();

        private MultiResponseBuilder() {
        }

        @Override
        public List<Object> build(Object data) {
            List list = (List)data;
            ArrayList<Object> values = new ArrayList<Object>();
            if (list.size() != this.responses.size()) {
                throw new JedisDataException("Expected data size " + this.responses.size() + " but was " + list.size());
            }
            for (int i = 0; i < list.size(); ++i) {
                Object builtResponse;
                Response<?> response = this.responses.get(i);
                response.set(list.get(i));
                try {
                    builtResponse = response.get();
                }
                catch (JedisDataException e) {
                    builtResponse = e;
                }
                values.add(builtResponse);
            }
            return values;
        }

        public void setResponseDependency(Response<?> dependency) {
            for (Response<?> response : this.responses) {
                response.setDependency(dependency);
            }
        }

        public void addResponse(Response<?> response) {
            this.responses.add(response);
        }
    }
}

