/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.redis.jedis;

import io.lumine.mythic.utils.redis.jedis.Builder;
import io.lumine.mythic.utils.redis.jedis.Response;
import java.util.LinkedList;
import java.util.Queue;

public class Queable {
    private Queue<Response<?>> pipelinedResponses = new LinkedList();

    protected void clean() {
        this.pipelinedResponses.clear();
    }

    protected Response<?> generateResponse(Object data) {
        Response<?> response = this.pipelinedResponses.poll();
        if (response != null) {
            response.set(data);
        }
        return response;
    }

    protected <T> Response<T> getResponse(Builder<T> builder) {
        Response<T> lr = new Response<T>(builder);
        this.pipelinedResponses.add(lr);
        return lr;
    }

    protected boolean hasPipelinedResponse() {
        return !this.pipelinedResponses.isEmpty();
    }

    protected int getPipelinedResponseLength() {
        return this.pipelinedResponses.size();
    }
}

