/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.redis.jedis;

import io.lumine.mythic.utils.redis.jedis.Protocol;
import io.lumine.mythic.utils.redis.jedis.util.SafeEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class SortingParams {
    private final List<byte[]> params = new ArrayList<byte[]>();

    public SortingParams by(String pattern) {
        return this.by(SafeEncoder.encode(pattern));
    }

    public SortingParams by(byte[] pattern) {
        this.params.add(Protocol.Keyword.BY.getRaw());
        this.params.add(pattern);
        return this;
    }

    public SortingParams nosort() {
        this.params.add(Protocol.Keyword.BY.getRaw());
        this.params.add(Protocol.Keyword.NOSORT.getRaw());
        return this;
    }

    public Collection<byte[]> getParams() {
        return Collections.unmodifiableCollection(this.params);
    }

    public SortingParams desc() {
        this.params.add(Protocol.Keyword.DESC.getRaw());
        return this;
    }

    public SortingParams asc() {
        this.params.add(Protocol.Keyword.ASC.getRaw());
        return this;
    }

    public SortingParams limit(int start, int count) {
        this.params.add(Protocol.Keyword.LIMIT.getRaw());
        this.params.add(Protocol.toByteArray(start));
        this.params.add(Protocol.toByteArray(count));
        return this;
    }

    public SortingParams alpha() {
        this.params.add(Protocol.Keyword.ALPHA.getRaw());
        return this;
    }

    public SortingParams get(String ... patterns) {
        for (String pattern : patterns) {
            this.params.add(Protocol.Keyword.GET.getRaw());
            this.params.add(SafeEncoder.encode(pattern));
        }
        return this;
    }

    public SortingParams get(byte[] ... patterns) {
        for (byte[] pattern : patterns) {
            this.params.add(Protocol.Keyword.GET.getRaw());
            this.params.add(pattern);
        }
        return this;
    }
}

