/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.redis.jedis.params;

import io.lumine.mythic.utils.redis.jedis.args.ClientType;
import io.lumine.mythic.utils.redis.jedis.params.Params;

public class ClientKillParams
extends Params {
    private static final String ID = "ID";
    private static final String TYPE = "TYPE";
    private static final String ADDR = "ADDR";
    private static final String SKIPME = "SKIPME";
    private static final String USER = "USER";
    private static final String LADDR = "LADDR";

    public static ClientKillParams clientKillParams() {
        return new ClientKillParams();
    }

    public ClientKillParams id(String clientId) {
        this.addParam(ID, clientId);
        return this;
    }

    public ClientKillParams id(byte[] clientId) {
        this.addParam(ID, clientId);
        return this;
    }

    @Deprecated
    public ClientKillParams type(Type type) {
        this.addParam(TYPE, (Object)type);
        return this;
    }

    public ClientKillParams type(ClientType type) {
        this.addParam(TYPE, type);
        return this;
    }

    public ClientKillParams addr(String ipPort) {
        this.addParam(ADDR, ipPort);
        return this;
    }

    public ClientKillParams addr(byte[] ipPort) {
        this.addParam(ADDR, ipPort);
        return this;
    }

    public ClientKillParams addr(String ip, int port) {
        this.addParam(ADDR, ip + ':' + port);
        return this;
    }

    public ClientKillParams skipMe(SkipMe skipMe) {
        this.addParam(SKIPME, (Object)skipMe);
        return this;
    }

    public ClientKillParams user(String username) {
        this.addParam(USER, username);
        return this;
    }

    public ClientKillParams laddr(String ipPort) {
        this.addParam(LADDR, ipPort);
        return this;
    }

    public ClientKillParams laddr(String ip, int port) {
        this.addParam(LADDR, ip + ':' + port);
        return this;
    }

    public static enum SkipMe {
        YES,
        NO;

    }

    @Deprecated
    public static enum Type {
        NORMAL,
        MASTER,
        SLAVE,
        PUBSUB;

    }
}

