/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.redis.jedis.params;

import io.lumine.mythic.utils.redis.jedis.Protocol;
import io.lumine.mythic.utils.redis.jedis.params.Params;
import io.lumine.mythic.utils.redis.jedis.util.SafeEncoder;
import java.util.ArrayList;
import java.util.Collections;

public class GetExParams
extends Params {
    private static final String PX = "px";
    private static final String EX = "ex";
    private static final String EXAT = "exat";
    private static final String PXAT = "pxat";
    private static final String PERSIST = "persist";

    public static GetExParams getExParams() {
        return new GetExParams();
    }

    public GetExParams ex(long secondsToExpire) {
        this.addParam(EX, secondsToExpire);
        return this;
    }

    public GetExParams px(long millisecondsToExpire) {
        this.addParam(PX, millisecondsToExpire);
        return this;
    }

    public GetExParams exAt(long seconds) {
        this.addParam(EXAT, seconds);
        return this;
    }

    public GetExParams pxAt(long milliseconds) {
        this.addParam(PXAT, milliseconds);
        return this;
    }

    public GetExParams persist() {
        this.addParam(PERSIST);
        return this;
    }

    public byte[][] getByteParams(byte[] key, byte[] ... args) {
        ArrayList<byte[]> byteParams = new ArrayList<byte[]>();
        byteParams.add(key);
        if (this.contains(EX)) {
            byteParams.add(SafeEncoder.encode(EX));
            byteParams.add(Protocol.toByteArray((Long)this.getParam(EX)));
        } else if (this.contains(PX)) {
            byteParams.add(SafeEncoder.encode(PX));
            byteParams.add(Protocol.toByteArray((Long)this.getParam(PX)));
        } else if (this.contains(EXAT)) {
            byteParams.add(SafeEncoder.encode(EXAT));
            byteParams.add(Protocol.toByteArray((Long)this.getParam(EXAT)));
        } else if (this.contains(PXAT)) {
            byteParams.add(SafeEncoder.encode(PXAT));
            byteParams.add(Protocol.toByteArray((Long)this.getParam(PXAT)));
        } else if (this.contains(PERSIST)) {
            byteParams.add(SafeEncoder.encode(PERSIST));
        }
        Collections.addAll(byteParams, args);
        return (byte[][])byteParams.toArray((T[])new byte[byteParams.size()][]);
    }
}

