/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.redis.jedis.params;

import io.lumine.mythic.utils.redis.jedis.Protocol;
import io.lumine.mythic.utils.redis.jedis.params.Params;
import io.lumine.mythic.utils.redis.jedis.util.SafeEncoder;
import java.util.ArrayList;

public class StrAlgoLCSParams
extends Params {
    private static final String LCS = "lcs";
    private static final String IDX = "idx";
    private static final String LEN = "len";
    private static final String WITHMATCHLEN = "withmatchlen";
    private static final String MINMATCHLEN = "minmatchlen";

    public static StrAlgoLCSParams StrAlgoLCSParams() {
        return new StrAlgoLCSParams();
    }

    public StrAlgoLCSParams idx() {
        this.addParam(IDX);
        return this;
    }

    public StrAlgoLCSParams len() {
        this.addParam(LEN);
        return this;
    }

    public StrAlgoLCSParams withMatchLen() {
        this.addParam(WITHMATCHLEN);
        return this;
    }

    public StrAlgoLCSParams minMatchLen(long minMatchLen) {
        this.addParam(MINMATCHLEN, minMatchLen);
        return this;
    }

    public byte[][] getByteParams(Protocol.Keyword keyword, byte[] argA, byte[] argB) {
        ArrayList<byte[]> byteParams = new ArrayList<byte[]>();
        byteParams.add(SafeEncoder.encode(LCS));
        byteParams.add(keyword.getRaw());
        byteParams.add(argA);
        byteParams.add(argB);
        if (this.contains(IDX)) {
            byteParams.add(SafeEncoder.encode(IDX));
        }
        if (this.contains(LEN)) {
            byteParams.add(SafeEncoder.encode(LEN));
        }
        if (this.contains(WITHMATCHLEN)) {
            byteParams.add(SafeEncoder.encode(WITHMATCHLEN));
        }
        if (this.contains(MINMATCHLEN)) {
            byteParams.add(SafeEncoder.encode(MINMATCHLEN));
            byteParams.add(Protocol.toByteArray((Long)this.getParam(MINMATCHLEN)));
        }
        return (byte[][])byteParams.toArray((T[])new byte[byteParams.size()][]);
    }
}

