/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.redis.jedis.params;

import io.lumine.mythic.utils.redis.jedis.Protocol;
import io.lumine.mythic.utils.redis.jedis.params.Params;
import io.lumine.mythic.utils.redis.jedis.util.SafeEncoder;
import java.util.ArrayList;
import java.util.Collections;

public class XAddParams
extends Params {
    private String id;
    private Long maxLen;
    private boolean approximateTrimming;
    private boolean exactTrimming;
    private boolean nomkstream;
    private String minId;
    private Long limit;

    public static XAddParams xAddParams() {
        return new XAddParams();
    }

    public XAddParams noMkStream() {
        this.nomkstream = true;
        return this;
    }

    public XAddParams id(String id) {
        this.id = id;
        return this;
    }

    public XAddParams maxLen(long maxLen) {
        this.maxLen = maxLen;
        return this;
    }

    public XAddParams minId(String minId) {
        this.minId = minId;
        return this;
    }

    public XAddParams approximateTrimming() {
        this.approximateTrimming = true;
        return this;
    }

    public XAddParams exactTrimming() {
        this.exactTrimming = true;
        return this;
    }

    public XAddParams limit(long limit) {
        this.limit = limit;
        return this;
    }

    public byte[][] getByteParams(byte[] key, byte[] ... args) {
        ArrayList<byte[]> byteParams = new ArrayList<byte[]>();
        byteParams.add(key);
        if (this.nomkstream) {
            byteParams.add(Protocol.Keyword.NOMKSTREAM.getRaw());
        }
        if (this.maxLen != null) {
            byteParams.add(Protocol.Keyword.MAXLEN.getRaw());
            if (this.approximateTrimming) {
                byteParams.add(Protocol.BYTES_TILDE);
            } else if (this.exactTrimming) {
                byteParams.add(Protocol.BYTES_EQUAL);
            }
            byteParams.add(Protocol.toByteArray(this.maxLen));
        } else if (this.minId != null) {
            byteParams.add(Protocol.Keyword.MINID.getRaw());
            if (this.approximateTrimming) {
                byteParams.add(Protocol.BYTES_TILDE);
            } else if (this.exactTrimming) {
                byteParams.add(Protocol.BYTES_EQUAL);
            }
            byteParams.add(SafeEncoder.encode(this.minId));
        }
        if (this.limit != null) {
            byteParams.add(Protocol.Keyword.LIMIT.getRaw());
            byteParams.add(Protocol.toByteArray(this.limit));
        }
        if (this.id != null) {
            byteParams.add(SafeEncoder.encode(this.id));
        } else {
            byteParams.add(Protocol.BYTES_ASTERISK);
        }
        Collections.addAll(byteParams, args);
        return (byte[][])byteParams.toArray((T[])new byte[byteParams.size()][]);
    }
}

