/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.serialize;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.lumine.mythic.utils.gson.GsonSerializable;
import io.lumine.mythic.utils.gson.JsonBuilder;
import io.lumine.mythic.utils.numbers.Numbers;
import io.lumine.mythic.utils.serialize.ChunkLocus;
import io.lumine.mythic.utils.serialize.ChunkPosition;
import io.lumine.mythic.utils.serialize.Position;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.util.Vector;

public final class BlockLocus
implements GsonSerializable {
    private final int x;
    private final int y;
    private final int z;
    @Nullable
    private transient Location bukkitLocation = null;

    public static BlockLocus deserialize(JsonElement element) {
        Preconditions.checkArgument(element.isJsonObject());
        JsonObject object = element.getAsJsonObject();
        Preconditions.checkArgument(object.has("x"));
        Preconditions.checkArgument(object.has("y"));
        Preconditions.checkArgument(object.has("z"));
        int x = object.get("x").getAsInt();
        int y = object.get("y").getAsInt();
        int z = object.get("z").getAsInt();
        return BlockLocus.of(x, y, z);
    }

    public static BlockLocus of(int x, int y, int z) {
        return new BlockLocus(x, y, z);
    }

    public static BlockLocus of(Location location) {
        Objects.requireNonNull(location, "location");
        return BlockLocus.of(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public static BlockLocus of(Block block) {
        Objects.requireNonNull(block, "block");
        return BlockLocus.of(block.getLocation());
    }

    private BlockLocus(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public synchronized Location toLocation(World world) {
        if (this.bukkitLocation == null) {
            this.bukkitLocation = new Location(world, (double)this.x, (double)this.y, (double)this.z);
        }
        return this.bukkitLocation.clone();
    }

    public Vector toVector() {
        return new Vector(this.x, this.y, this.z);
    }

    public Block toBlock(World world) {
        return this.toLocation(world).getBlock();
    }

    public Position toPosition(World world) {
        return Position.of((double)this.x, (double)this.y, (double)this.z, world);
    }

    public Position toPositionCenter(World world) {
        return Position.of((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5, world);
    }

    public ChunkPosition toChunk(World world) {
        return ChunkPosition.of(this.x >> 4, this.z >> 4, world);
    }

    public ChunkLocus toChunkLocus() {
        return ChunkLocus.of(this.x >> 4, this.z >> 4);
    }

    public boolean contains(Position position) {
        return this.equals(position.floor());
    }

    public BlockLocus getRelative(BlockFace face) {
        Objects.requireNonNull(face, "face");
        return BlockLocus.of(this.x + face.getModX(), this.y + face.getModY(), this.z + face.getModZ());
    }

    public BlockLocus getRelative(BlockFace face, int distance) {
        Objects.requireNonNull(face, "face");
        return BlockLocus.of(this.x + face.getModX() * distance, this.y + face.getModY() * distance, this.z + face.getModZ() * distance);
    }

    public BlockLocus add(Vector vector3i) {
        return this.add((int)vector3i.getX(), (int)vector3i.getY(), (int)vector3i.getZ());
    }

    public BlockLocus add(int x, int y, int z) {
        return BlockLocus.of(this.x + x, this.y + y, this.z + z);
    }

    public BlockLocus subtract(int x, int y, int z) {
        return this.add(-x, -y, -z);
    }

    public BlockLocus transform2D(double angle, double aboutX, double aboutZ, double translateX, double translateZ) {
        angle = Math.toRadians(angle);
        double x = (double)this.x - aboutX;
        double z = (double)this.z - aboutZ;
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double x2 = x * cos - z * sin;
        double z2 = x * sin + z * cos;
        return BlockLocus.of(Numbers.floor(x2 + aboutX + translateX), this.y, Numbers.floor(z2 + aboutZ + translateZ));
    }

    @Nonnull
    public JsonObject serialize() {
        return JsonBuilder.object().add("x", this.x).add("y", this.y).add("z", this.z).build();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlockLocus)) {
            return false;
        }
        BlockLocus other = (BlockLocus)o;
        return this.getX() == other.getX() && this.getY() == other.getY() && this.getZ() == other.getZ();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getX();
        result = result * 59 + this.getY();
        result = result * 59 + this.getZ();
        return result;
    }

    public String toString() {
        return "BlockLocus(x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ")";
    }
}

