/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.serialize;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Optl<T> {
    private static final Optl<?> EMPTY = new Optl();
    private T value;

    @Nonnull
    public static <T> Optl<T> empty() {
        Optl<?> t2 = EMPTY;
        return t2;
    }

    @Nonnull
    public static <T> Optl<T> of(@Nullable T value) {
        return new Optl<T>(value);
    }

    @Nonnull
    public static <T> Optl<T> fromOptional(@Nonnull Optl<T> value) {
        return value.isPresent() ? Optl.of(value.get()) : Optl.empty();
    }

    private Optl() {
        this.value = null;
    }

    private Optl(@Nullable T value) {
        this.value = value;
    }

    @Nullable
    public T get() {
        if (!this.isPresent()) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    @Nonnull
    public Optional<T> asOptional() {
        return this.isPresent() ? Optional.ofNullable(this.value) : Optional.empty();
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public void ifPresent(@Nonnull Consumer<? super T> consumer) {
        if (this.isPresent()) {
            consumer.accept(this.value);
        }
    }

    @Nonnull
    public Optl<T> filter(@Nonnull Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        if (!this.isPresent()) {
            return this;
        }
        return predicate.test(this.value) ? this : Optl.empty();
    }

    @Nonnull
    public <U> Optl<U> map(@Nonnull Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        if (!this.isPresent()) {
            return Optl.empty();
        }
        return Optl.of(mapper.apply(this.value));
    }

    @Nonnull
    public <U> Optl<U> flatMap(@Nonnull Function<? super T, Optl<U>> mapper) {
        Objects.requireNonNull(mapper);
        if (!this.isPresent()) {
            return Optl.empty();
        }
        return Objects.requireNonNull(mapper.apply(this.value));
    }

    @Nullable
    public T orElse(@Nullable T other) {
        return this.isPresent() ? this.value : other;
    }

    @Nullable
    public T orElseGet(@Nonnull Supplier<? extends T> other) {
        return this.isPresent() ? this.value : other.get();
    }

    @Nullable
    public <X extends Throwable> T orElseThrow(@Nonnull Supplier<? extends X> exceptionSupplier) throws X {
        if (this.isPresent()) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Optl)) {
            return false;
        }
        Optl other = (Optl)obj;
        return this.isPresent() == other.isPresent() && Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        if (!this.isPresent()) {
            return -1;
        }
        return Objects.hashCode(this.value);
    }

    public String toString() {
        return this.isPresent() ? String.format("Optl[%s]", this.value) : "Optl.empty";
    }
}

