/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.storage.players.adapters.file;

import io.lumine.mythic.utils.gson.GsonProvider;
import io.lumine.mythic.utils.logging.Log;
import io.lumine.mythic.utils.plugin.LuminePlugin;
import io.lumine.mythic.utils.promise.Promise;
import io.lumine.mythic.utils.storage.players.Profile;
import io.lumine.mythic.utils.storage.players.adapters.FilePlayerStorageAdapter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Optional;
import java.util.UUID;

public class JsonPlayerStorageAdapter<T extends LuminePlugin, P extends Profile>
extends FilePlayerStorageAdapter<T, P> {
    private Class<P> clazz;

    public JsonPlayerStorageAdapter(T plugin, Class<P> clazz) {
        super(plugin);
        this.clazz = clazz;
    }

    @Override
    public void load(T plugin) {
    }

    @Override
    public void unload() {
    }

    @Override
    public Promise<Optional<P>> load(UUID key) {
        return Promise.supplyingAsync(() -> {
            Optional<Profile> optional;
            File file = this.getFile(key.toString());
            if (!file.exists()) {
                return Optional.empty();
            }
            FileReader reader = new FileReader(file);
            try {
                optional = Optional.of((Profile)GsonProvider.standard().fromJson((Reader)reader, this.clazz));
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Log.severe("Failed to load Json Profile in: " + this.getClass().getName());
                    e.printStackTrace();
                    return Optional.empty();
                }
            }
            reader.close();
            return optional;
        });
    }

    @Override
    public Promise<Boolean> save(UUID key, P object) {
        return Promise.supplyingAsync(() -> {
            Boolean bl;
            File file = this.getFile(key.toString());
            if (!file.exists()) {
                try {
                    file.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            FileWriter writer = new FileWriter(file);
            try {
                GsonProvider.standard().toJson((Object)object, (Appendable)writer);
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Log.severe("Failed to save Json Profile in: " + this.getClass().getName());
                    e.printStackTrace();
                    return false;
                }
            }
            writer.close();
            return bl;
        });
    }

    @Override
    protected File getFile(String key) {
        return new File(this.getStorageDirectory(), key + ".json");
    }
}

