/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.terminable.composite;

import io.lumine.mythic.utils.terminable.Terminable;
import io.lumine.mythic.utils.terminable.composite.CompositeClosingException;
import io.lumine.mythic.utils.terminable.composite.CompositeTerminable;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedDeque;

public class AbstractCompositeTerminable
implements CompositeTerminable {
    private final Deque<AutoCloseable> closeables = new ConcurrentLinkedDeque<AutoCloseable>();

    protected AbstractCompositeTerminable() {
    }

    @Override
    public CompositeTerminable with(AutoCloseable autoCloseable) {
        Objects.requireNonNull(autoCloseable, "autoCloseable");
        this.closeables.push(autoCloseable);
        return this;
    }

    @Override
    public void close() throws CompositeClosingException {
        AutoCloseable ac;
        ArrayList<Exception> caught = new ArrayList<Exception>();
        while ((ac = this.closeables.poll()) != null) {
            try {
                ac.close();
            }
            catch (Exception e) {
                caught.add(e);
            }
        }
        if (!caught.isEmpty()) {
            throw new CompositeClosingException(caught);
        }
    }

    @Override
    public void cleanup() {
        this.closeables.removeIf(ac -> {
            if (!(ac instanceof Terminable)) {
                return false;
            }
            if (ac instanceof CompositeTerminable) {
                ((CompositeTerminable)ac).cleanup();
            }
            return ((Terminable)ac).isClosed();
        });
    }
}

