/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.text;

import io.lumine.mythic.utils.adventure.audience.Audience;
import io.lumine.mythic.utils.adventure.inventory.Book;
import io.lumine.mythic.utils.adventure.text.Component;
import io.lumine.mythic.utils.adventure.text.minimessage.MiniMessage;
import io.lumine.mythic.utils.plugin.LoaderUtils;
import java.util.Collection;
import org.bukkit.entity.Player;

public final class Books {
    private static final MiniMessage bookParser = MiniMessage.get();

    public static Book createBook(String title, String author, Collection<String> pages) {
        Component bookTitle = bookParser.parse(title);
        Component bookAuthor = bookParser.parse(author);
        Book.Builder builder = Book.builder().title(bookTitle).author(bookAuthor);
        for (String page : pages) {
            builder.addPage(bookParser.parse(page));
        }
        return builder.build();
    }

    public static Book createBook(String title, String author, String ... pages) {
        Component bookTitle = bookParser.parse(title);
        Component bookAuthor = bookParser.parse(author);
        Book.Builder builder = Book.builder().title(bookTitle).author(bookAuthor);
        for (String page : pages) {
            builder.addPage(bookParser.parse(page));
        }
        return builder.build();
    }

    public static void openBook(Player player, Book book) {
        Audience audience = LoaderUtils.getPlugin().adventure().player(player);
        audience.openBook(book);
    }
}

