/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.text;

import io.lumine.mythic.utils.adventure.key.Key;
import io.lumine.mythic.utils.adventure.text.Component;
import io.lumine.mythic.utils.adventure.text.KeybindComponent;
import io.lumine.mythic.utils.adventure.text.TextComponent;
import io.lumine.mythic.utils.adventure.text.TranslatableComponent;
import io.lumine.mythic.utils.adventure.text.event.ClickEvent;
import io.lumine.mythic.utils.adventure.text.event.HoverEvent;
import io.lumine.mythic.utils.adventure.text.format.NamedTextColor;
import io.lumine.mythic.utils.adventure.text.format.Style;
import io.lumine.mythic.utils.adventure.text.format.TextColor;
import io.lumine.mythic.utils.adventure.text.format.TextDecoration;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class NestedSerializer {
    private NestedSerializer() {
    }

    public static @NonNull String serialize(@NonNull Component component) {
        List<ComponentNode> list = NestedSerializer.recursiveTraversal(new ComponentNode(component));
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            Style previous = i - 1 >= 0 ? list.get(i - 1).getStyle() : null;
            Style next = i + 1 < list.size() ? list.get(i + 1).getStyle() : null;
            ComponentNode node = list.get(i);
            sb.append(NestedSerializer.serializeNode(node, previous, next));
        }
        return sb.toString();
    }

    private static List<ComponentNode> recursiveTraversal(ComponentNode root) {
        LinkedList<ComponentNode> list = new LinkedList<ComponentNode>();
        list.add(root);
        if (!root.getComponent().children().isEmpty()) {
            for (Component child : root.getComponent().children()) {
                list.addAll(NestedSerializer.recursiveTraversal(new ComponentNode(child, root.getStyle())));
            }
        }
        return list;
    }

    private static String serializeNode(@NonNull ComponentNode node, @Nullable Style previous, @Nullable Style next) {
        Key font;
        String insert;
        ClickEvent click;
        HoverEvent<?> hov;
        StringBuilder sb = new StringBuilder();
        Style style = node.getStyle();
        if (style.color() != null && (previous == null || previous.color() != style.color())) {
            sb.append(NestedSerializer.startColor(Objects.requireNonNull(style.color())));
        }
        if (style.hasDecoration(TextDecoration.BOLD) && (previous == null || !previous.hasDecoration(TextDecoration.BOLD))) {
            sb.append(NestedSerializer.startTag("bold"));
        }
        if (style.hasDecoration(TextDecoration.ITALIC) && (previous == null || !previous.hasDecoration(TextDecoration.ITALIC))) {
            sb.append(NestedSerializer.startTag("italic"));
        }
        if (style.hasDecoration(TextDecoration.OBFUSCATED) && (previous == null || !previous.hasDecoration(TextDecoration.OBFUSCATED))) {
            sb.append(NestedSerializer.startTag("obfuscated"));
        }
        if (style.hasDecoration(TextDecoration.STRIKETHROUGH) && (previous == null || !previous.hasDecoration(TextDecoration.STRIKETHROUGH))) {
            sb.append(NestedSerializer.startTag("strikethrough"));
        }
        if (style.hasDecoration(TextDecoration.UNDERLINED) && (previous == null || !previous.hasDecoration(TextDecoration.UNDERLINED))) {
            sb.append(NestedSerializer.startTag("underlined"));
        }
        if ((hov = style.hoverEvent()) != null && (previous == null || NestedSerializer.areDifferent(hov, previous.hoverEvent())) && hov.value() instanceof Component) {
            sb.append(NestedSerializer.startTag(String.format("%s:%s:\"%s\"", "hover", HoverEvent.Action.NAMES.key(hov.action()), NestedSerializer.serialize((Component)hov.value()))));
        }
        if ((click = style.clickEvent()) != null && (previous == null || NestedSerializer.areDifferent(click, previous.clickEvent()))) {
            sb.append(NestedSerializer.startTag(String.format("%s:%s:\"%s\"", "click", ClickEvent.Action.NAMES.key(click.action()), click.value())));
        }
        if (!((insert = style.insertion()) == null || previous != null && insert.equals(previous.insertion()))) {
            sb.append(NestedSerializer.startTag("insert:" + insert));
        }
        if (!((font = style.font()) == null || previous != null && font.equals(previous.font()))) {
            sb.append(NestedSerializer.startTag("font:" + font.asString()));
        }
        if (node.getComponent() instanceof TextComponent) {
            sb.append(((TextComponent)node.getComponent()).content());
        } else {
            NestedSerializer.handleDifferentComponent(node.getComponent(), sb);
        }
        if (next != null && style.color() != null && next.color() != style.color()) {
            sb.append(NestedSerializer.endColor(Objects.requireNonNull(style.color())));
        }
        if (next != null) {
            if (style.hasDecoration(TextDecoration.BOLD) && !next.hasDecoration(TextDecoration.BOLD)) {
                sb.append(NestedSerializer.endTag("bold"));
            }
            if (style.hasDecoration(TextDecoration.ITALIC) && !next.hasDecoration(TextDecoration.ITALIC)) {
                sb.append(NestedSerializer.endTag("italic"));
            }
            if (style.hasDecoration(TextDecoration.OBFUSCATED) && !next.hasDecoration(TextDecoration.OBFUSCATED)) {
                sb.append(NestedSerializer.endTag("obfuscated"));
            }
            if (style.hasDecoration(TextDecoration.STRIKETHROUGH) && !next.hasDecoration(TextDecoration.STRIKETHROUGH)) {
                sb.append(NestedSerializer.endTag("strikethrough"));
            }
            if (style.hasDecoration(TextDecoration.UNDERLINED) && !next.hasDecoration(TextDecoration.UNDERLINED)) {
                sb.append(NestedSerializer.endTag("underlined"));
            }
        }
        if (next != null && style.hoverEvent() != null && NestedSerializer.areDifferent(Objects.requireNonNull(style.hoverEvent()), next.hoverEvent())) {
            sb.append(NestedSerializer.endTag("hover"));
        }
        if (next != null && style.clickEvent() != null && NestedSerializer.areDifferent(Objects.requireNonNull(style.clickEvent()), next.clickEvent())) {
            sb.append(NestedSerializer.endTag("click"));
        }
        if (next != null && style.insertion() != null && !Objects.equals(style.insertion(), next.insertion())) {
            sb.append(NestedSerializer.endTag("insert"));
        }
        if (next != null && style.font() != null && !Objects.equals(style.font(), next.font())) {
            sb.append(NestedSerializer.endTag("font"));
        }
        return sb.toString();
    }

    private static boolean areDifferent(@NonNull ClickEvent c1, @Nullable ClickEvent c2) {
        if (c2 == null) {
            return true;
        }
        return !c1.equals(c2) && (!c1.action().equals((Object)c2.action()) || !c1.value().equals(c2.value()));
    }

    private static boolean areDifferent(@NonNull HoverEvent<?> h1, @Nullable HoverEvent<?> h2) {
        if (h2 == null) {
            return true;
        }
        return !h1.equals(h2) && !h1.action().equals(h2.action());
    }

    private static @NonNull String startColor(@NonNull TextColor color) {
        if (color instanceof NamedTextColor) {
            return NestedSerializer.startTag(Objects.requireNonNull(NamedTextColor.NAMES.key((NamedTextColor)color)));
        }
        return NestedSerializer.startTag("color:" + color.asHexString());
    }

    private static @NonNull String endColor(@NonNull TextColor color) {
        if (color instanceof NamedTextColor) {
            return NestedSerializer.endTag(Objects.requireNonNull(NamedTextColor.NAMES.key((NamedTextColor)color)));
        }
        return NestedSerializer.endTag("color:" + color.asHexString());
    }

    private static @NonNull String startTag(@NonNull String content) {
        return "<" + content + ">";
    }

    private static @NonNull String endTag(@NonNull String content) {
        return "</" + content + ">";
    }

    private static void handleDifferentComponent(@NonNull Component component, @NonNull StringBuilder sb) {
        if (component instanceof KeybindComponent) {
            sb.append(NestedSerializer.startTag("key:" + ((KeybindComponent)component).keybind()));
        } else if (component instanceof TranslatableComponent) {
            sb.append(NestedSerializer.startTag("lang:" + ((TranslatableComponent)component).key()));
        }
    }

    private static class ComponentNode {
        private final Component component;
        private final Style style;

        public ComponentNode(@NonNull Component component) {
            this(component, null);
        }

        public ComponentNode(@NonNull Component component, @Nullable Style parent) {
            this.component = component;
            this.style = parent == null ? component.style() : component.style().merge(parent, Style.Merge.Strategy.IF_ABSENT_ON_TARGET);
        }

        public Component getComponent() {
            return this.component;
        }

        public Style getStyle() {
            return this.style;
        }
    }
}

