/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.text;

import io.lumine.mythic.utils.adventure.platform.bukkit.BukkitAudiences;
import io.lumine.mythic.utils.adventure.text.Component;
import io.lumine.mythic.utils.adventure.text.TextComponent;
import io.lumine.mythic.utils.adventure.text.format.NamedTextColor;
import io.lumine.mythic.utils.adventure.text.format.TextDecoration;
import io.lumine.mythic.utils.adventure.text.minimessage.MiniMessage;
import io.lumine.mythic.utils.adventure.text.serializer.bungeecord.BungeeComponentSerializer;
import io.lumine.mythic.utils.adventure.text.serializer.gson.GsonComponentSerializer;
import io.lumine.mythic.utils.adventure.text.serializer.legacy.LegacyComponentSerializer;
import io.lumine.mythic.utils.plugin.LoaderUtils;
import io.lumine.mythic.utils.text.NestedSerializer;
import io.lumine.mythic.utils.version.MinecraftVersions;
import io.lumine.mythic.utils.version.ServerVersion;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public final class Text {
    private static BukkitAudiences adventure = null;
    private static final Pattern URL_PATTERN = Pattern.compile("(?:(https?)://)?([-\\w_.]+\\.\\w{2,})(/\\S*)?");
    public static final char SECTION_CHAR = '\u00a7';
    public static final char AMPERSAND_CHAR = '&';
    private static final LegacyComponentSerializer unusualSectionRGB = LegacyComponentSerializer.builder().character('\u00a7').hexCharacter('#').hexColors().useUnusualXRepeatedCharacterHexFormat().build();
    private static final int CENTER_PX = 154;

    @NotNull
    public static Component parse(String text) {
        Component component = MiniMessage.get().parse(NestedSerializer.serialize(unusualSectionRGB.deserialize(Text.colorize(text))));
        if (component.decorations().get(TextDecoration.ITALIC) == TextDecoration.State.NOT_SET) {
            component = component.decoration(TextDecoration.ITALIC, TextDecoration.State.FALSE);
        }
        return component.colorIfAbsent(NamedTextColor.WHITE);
    }

    public static String joinNewline(String ... strings) {
        return Text.joinNewline(Arrays.stream(strings));
    }

    public static String joinNewline(Stream<String> strings) {
        return strings.collect(Collectors.joining("\n"));
    }

    public static Component fromLegacy(String input, char character) {
        return LegacyComponentSerializer.legacy(character).deserialize(input);
    }

    public static Component fromLegacy(String input) {
        return LegacyComponentSerializer.legacySection().deserialize(input);
    }

    public static String toLegacy(Component component, char character) {
        return LegacyComponentSerializer.legacy(character).serialize(component);
    }

    public static String toLegacy(Component component) {
        return LegacyComponentSerializer.legacySection().serialize(component);
    }

    public static Component fromBungee(BaseComponent[] component) {
        if (ServerVersion.isAfter(MinecraftVersions.v1_15)) {
            return BungeeComponentSerializer.get().deserialize(component);
        }
        return BungeeComponentSerializer.legacy().deserialize(component);
    }

    public static BaseComponent[] toBungee(Component component) {
        if (ServerVersion.isAfter(MinecraftVersions.v1_15)) {
            return BungeeComponentSerializer.get().serialize(component);
        }
        return BungeeComponentSerializer.legacy().serialize(component);
    }

    public static Component fromJson(String input) {
        return GsonComponentSerializer.gson().deserialize(input);
    }

    public static String toJson(Component component) {
        return (String)GsonComponentSerializer.gson().serialize(component);
    }

    public static void sendMessage(CommandSender sender, String message) {
        Text.sendMessage(sender, Text.parse(message));
    }

    public static void sendMessage(CommandSender sender, String ... message) {
        TextComponent out = Component.empty();
        for (String m4 : message) {
            out.append(Text.parse(m4));
        }
        Text.sendMessage(sender, (Component)out);
    }

    public static void sendMessage(CommandSender sender, Component ... message) {
        Text.sendMessage(sender, (Component)TextComponent.ofChildren(message));
    }

    public static void sendMessage(CommandSender sender, Component message) {
        if (adventure == null) {
            adventure = LoaderUtils.getPlugin().adventure();
        }
        adventure.sender(sender).sendMessage(message);
    }

    public static void sendMessage(Iterable<CommandSender> senders, Component ... message) {
        Text.sendMessage(senders, (Component)TextComponent.ofChildren(message));
    }

    public static void sendMessage(Iterable<CommandSender> senders, Component message) {
        if (adventure == null) {
            adventure = LoaderUtils.getPlugin().adventure();
        }
        senders.forEach(sender -> adventure.sender((CommandSender)sender).sendMessage(message));
    }

    public static void sendActionBar(CommandSender sender, String message) {
        Text.sendActionBar(sender, Text.parse(message));
    }

    public static void sendActionBar(CommandSender sender, String ... message) {
        TextComponent out = Component.empty();
        for (String m4 : message) {
            out.append(Text.parse(m4));
        }
        Text.sendActionBar(sender, (Component)out);
    }

    public static void sendActionBar(CommandSender sender, Component ... message) {
        Text.sendActionBar(sender, (Component)TextComponent.ofChildren(message));
    }

    public static void sendActionBar(CommandSender sender, Component message) {
        if (adventure == null) {
            adventure = LoaderUtils.getPlugin().adventure();
        }
        adventure.sender(sender).sendActionBar(message);
    }

    public static void sendActionBar(Iterable<CommandSender> senders, Component ... message) {
        Text.sendActionBar(senders, (Component)TextComponent.ofChildren(message));
    }

    public static void sendActionBar(Iterable<CommandSender> senders, Component message) {
        if (adventure == null) {
            adventure = LoaderUtils.getPlugin().adventure();
        }
        senders.forEach(sender -> adventure.sender((CommandSender)sender).sendActionBar(message));
    }

    public static BaseComponent[] colorizeBungee(String s2) {
        Component component = MiniMessage.get().parse(s2);
        return Text.toBungee(component);
    }

    public static String colorizeLegacy(String s2) {
        Component component = MiniMessage.get().parse(s2);
        return Text.toLegacy(component);
    }

    @Deprecated
    public static String colorize(String s2) {
        return s2 == null ? null : Text.translateAlternateColorCodes('&', '\u00a7', s2);
    }

    @Deprecated
    public static String decolorize(String s2) {
        return s2 == null ? null : Text.translateAlternateColorCodes('\u00a7', '&', s2);
    }

    public static String translateAlternateColorCodes(char from, char to, String textToTranslate) {
        char[] b = textToTranslate.toCharArray();
        for (int i = 0; i < b.length - 1; ++i) {
            if (b[i] != from || "0123456789AaBbCcDdEeFfKkLlMmNnOoRr".indexOf(b[i + 1]) <= -1) continue;
            b[i] = to;
            b[i + 1] = Character.toLowerCase(b[i + 1]);
        }
        return new String(b);
    }

    public static TextComponent extractUrl(TextComponent component) {
        return component;
    }

    public static String center(String message) {
        return Text.getSpacesToCenter(message) + message;
    }

    public static String getSpacesToCenter(String message) {
        message = Text.colorizeLegacy(message);
        int messagePxSize = 0;
        boolean previousCode = false;
        boolean isBold = false;
        for (char c : message.toCharArray()) {
            if (c == '\u00a7') {
                previousCode = true;
                continue;
            }
            if (previousCode) {
                previousCode = false;
                isBold = c == 'l' || c == 'L';
                continue;
            }
            DefaultFontInfo dFI = DefaultFontInfo.getDefaultFontInfo(c);
            messagePxSize += isBold ? dFI.getBoldLength() : dFI.getLength();
            ++messagePxSize;
        }
        int halvedMessageSize = messagePxSize / 2;
        int toCompensate = 154 - halvedMessageSize;
        int spaceLength = DefaultFontInfo.SPACE.getLength() + 1;
        StringBuilder sb = new StringBuilder();
        for (int compensated = 0; compensated < toCompensate; compensated += spaceLength) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public static String getSpacesToEdge(String message, int pixels) {
        message = Text.colorizeLegacy(message);
        int messagePxSize = 0;
        boolean previousCode = false;
        boolean isBold = false;
        for (char c : message.toCharArray()) {
            if (c == '\u00a7') {
                previousCode = true;
                continue;
            }
            if (previousCode) {
                previousCode = false;
                isBold = c == 'l' || c == 'L';
                continue;
            }
            DefaultFontInfo dFI = DefaultFontInfo.getDefaultFontInfo(c);
            messagePxSize += isBold ? dFI.getBoldLength() : dFI.getLength();
            ++messagePxSize;
        }
        int toCompensate = pixels - messagePxSize;
        int spaceLength = DefaultFontInfo.SPACE.getLength() + 1;
        StringBuilder sb = new StringBuilder();
        for (int compensated = 0; compensated < toCompensate; compensated += spaceLength) {
            sb.append(" ");
        }
        return sb.toString();
    }

    private Text() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }

    public static enum DefaultFontInfo {
        A('A', 5),
        a('a', 5),
        B('B', 5),
        b('b', 5),
        C('C', 5),
        c('c', 5),
        D('D', 5),
        d('d', 5),
        E('E', 5),
        e('e', 5),
        F('F', 5),
        f('f', 4),
        G('G', 5),
        g('g', 5),
        H('H', 5),
        h('h', 5),
        I('I', 3),
        i('i', 1),
        J('J', 5),
        j('j', 5),
        K('K', 5),
        k('k', 4),
        L('L', 5),
        l('l', 1),
        M('M', 5),
        m('m', 5),
        N('N', 5),
        n('n', 5),
        O('O', 5),
        o('o', 5),
        P('P', 5),
        p('p', 5),
        Q('Q', 5),
        q('q', 5),
        R('R', 5),
        r('r', 5),
        S('S', 5),
        s('s', 5),
        T('T', 5),
        t('t', 4),
        U('U', 5),
        u('u', 5),
        V('V', 5),
        v('v', 5),
        W('W', 5),
        w('w', 5),
        X('X', 5),
        x('x', 5),
        Y('Y', 5),
        y('y', 5),
        Z('Z', 5),
        z('z', 5),
        NUM_1('1', 5),
        NUM_2('2', 5),
        NUM_3('3', 5),
        NUM_4('4', 5),
        NUM_5('5', 5),
        NUM_6('6', 5),
        NUM_7('7', 5),
        NUM_8('8', 5),
        NUM_9('9', 5),
        NUM_0('0', 5),
        EXCLAMATION_POINT('!', 1),
        AT_SYMBOL('@', 6),
        NUM_SIGN('#', 5),
        DOLLAR_SIGN('$', 5),
        PERCENT('%', 5),
        UP_ARROW('^', 5),
        AMPERSAND('&', 5),
        ASTERISK('*', 5),
        LEFT_PARENTHESIS('(', 4),
        RIGHT_PERENTHESIS(')', 4),
        MINUS('-', 5),
        UNDERSCORE('_', 5),
        PLUS_SIGN('+', 5),
        EQUALS_SIGN('=', 5),
        LEFT_CURL_BRACE('{', 4),
        RIGHT_CURL_BRACE('}', 4),
        LEFT_BRACKET('[', 3),
        RIGHT_BRACKET(']', 3),
        COLON(':', 1),
        SEMI_COLON(';', 1),
        DOUBLE_QUOTE('\"', 3),
        SINGLE_QUOTE('\'', 1),
        LEFT_ARROW('<', 4),
        RIGHT_ARROW('>', 4),
        QUESTION_MARK('?', 5),
        SLASH('/', 5),
        BACK_SLASH('\\', 5),
        LINE('|', 1),
        TILDE('~', 5),
        TICK('`', 2),
        PERIOD('.', 1),
        COMMA(',', 1),
        SPACE(' ', 3),
        DEFAULT('a', 4);

        private final char character;
        private final int length;

        private DefaultFontInfo(char character, int length) {
            this.character = character;
            this.length = length;
        }

        public static DefaultFontInfo getDefaultFontInfo(char c) {
            for (DefaultFontInfo dFI : DefaultFontInfo.values()) {
                if (dFI.getCharacter() != c) continue;
                return dFI;
            }
            return DEFAULT;
        }

        public char getCharacter() {
            return this.character;
        }

        public int getLength() {
            return this.length;
        }

        public int getBoldLength() {
            if (this == SPACE) {
                return this.getLength();
            }
            return this.length + 1;
        }
    }
}

