/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.time;

import java.time.Duration;
import java.time.temporal.ChronoUnit;

public enum DurationFormatter {
    LONG,
    CONCISE{

        @Override
        protected String formatUnitPlural(ChronoUnit unit) {
            return String.valueOf(Character.toLowerCase(unit.name().charAt(0)));
        }

        @Override
        protected String formatUnitSingular(ChronoUnit unit) {
            return this.formatUnitPlural(unit);
        }
    }
    ,
    CONCISE_LOW_ACCURACY(3){

        @Override
        protected String formatUnitPlural(ChronoUnit unit) {
            return String.valueOf(Character.toLowerCase(unit.name().charAt(0)));
        }

        @Override
        protected String formatUnitSingular(ChronoUnit unit) {
            return this.formatUnitPlural(unit);
        }
    };

    private final Unit[] units = new Unit[]{new Unit(ChronoUnit.YEARS), new Unit(ChronoUnit.MONTHS), new Unit(ChronoUnit.WEEKS), new Unit(ChronoUnit.DAYS), new Unit(ChronoUnit.HOURS), new Unit(ChronoUnit.MINUTES), new Unit(ChronoUnit.SECONDS)};
    private final int accuracy;

    private DurationFormatter() {
        this(Integer.MAX_VALUE);
    }

    private DurationFormatter(int accuracy) {
        this.accuracy = accuracy;
    }

    public String format(Duration duration) {
        long seconds = duration.getSeconds();
        StringBuilder output = new StringBuilder();
        int outputSize = 0;
        for (Unit unit : this.units) {
            long n = seconds / unit.duration;
            if (n > 0L) {
                seconds -= unit.duration * n;
                output.append(' ').append(n).append(unit.toString(n));
                ++outputSize;
            }
            if (seconds <= 0L || outputSize >= this.accuracy) break;
        }
        if (output.length() == 0) {
            return "0" + this.units[this.units.length - 1].stringPlural;
        }
        return output.substring(1);
    }

    protected String formatUnitPlural(ChronoUnit unit) {
        return " " + unit.name().toLowerCase();
    }

    protected String formatUnitSingular(ChronoUnit unit) {
        String s2 = unit.name().toLowerCase();
        return " " + s2.substring(0, s2.length() - 1);
    }

    private final class Unit {
        private final long duration;
        private final String stringPlural;
        private final String stringSingular;

        Unit(ChronoUnit unit) {
            this.duration = unit.getDuration().getSeconds();
            this.stringPlural = DurationFormatter.this.formatUnitPlural(unit);
            this.stringSingular = DurationFormatter.this.formatUnitSingular(unit);
        }

        public String toString(long n) {
            return n == 1L ? this.stringSingular : this.stringPlural;
        }
    }
}

