/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.version;

import io.lumine.mythic.utils.version.MinecraftVersions;
import java.util.Comparator;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class MinecraftVersion
implements Comparable<MinecraftVersion> {
    public static final Comparator<MinecraftVersion> COMPARATOR = Comparator.nullsFirst(Comparator.comparingInt(MinecraftVersion::getMajor).thenComparingInt(MinecraftVersion::getMinor).thenComparingInt(MinecraftVersion::getBuild));
    private final int major;
    private final int minor;
    private final int build;

    public static MinecraftVersion getRuntimeVersion() {
        return MinecraftVersions.RUNTIME_VERSION;
    }

    public static MinecraftVersion of(int major, int minor, int build) {
        return new MinecraftVersion(major, minor, build);
    }

    public static MinecraftVersion parse(String version) throws IllegalArgumentException {
        int[] versionComponents;
        String[] parts = version.split("-");
        try {
            versionComponents = MinecraftVersion.parseVersion(parts[0]);
        }
        catch (IllegalStateException ex) {
            return MinecraftVersion.of(1, 0, 0);
        }
        int major = versionComponents[0];
        int minor = versionComponents[1];
        int build = versionComponents[2];
        return MinecraftVersion.of(major, minor, build);
    }

    private static int[] parseVersion(String version) {
        String[] elements = version.split("\\.");
        int[] numbers = new int[3];
        if (elements.length < 1) {
            throw new IllegalStateException("Corrupt MC version: " + version);
        }
        for (int i = 0; i < Math.min(numbers.length, elements.length); ++i) {
            numbers[i] = Integer.parseInt(elements[i].trim());
        }
        return numbers;
    }

    private MinecraftVersion(int major, int minor, int build) {
        this.major = major;
        this.minor = minor;
        this.build = build;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getBuild() {
        return this.build;
    }

    @Nonnull
    public String getVersion() {
        return String.format("%s.%s.%s", this.getMajor(), this.getMinor(), this.getBuild());
    }

    @Override
    public int compareTo(MinecraftVersion that) {
        return COMPARATOR.compare(this, that);
    }

    public boolean isAfter(MinecraftVersion other) {
        return this.compareTo(other) > 0;
    }

    public boolean isAfterOrEq(MinecraftVersion other) {
        return this.compareTo(other) >= 0;
    }

    public boolean isBefore(MinecraftVersion other) {
        return this.compareTo(other) < 0;
    }

    public boolean isBeforeOrEq(MinecraftVersion other) {
        return this.compareTo(other) <= 0;
    }

    public boolean isBetween(MinecraftVersion o1, MinecraftVersion o2) {
        return this.isAfterOrEq(o1) && this.isBeforeOrEq(o2) || this.isBeforeOrEq(o1) && this.isAfterOrEq(o2);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MinecraftVersion)) {
            return false;
        }
        MinecraftVersion other = (MinecraftVersion)obj;
        return this.getMajor() == other.getMajor() && this.getMinor() == other.getMinor() && this.getBuild() == other.getBuild();
    }

    public int hashCode() {
        return Objects.hash(this.getMajor(), this.getMinor(), this.getBuild());
    }

    public String toString() {
        return String.format("(MC: %s)", this.getVersion());
    }
}

