/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythic.utils.worldedit;

import com.google.common.collect.Lists;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormats;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardReader;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.transform.AffineTransform;
import com.sk89q.worldedit.math.transform.Transform;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.session.ClipboardHolder;
import com.sk89q.worldedit.session.SessionOwner;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import io.lumine.mythic.utils.logging.Log;
import io.lumine.mythic.utils.numbers.Numbers;
import io.lumine.mythic.utils.serialize.Locus;
import io.lumine.mythic.utils.serialize.Position;
import io.lumine.mythic.utils.serialize.Region;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;

public final class Regions {
    public static WorldEdit getWorldEdit() {
        return WorldEdit.getInstance();
    }

    public static BlockVector3 toWEVector(Position from) {
        return BlockVector3.at((double)from.getX(), (double)from.getY(), (double)from.getZ());
    }

    public static BlockVector3 toWEVector(Locus from) {
        return BlockVector3.at((double)from.getX(), (double)from.getY(), (double)from.getZ());
    }

    public static Locus fromWEVector(BlockVector3 from) {
        return Locus.of(from.getX(), from.getY(), from.getZ());
    }

    public static Position fromWEVector(BlockVector3 from, World fromWorld) {
        org.bukkit.World world = BukkitAdapter.adapt((World)fromWorld);
        return Position.of((double)from.getX(), (double)from.getY(), (double)from.getZ(), world);
    }

    public static com.sk89q.worldedit.regions.Region toWERegion(Region from) {
        World world = BukkitAdapter.adapt((org.bukkit.World)from.getMin().toLocation().getWorld());
        BlockVector3 min2 = Regions.toWEVector(from.getMin());
        BlockVector3 max = Regions.toWEVector(from.getMax());
        return new CuboidRegion(world, min2, max);
    }

    public static Region fromWERegion(com.sk89q.worldedit.regions.Region from) {
        Position min2 = Regions.fromWEVector(from.getMinimumPoint(), from.getWorld());
        Position max = Regions.fromWEVector(from.getMaximumPoint(), from.getWorld());
        return Region.of(min2, max);
    }

    public static World toWEWorld(Position from) {
        return BukkitAdapter.adapt((org.bukkit.World)from.toLocation().getWorld());
    }

    public static Optional<Region> getPlayerSelection(Player player) {
        BukkitPlayer absPlayer = BukkitAdapter.adapt((Player)player);
        LocalSession session = WorldEdit.getInstance().getSessionManager().getIfPresent((SessionOwner)absPlayer);
        World absWorld = session.getSelectionWorld();
        try {
            if (absWorld == null) {
                return Optional.empty();
            }
            com.sk89q.worldedit.regions.Region region = session.getSelection(absWorld);
            if (region != null) {
                org.bukkit.World world = BukkitAdapter.adapt((World)region.getWorld());
                BlockVector3 min2 = region.getMinimumPoint();
                BlockVector3 max = region.getMaximumPoint();
                return Optional.of(Region.of(Position.of((double)min2.getX(), (double)min2.getY(), (double)min2.getZ(), world), Position.of((double)max.getX(), (double)max.getY(), (double)max.getZ(), world)));
            }
            return Optional.empty();
        }
        catch (Error | Exception ex) {
            ex.printStackTrace();
            return Optional.empty();
        }
    }

    public static void setRegion(Region region, Material material) {
        com.sk89q.worldedit.regions.Region weRegion = Regions.toWERegion(region);
        try (EditSession editSession = WorldEdit.getInstance().newEditSession(weRegion.getWorld());){
            BaseBlock to = BukkitAdapter.adapt((BlockData)material.createBlockData()).toBaseBlock();
            try {
                editSession.setBlocks(weRegion, (BlockStateHolder)to);
                editSession.flushSession();
            }
            catch (Error | Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void replaceRegion(Region region, Collection<Material> replace, Material material) {
        com.sk89q.worldedit.regions.Region weRegion = Regions.toWERegion(region);
        try (EditSession editSession = WorldEdit.getInstance().newEditSession(weRegion.getWorld());){
            HashSet<BaseBlock> baseBlocks = new HashSet<BaseBlock>();
            for (Material m4 : replace) {
                baseBlocks.add(BukkitAdapter.adapt((BlockData)m4.createBlockData()).toBaseBlock());
            }
            BaseBlock to = BukkitAdapter.adapt((BlockData)material.createBlockData()).toBaseBlock();
            try {
                editSession.replaceBlocks(weRegion, baseBlocks, (BlockStateHolder)to);
                editSession.flushSession();
            }
            catch (Error | Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static Optional<Clipboard> loadSchematic(File schematicFile) {
        Optional<Clipboard> optional;
        block10: {
            if (!schematicFile.exists()) {
                Log.error("Schematic file " + schematicFile.getAbsolutePath() + " doesnt exist");
                return Optional.empty();
            }
            ClipboardFormat schematicFormat = ClipboardFormats.findByFile((File)schematicFile);
            if (schematicFormat == null) {
                Log.error("Schematic file " + schematicFile.getAbsolutePath() + " is corrupt");
                return Optional.empty();
            }
            ClipboardReader reader = schematicFormat.getReader((InputStream)new FileInputStream(schematicFile));
            try {
                optional = Optional.ofNullable(reader.read());
                if (reader == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return Optional.empty();
                }
            }
            reader.close();
        }
        return optional;
    }

    public static void pasteSchematic(Clipboard schematic, Position pasteLocation) {
        Regions.pasteSchematic(schematic, pasteLocation, 0, false);
    }

    public static void pasteSchematic(Clipboard schematic, Position pasteLocation, boolean ignoreAir) {
        Regions.pasteSchematic(schematic, pasteLocation, 0, false);
    }

    public static void pasteSchematic(Clipboard schematic, Position pasteLocation, int rotation, boolean ignoreAir) {
        BlockVector3 pastePosition = BlockVector3.at((int)Numbers.floor(pasteLocation.getX()), (int)Numbers.floor(pasteLocation.getY()), (int)Numbers.floor(pasteLocation.getZ()));
        World faweWorld = Regions.toWEWorld(pasteLocation);
        schematic.setOrigin(schematic.getMinimumPoint());
        try (EditSession editSession = WorldEdit.getInstance().newEditSession(faweWorld);){
            ClipboardHolder holder = new ClipboardHolder(schematic);
            if (rotation != 0) {
                AffineTransform tr = new AffineTransform();
                tr = tr.rotateY((double)rotation);
                holder.setTransform((Transform)tr);
            }
            Operation operation = holder.createPaste((Extent)editSession).to(pastePosition).ignoreAirBlocks(ignoreAir).build();
            try {
                Operations.complete((Operation)operation);
            }
            catch (WorldEditException e) {
                e.printStackTrace();
            }
            editSession.flushSession();
        }
    }

    public static Collection<Position> pasteSchematic(Clipboard schematic, Position pasteLocation, int rotation, boolean ignoreAir, Collection<Material> blockPositions) {
        BlockVector3 pastePosition = BlockVector3.at((int)Numbers.floor(pasteLocation.getX()), (int)Numbers.floor(pasteLocation.getY()), (int)Numbers.floor(pasteLocation.getZ()));
        World faweWorld = Regions.toWEWorld(pasteLocation);
        BlockVector3 origin = schematic.getOrigin();
        schematic.setOrigin(schematic.getMinimumPoint());
        try (EditSession editSession = WorldEdit.getInstance().newEditSession(faweWorld);){
            ClipboardHolder holder = new ClipboardHolder(schematic);
            if (rotation != 0) {
                AffineTransform tr = new AffineTransform();
                tr = tr.rotateY((double)rotation);
                holder.setTransform((Transform)tr);
            }
            ArrayList<Position> ret = Lists.newArrayList();
            for (int x = schematic.getMinimumPoint().getX(); x <= schematic.getMaximumPoint().getX(); ++x) {
                for (int y = schematic.getMinimumPoint().getY(); y <= schematic.getMaximumPoint().getY(); ++y) {
                    for (int z = schematic.getMinimumPoint().getZ(); z <= schematic.getMaximumPoint().getZ(); ++z) {
                        BaseBlock state = schematic.getFullBlock(BlockVector3.at((int)x, (int)y, (int)z));
                        double ax = pastePosition.getX() + x - schematic.getMinimumPoint().getBlockX();
                        double ay = pastePosition.getY() + y - schematic.getMinimumPoint().getBlockY();
                        double az = pastePosition.getZ() + z - schematic.getMinimumPoint().getBlockZ();
                        if (state.getBlockType() != BlockTypes.CHEST) continue;
                        ret.add(Position.of(ax, ay, az, pasteLocation.getWorld()));
                    }
                }
            }
            Operation operation = holder.createPaste((Extent)editSession).to(pastePosition).ignoreAirBlocks(ignoreAir).build();
            try {
                Operations.complete((Operation)operation);
            }
            catch (WorldEditException e) {
                e.printStackTrace();
            }
            editSession.flushSession();
            ArrayList<Position> arrayList = ret;
            return arrayList;
        }
    }
}

