/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.shadow;

import io.lumine.shadow.Shadow;
import io.lumine.shadow.ShadowFactory;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Array;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@Target(value={ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface ShadowingStrategy {
    public @NonNull Class<? extends Wrapper> wrapper() default Wrapper.class;

    public @NonNull Class<? extends Unwrapper> unwrapper() default Unwrapper.class;

    public static enum ForShadowArrays implements Wrapper,
    Unwrapper
    {
        INSTANCE;


        @Override
        public @Nullable Object wrap(@Nullable Object unwrapped, @NonNull Class<?> expectedType, @NonNull ShadowFactory shadowFactory) {
            if (unwrapped == null) {
                return null;
            }
            Class<?> unwrappedType = unwrapped.getClass();
            if (!unwrappedType.isArray()) {
                throw new RuntimeException("Object to be wrapped is not an array: " + unwrappedType);
            }
            if (!expectedType.isArray()) {
                throw new RuntimeException("Expected type is not an array: " + expectedType);
            }
            Class<?> wrappedArrayComponentType = expectedType.getComponentType();
            if (!Shadow.class.isAssignableFrom(wrappedArrayComponentType)) {
                throw new RuntimeException("Expected type is not an array of shadow components: " + wrappedArrayComponentType);
            }
            Object[] unwrappedArray = (Object[])unwrapped;
            Object[] wrappedArray = (Object[])Array.newInstance(wrappedArrayComponentType, unwrappedArray.length);
            for (int i = 0; i < unwrappedArray.length; ++i) {
                Object o = unwrappedArray[i];
                if (o == null) continue;
                wrappedArray[i] = shadowFactory.shadow(wrappedArrayComponentType, o);
            }
            return wrappedArray;
        }

        @Override
        public @Nullable Object unwrap(@Nullable Object wrapped, @NonNull Class<?> expectedType, @NonNull ShadowFactory shadowFactory) throws Exception {
            if (wrapped == null) {
                return null;
            }
            Class<?> wrappedType = wrapped.getClass();
            if (!wrappedType.isArray()) {
                throw new RuntimeException("Object to be unwrapped is not an array: " + wrappedType);
            }
            if (!expectedType.isArray()) {
                throw new RuntimeException("Expected type is not an array: " + expectedType);
            }
            Class<?> wrappedArrayComponentType = wrappedType.getComponentType();
            if (!Shadow.class.isAssignableFrom(wrappedArrayComponentType)) {
                throw new RuntimeException("Wrapped type is not an array of shadow components: " + wrappedArrayComponentType);
            }
            Object[] wrappedArray = (Object[])wrapped;
            Object[] unwrappedArray = (Object[])Array.newInstance(expectedType.getComponentType(), wrappedArray.length);
            for (int i = 0; i < wrappedArray.length; ++i) {
                Object o = wrappedArray[i];
                if (o == null) continue;
                unwrappedArray[i] = ((Shadow)o).getShadowTarget();
            }
            return unwrappedArray;
        }

        @Override
        public @NonNull Class<?> unwrap(Class<?> wrappedClass, @NonNull ShadowFactory shadowFactory) {
            if (!wrappedClass.isArray()) {
                throw new RuntimeException("Object to be unwrapped is not an array: " + wrappedClass);
            }
            Class<?> unwrappedComponentType = shadowFactory.getTargetClass(wrappedClass.getComponentType());
            return Array.newInstance(unwrappedComponentType, 0).getClass();
        }
    }

    public static enum ForShadows implements Wrapper,
    Unwrapper
    {
        INSTANCE;


        @Override
        public @Nullable Object wrap(@Nullable Object unwrapped, @NonNull Class<?> expectedType, @NonNull ShadowFactory shadowFactory) {
            if (unwrapped == null) {
                return null;
            }
            if (Shadow.class.isAssignableFrom(expectedType)) {
                return shadowFactory.shadow(expectedType, unwrapped);
            }
            return unwrapped;
        }

        @Override
        public @Nullable Object unwrap(@Nullable Object wrapped, @NonNull Class<?> expectedType, @NonNull ShadowFactory shadowFactory) {
            if (wrapped == null) {
                return null;
            }
            if (wrapped instanceof Shadow) {
                Shadow shadow = (Shadow)wrapped;
                return shadow.getShadowTarget();
            }
            return wrapped;
        }

        @Override
        public @NonNull Class<?> unwrap(Class<?> wrappedClass, @NonNull ShadowFactory shadowFactory) {
            return shadowFactory.getTargetClass(wrappedClass);
        }
    }

    public static enum None implements Wrapper,
    Unwrapper
    {
        INSTANCE;


        @Override
        public @Nullable Object wrap(@Nullable Object unwrapped, @NonNull Class<?> expectedType, @NonNull ShadowFactory shadowFactory) {
            return unwrapped;
        }

        @Override
        public @Nullable Object unwrap(@Nullable Object wrapped, @NonNull Class<?> expectedType, @NonNull ShadowFactory shadowFactory) {
            return wrapped;
        }

        @Override
        public @NonNull Class<?> unwrap(Class<?> wrappedClass, @NonNull ShadowFactory shadowFactory) {
            return wrappedClass;
        }
    }

    public static interface Unwrapper {
        public @Nullable Object unwrap(@Nullable Object var1, @NonNull Class<?> var2, @NonNull ShadowFactory var3) throws Exception;

        public @NonNull Class<?> unwrap(Class<?> var1, @NonNull ShadowFactory var2);

        default public @NonNull Object[] unwrapAll(@Nullable Object[] wrapped, @NonNull Class<?>[] expectedTypes, @NonNull ShadowFactory shadowFactory) throws Exception {
            if (wrapped.length != expectedTypes.length) {
                throw new IllegalStateException("wrapped.length != expectedTypes.length");
            }
            Object[] unwrapped = new Object[wrapped.length];
            for (int i = 0; i < wrapped.length; ++i) {
                unwrapped[i] = this.unwrap(wrapped[i], expectedTypes[i], shadowFactory);
            }
            return unwrapped;
        }

        default public @NonNull Class<?>[] unwrapAll(@NonNull Class<?>[] wrapped, @NonNull ShadowFactory shadowFactory) throws Exception {
            Class[] unwrapped = new Class[wrapped.length];
            for (int i = 0; i < wrapped.length; ++i) {
                unwrapped[i] = this.unwrap(wrapped[i], shadowFactory);
            }
            return unwrapped;
        }
    }

    @FunctionalInterface
    public static interface Wrapper {
        public @Nullable Object wrap(@Nullable Object var1, @NonNull Class<?> var2, @NonNull ShadowFactory var3) throws Exception;
    }
}

