/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.inventory;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.material.MaterialData;
import org.jetbrains.annotations.NotNull;

public class ShapedRecipe
implements Recipe,
Keyed {
    private final NamespacedKey key;
    private final ItemStack output;
    private String[] rows;
    private Map<Character, RecipeChoice> ingredients = new HashMap<Character, RecipeChoice>();
    private String group = "";

    @Deprecated
    public ShapedRecipe(@NotNull ItemStack result) {
        Preconditions.checkArgument((result.getType() != Material.AIR ? 1 : 0) != 0, (Object)"Recipe must have non-AIR result.");
        this.key = NamespacedKey.randomKey();
        new Throwable("Warning: A plugin is creating a recipe using a Deprecated method. This will cause you to receive warnings stating 'Tried to load unrecognized recipe: bukkit:<ID>'. Please ask the author to give their recipe a static key using NamespacedKey.").printStackTrace();
        this.output = new ItemStack(result);
    }

    public ShapedRecipe(@NotNull NamespacedKey key, @NotNull ItemStack result) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key");
        Preconditions.checkArgument((result.getType() != Material.AIR ? 1 : 0) != 0, (Object)"Recipe must have non-AIR result.");
        this.key = key;
        this.output = new ItemStack(result);
    }

    @NotNull
    public ShapedRecipe shape(String ... shape) {
        Preconditions.checkArgument((shape != null ? 1 : 0) != 0, (Object)"Must provide a shape");
        Preconditions.checkArgument((shape.length > 0 && shape.length < 4 ? 1 : 0) != 0, (String)"Crafting recipes should be 1, 2 or 3 rows, not ", (int)shape.length);
        int lastLen = -1;
        for (String row : shape) {
            Preconditions.checkArgument((row != null ? 1 : 0) != 0, (Object)"Shape cannot have null rows");
            Preconditions.checkArgument((row.length() > 0 && row.length() < 4 ? 1 : 0) != 0, (String)"Crafting rows should be 1, 2, or 3 characters, not ", (int)row.length());
            Preconditions.checkArgument((lastLen == -1 || lastLen == row.length() ? 1 : 0) != 0, (Object)"Crafting recipes must be rectangular");
            lastLen = row.length();
        }
        this.rows = new String[shape.length];
        for (int i = 0; i < shape.length; ++i) {
            this.rows[i] = shape[i];
        }
        HashMap<Character, RecipeChoice> newIngredients = new HashMap<Character, RecipeChoice>();
        for (String row : shape) {
            char[] cArray = row.toCharArray();
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                Character c = Character.valueOf(cArray[i]);
                newIngredients.put(c, this.ingredients.get(c));
            }
        }
        this.ingredients = newIngredients;
        return this;
    }

    @Deprecated
    @NotNull
    public ShapedRecipe setIngredient(char key, @NotNull MaterialData ingredient) {
        return this.setIngredient(key, ingredient.getItemType(), ingredient.getData());
    }

    @NotNull
    public ShapedRecipe setIngredient(char key, @NotNull Material ingredient) {
        return this.setIngredient(key, ingredient, 0);
    }

    @Deprecated
    @NotNull
    public ShapedRecipe setIngredient(char key, @NotNull Material ingredient, int raw) {
        Preconditions.checkArgument((boolean)this.ingredients.containsKey(Character.valueOf(key)), (String)"Symbol does not appear in the shape:", (char)key);
        if (raw == -1) {
            raw = Short.MAX_VALUE;
        }
        this.ingredients.put(Character.valueOf(key), new RecipeChoice.MaterialChoice(Collections.singletonList(ingredient)));
        return this;
    }

    @NotNull
    public ShapedRecipe setIngredient(char key, @NotNull RecipeChoice ingredient) {
        Preconditions.checkArgument((boolean)this.ingredients.containsKey(Character.valueOf(key)), (String)"Symbol does not appear in the shape:", (char)key);
        this.ingredients.put(Character.valueOf(key), ingredient);
        return this;
    }

    @NotNull
    public ShapedRecipe setIngredient(char key, @NotNull ItemStack item) {
        return this.setIngredient(key, new RecipeChoice.ExactChoice(item));
    }

    @NotNull
    public Map<Character, ItemStack> getIngredientMap() {
        HashMap<Character, ItemStack> result = new HashMap<Character, ItemStack>();
        for (Map.Entry<Character, RecipeChoice> ingredient : this.ingredients.entrySet()) {
            if (ingredient.getValue() == null) {
                result.put(ingredient.getKey(), null);
                continue;
            }
            result.put(ingredient.getKey(), ingredient.getValue().getItemStack().clone());
        }
        return result;
    }

    @NotNull
    public Map<Character, RecipeChoice> getChoiceMap() {
        HashMap<Character, RecipeChoice> result = new HashMap<Character, RecipeChoice>();
        for (Map.Entry<Character, RecipeChoice> ingredient : this.ingredients.entrySet()) {
            if (ingredient.getValue() == null) {
                result.put(ingredient.getKey(), null);
                continue;
            }
            result.put(ingredient.getKey(), ingredient.getValue().clone());
        }
        return result;
    }

    @NotNull
    public String[] getShape() {
        return (String[])this.rows.clone();
    }

    @Override
    @NotNull
    public ItemStack getResult() {
        return this.output.clone();
    }

    @Override
    @NotNull
    public NamespacedKey getKey() {
        return this.key;
    }

    @NotNull
    public String getGroup() {
        return this.group;
    }

    public void setGroup(@NotNull String group) {
        Preconditions.checkArgument((group != null ? 1 : 0) != 0, (Object)"group");
        this.group = group;
    }
}

