/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.event.block;

import com.google.common.base.Preconditions;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Projectile;
import org.bukkit.event.HandlerList;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public class TargetHitEvent
extends ProjectileHitEvent {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private int signalStrength;

    @ApiStatus.Internal
    public TargetHitEvent(@NotNull Projectile projectile, @NotNull Block block, @NotNull BlockFace blockFace, int signalStrength) {
        super(projectile, null, block, blockFace);
        this.signalStrength = signalStrength;
    }

    public @Range(from=0L, to=15L) int getSignalStrength() {
        return this.signalStrength;
    }

    public void setSignalStrength(@Range(from=0L, to=15L) int signalStrength) {
        Preconditions.checkArgument((signalStrength >= 0 && signalStrength <= 15 ? 1 : 0) != 0, (String)"Signal strength out of range (%s), must be in range [0,15]", (int)signalStrength);
        this.signalStrength = signalStrength;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }
}

