/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.event.player;

import com.google.common.base.Preconditions;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class PlayerShieldDisableEvent
extends PlayerEvent
implements Cancellable {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final Entity damager;
    private int cooldown;
    private boolean cancelled;

    @ApiStatus.Internal
    public PlayerShieldDisableEvent(@NotNull Player player, @NotNull Entity damager, int cooldown) {
        super(player);
        this.damager = damager;
        this.cooldown = cooldown;
    }

    @NotNull
    public Entity getDamager() {
        return this.damager;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void setCooldown(int cooldown) {
        Preconditions.checkArgument((cooldown >= 0 ? 1 : 0) != 0, (Object)"The cooldown has to be equal to or greater than 0!");
        this.cooldown = cooldown;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }
}

