/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.event.server;

import com.destroystokyo.paper.profile.PlayerProfile;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class WhitelistStateUpdateEvent
extends Event
implements Cancellable {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    @NotNull
    private final PlayerProfile playerProfile;
    @NotNull
    private final WhitelistStatus status;
    private boolean cancelled;

    @ApiStatus.Internal
    public WhitelistStateUpdateEvent(@NotNull PlayerProfile playerProfile, @NotNull WhitelistStatus status) {
        this.playerProfile = playerProfile;
        this.status = status;
    }

    @NotNull
    public OfflinePlayer getPlayer() {
        return Bukkit.getOfflinePlayer(this.playerProfile.getId());
    }

    @NotNull
    public PlayerProfile getPlayerProfile() {
        return this.playerProfile;
    }

    @NotNull
    public WhitelistStatus getStatus() {
        return this.status;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }

    public static enum WhitelistStatus {
        ADDED,
        REMOVED;

    }
}

