/*
 * Decompiled with CFR 0.152.
 */
package mineverse.Aust1n46.chat;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.utility.MinecraftReflection;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import mineverse.Aust1n46.chat.ChatMessage;
import mineverse.Aust1n46.chat.LogLevels;
import mineverse.Aust1n46.chat.VentureChatPlaceholders;
import mineverse.Aust1n46.chat.alias.AliasInfo;
import mineverse.Aust1n46.chat.api.MineverseChatAPI;
import mineverse.Aust1n46.chat.api.MineverseChatPlayer;
import mineverse.Aust1n46.chat.api.events.VentureChatEvent;
import mineverse.Aust1n46.chat.channel.ChatChannel;
import mineverse.Aust1n46.chat.channel.ChatChannelInfo;
import mineverse.Aust1n46.chat.command.MineverseCommand;
import mineverse.Aust1n46.chat.command.MineverseCommandExecutor;
import mineverse.Aust1n46.chat.command.chat.Broadcast;
import mineverse.Aust1n46.chat.command.chat.BungeeToggle;
import mineverse.Aust1n46.chat.command.chat.Channel;
import mineverse.Aust1n46.chat.command.chat.Channelinfo;
import mineverse.Aust1n46.chat.command.chat.Chatinfo;
import mineverse.Aust1n46.chat.command.chat.Chatreload;
import mineverse.Aust1n46.chat.command.chat.Chlist;
import mineverse.Aust1n46.chat.command.chat.Chwho;
import mineverse.Aust1n46.chat.command.chat.Clearchat;
import mineverse.Aust1n46.chat.command.chat.Commandblock;
import mineverse.Aust1n46.chat.command.chat.Commandspy;
import mineverse.Aust1n46.chat.command.chat.Config;
import mineverse.Aust1n46.chat.command.chat.Edit;
import mineverse.Aust1n46.chat.command.chat.Filter;
import mineverse.Aust1n46.chat.command.chat.Force;
import mineverse.Aust1n46.chat.command.chat.Forceall;
import mineverse.Aust1n46.chat.command.chat.Kickchannel;
import mineverse.Aust1n46.chat.command.chat.Kickchannelall;
import mineverse.Aust1n46.chat.command.chat.Leave;
import mineverse.Aust1n46.chat.command.chat.Listen;
import mineverse.Aust1n46.chat.command.chat.Me;
import mineverse.Aust1n46.chat.command.chat.Nick;
import mineverse.Aust1n46.chat.command.chat.Party;
import mineverse.Aust1n46.chat.command.chat.RangedSpy;
import mineverse.Aust1n46.chat.command.chat.Removemessage;
import mineverse.Aust1n46.chat.command.chat.Setchannel;
import mineverse.Aust1n46.chat.command.chat.Setchannelall;
import mineverse.Aust1n46.chat.command.chat.VentureChatGui;
import mineverse.Aust1n46.chat.command.chat.Venturechat;
import mineverse.Aust1n46.chat.command.message.Ignore;
import mineverse.Aust1n46.chat.command.message.Message;
import mineverse.Aust1n46.chat.command.message.MessageToggle;
import mineverse.Aust1n46.chat.command.message.Notifications;
import mineverse.Aust1n46.chat.command.message.Reply;
import mineverse.Aust1n46.chat.command.message.Spy;
import mineverse.Aust1n46.chat.command.mute.Mute;
import mineverse.Aust1n46.chat.command.mute.Muteall;
import mineverse.Aust1n46.chat.command.mute.Unmute;
import mineverse.Aust1n46.chat.command.mute.Unmuteall;
import mineverse.Aust1n46.chat.database.Database;
import mineverse.Aust1n46.chat.database.MySQL;
import mineverse.Aust1n46.chat.database.PlayerData;
import mineverse.Aust1n46.chat.gui.GuiSlotInfo;
import mineverse.Aust1n46.chat.json.JsonFormatInfo;
import mineverse.Aust1n46.chat.listeners.ChatListener;
import mineverse.Aust1n46.chat.listeners.CommandListener;
import mineverse.Aust1n46.chat.listeners.LoginListener;
import mineverse.Aust1n46.chat.listeners.PacketListener;
import mineverse.Aust1n46.chat.listeners.SignListener;
import mineverse.Aust1n46.chat.localization.Localization;
import mineverse.Aust1n46.chat.localization.LocalizedMessage;
import mineverse.Aust1n46.chat.utilities.Format;
import mineverse.Aust1n46.chat.versions.V1_8;
import mineverse.Aust1n46.chat.versions.VersionHandler;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Sound;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.bukkit.scheduler.BukkitScheduler;

public class MineverseChat
extends JavaPlugin
implements PluginMessageListener {
    private ChatListener chatListener;
    private LoginListener loginListener;
    private SignListener signListener;
    private CommandListener commandListener;
    private Channel channelListener;
    public static String[] playerlist;
    public static String playerlist_server;
    public boolean ircListen;
    public static ChatMessage lastChatMessage;
    public static String lastJson;
    public static Method messageMethod;
    public static Field posField;
    public static Class<?> chatMessageType;
    private static Field commandMap;
    private static Field knownCommands;
    private MineverseCommandExecutor commandExecutor;
    private Map<String, MineverseCommand> commands = new HashMap<String, MineverseCommand>();
    public Database db = null;
    public static AliasInfo aaInfo;
    public static JsonFormatInfo jfInfo;
    public static GuiSlotInfo gsInfo;
    public boolean quickchat = true;
    private static final Logger log;
    public static Set<MineverseChatPlayer> players;
    public static Set<MineverseChatPlayer> onlinePlayers;
    public static HashMap<String, String> networkPlayers;
    private boolean firstRun = true;
    public static final String PLUGIN_MESSAGING_CHANNEL = "venturechat:data";
    public static final boolean ASYNC = true;
    public static final boolean SYNC = false;
    public static Permission permission;
    public static Chat chat;
    public static CommandMap cmap;
    public Map<String, String> mutes = new HashMap<String, String>();
    private LogLevels curLogLevel;
    public long LINELENGTH = 40L;
    @Deprecated
    public static ChatChannelInfo ccInfo;

    static {
        log = Logger.getLogger("Minecraft");
        players = new HashSet<MineverseChatPlayer>();
        onlinePlayers = new HashSet<MineverseChatPlayer>();
        networkPlayers = new HashMap();
        permission = null;
        chat = null;
    }

    public static void main(String[] args) {
    }

    public void onEnable() {
        ccInfo = new ChatChannelInfo();
        try {
            File file;
            Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&e - Initializing..."));
            if (!this.getDataFolder().exists()) {
                this.getDataFolder().mkdirs();
            }
            if (!(file = new File(this.getDataFolder(), "config.yml")).exists()) {
                Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&e - Config not found! Generating file."));
                this.saveDefaultConfig();
            } else {
                Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&e - Config found! Loading file."));
            }
            this.saveResource("defaultconfig.yml", true);
        }
        catch (Exception ex) {
            log.severe(String.format("[" + String.format("VentureChat", new Object[0]) + "]" + " - Could not load configuration!\n " + ex, this.getDescription().getName()));
        }
        this.setLogLevel(this.getConfig().getString("loglevel", "INFO").toUpperCase());
        ChatChannel.initialize();
        Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&e - Checking for Vault..."));
        if (!this.setupPermissions()) {
            Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&e - &cCould not find Vault dependency, disabling."));
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
        }
        this.setupChat();
        Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&e - Enabled Successfully"));
        Localization.initialize();
        Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&e - Registering Listeners"));
        aaInfo = new AliasInfo(this);
        jfInfo = new JsonFormatInfo(this);
        gsInfo = new GuiSlotInfo();
        PlayerData.initialize();
        if (this.firstRun) {
            for (String uuidString : PlayerData.getPlayerData().getConfigurationSection("players").getKeys(false)) {
                UUID uuid = UUID.fromString(uuidString);
                String name = PlayerData.getPlayerData().getConfigurationSection("players." + uuid).getString("name");
                String currentChannelName = PlayerData.getPlayerData().getConfigurationSection("players." + uuid).getString("current");
                ChatChannel currentChannel = ChatChannel.isChannel(currentChannelName) ? ChatChannel.getChannel(currentChannelName) : ChatChannel.getDefaultChannel();
                HashSet<UUID> ignores = new HashSet<UUID>();
                StringTokenizer i = new StringTokenizer(PlayerData.getPlayerData().getConfigurationSection("players." + uuidString).getString("ignores"), ",");
                while (i.hasMoreTokens()) {
                    ignores.add(UUID.fromString(i.nextToken()));
                }
                HashSet<String> listening = new HashSet<String>();
                StringTokenizer l = new StringTokenizer(PlayerData.getPlayerData().getConfigurationSection("players." + uuidString).getString("listen"), ",");
                while (l.hasMoreTokens()) {
                    String channel = l.nextToken();
                    if (!ChatChannel.isChannel(channel)) continue;
                    listening.add(channel);
                }
                HashMap<String, Integer> mutes = new HashMap<String, Integer>();
                StringTokenizer m = new StringTokenizer(PlayerData.getPlayerData().getConfigurationSection("players." + uuidString).getString("mutes"), ",");
                while (m.hasMoreTokens()) {
                    String[] parts = m.nextToken().split(":");
                    if (!ChatChannel.isChannel(parts[0])) continue;
                    if (parts[1].equals("null")) {
                        log.info("[VentureChat] Null Mute Time: " + parts[0] + " " + name);
                        continue;
                    }
                    mutes.put(ChatChannel.getChannel(parts[0]).getName(), Integer.parseInt(parts[1]));
                }
                HashSet<String> blockedCommands = new HashSet<String>();
                StringTokenizer b = new StringTokenizer(PlayerData.getPlayerData().getConfigurationSection("players." + uuidString).getString("blockedcommands"), ",");
                while (b.hasMoreTokens()) {
                    blockedCommands.add(b.nextToken());
                }
                boolean host = PlayerData.getPlayerData().getConfigurationSection("players." + uuidString).getBoolean("host");
                UUID party = PlayerData.getPlayerData().getConfigurationSection("players." + uuidString).getString("party").length() > 0 ? UUID.fromString(PlayerData.getPlayerData().getConfigurationSection("players." + uuidString).getString("party")) : null;
                boolean filter = PlayerData.getPlayerData().getConfigurationSection("players." + uuidString).getBoolean("filter");
                boolean notifications = PlayerData.getPlayerData().getConfigurationSection("players." + uuidString).getBoolean("notifications");
                String nickname = PlayerData.getPlayerData().getConfigurationSection("players." + uuidString).getString("nickname");
                String jsonFormat = "Default";
                boolean spy = PlayerData.getPlayerData().getConfigurationSection("players." + uuidString).getBoolean("spy", false);
                boolean commandSpy = PlayerData.getPlayerData().getConfigurationSection("players." + uuidString).getBoolean("commandspy", false);
                boolean rangedSpy = PlayerData.getPlayerData().getConfigurationSection("players." + uuidString).getBoolean("rangedspy", false);
                boolean messageToggle = PlayerData.getPlayerData().getConfigurationSection("players." + uuidString).getBoolean("messagetoggle", true);
                boolean bungeeToggle = PlayerData.getPlayerData().getConfigurationSection("players." + uuidString).getBoolean("bungeetoggle", true);
                players.add(new MineverseChatPlayer(uuid, name, currentChannel, ignores, listening, mutes, blockedCommands, host, party, filter, notifications, nickname, jsonFormat, spy, commandSpy, rangedSpy, messageToggle, bungeeToggle));
            }
        }
        for (Player p : this.getServer().getOnlinePlayers()) {
            MineverseChatPlayer mcp = MineverseChatAPI.getMineverseChatPlayer(p);
            mcp.setName(p.getName());
            mcp.setOnline(true);
            mcp.setHasPlayed(false);
            mcp.setJsonFormat();
            onlinePlayers.add(mcp);
        }
        FileConfiguration config = this.getConfig();
        ConfigurationSection mysqlConfig = config.getConfigurationSection("mysql");
        if (this.getConfig().getConfigurationSection("mysql").getBoolean("enabled")) {
            String host = mysqlConfig.getString("host");
            int port = mysqlConfig.getInt("port");
            String database = mysqlConfig.getString("database");
            String user = mysqlConfig.getString("user");
            String password = mysqlConfig.getString("password");
            this.db = new MySQL(host, port, database, user, password);
        }
        this.commands.put("broadcast", new Broadcast("broadcast"));
        this.commands.put("channel", new Channel("channel"));
        this.commands.put("join", new Channel("join"));
        this.commands.put("channelinfo", new Channelinfo("channelinfo"));
        this.commands.put("chatinfo", new Chatinfo("chatinfo"));
        this.commands.put("chatreload", new Chatreload("chatreload"));
        this.commands.put("chlist", new Chlist("chlist"));
        this.commands.put("chwho", new Chwho("chwho"));
        this.commands.put("clearchat", new Clearchat("clearchat"));
        this.commands.put("commandblock", new Commandblock("commandblock"));
        this.commands.put("commandspy", new Commandspy("commandspy"));
        this.commands.put("config", new Config("config"));
        this.commands.put("edit", new Edit("edit"));
        this.commands.put("filter", new Filter("filter"));
        this.commands.put("force", new Force("force"));
        this.commands.put("forceall", new Forceall("forceall"));
        this.commands.put("ignore", new Ignore("ignore"));
        this.commands.put("kickchannel", new Kickchannel("kickchannel"));
        this.commands.put("kickchannelall", new Kickchannelall("kickchannelall"));
        this.commands.put("leave", new Leave("leave"));
        this.commands.put("listen", new Listen("listen"));
        this.commands.put("me", new Me("me"));
        this.commands.put("message", new Message("message"));
        this.commands.put("tell", new Message("tell"));
        this.commands.put("whisper", new Message("whisper"));
        this.commands.put("venturechat", new Venturechat("venturechat"));
        this.commands.put("mute", new Mute("mute"));
        this.commands.put("muteall", new Muteall("muteall"));
        this.commands.put("setnickname", new Nick("setnickname"));
        this.commands.put("notifications", new Notifications("notifications"));
        this.commands.put("party", new Party("party"));
        this.commands.put("rangedspy", new RangedSpy("rangedspy"));
        this.commands.put("removemessage", new Removemessage("removemessage"));
        this.commands.put("reply", new Reply("reply"));
        this.commands.put("setchannel", new Setchannel("setchannel"));
        this.commands.put("setchannelall", new Setchannelall("setchannelall"));
        this.commands.put("spy", new Spy("spy"));
        this.commands.put("unmute", new Unmute("unmute"));
        this.commands.put("unmuteall", new Unmuteall("unmuteall"));
        this.commands.put("venturechatgui", new VentureChatGui("venturechatgui"));
        this.commands.put("messagetoggle", new MessageToggle("messagetoggle"));
        this.commands.put("bungeetoggle", new BungeeToggle("bungeetoggle"));
        this.commandExecutor = new MineverseCommandExecutor(this.commands);
        for (String command : this.commands.keySet()) {
            this.getCommand(command).setExecutor((CommandExecutor)this.commandExecutor);
        }
        this.channelListener = new Channel();
        this.signListener = new SignListener();
        this.chatListener = new ChatListener();
        this.commandListener = new CommandListener(aaInfo);
        PluginManager pluginManager = this.getServer().getPluginManager();
        pluginManager.registerEvents((Listener)this.channelListener, (Plugin)this);
        pluginManager.registerEvents((Listener)this.chatListener, (Plugin)this);
        pluginManager.registerEvents((Listener)this.signListener, (Plugin)this);
        pluginManager.registerEvents((Listener)this.commandListener, (Plugin)this);
        this.loginListener = new LoginListener();
        pluginManager.registerEvents((Listener)this.loginListener, (Plugin)this);
        this.registerPacketListeners();
        this.loadNMS();
        Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&e - Attaching to Executors"));
        try {
            if (VersionHandler.is1_8()) {
                cmap = V1_8.v1_8();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.quickchat = false;
        if (cmap == null) {
            this.quickchat = false;
        }
        Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&e - Establishing BungeeCord"));
        Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)this, PLUGIN_MESSAGING_CHANNEL);
        Bukkit.getMessenger().registerIncomingPluginChannel((Plugin)this, PLUGIN_MESSAGING_CHANNEL, (PluginMessageListener)this);
        if (pluginManager.isPluginEnabled("Towny")) {
            Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&e - Enabling Towny Formatting"));
        }
        if (pluginManager.isPluginEnabled("Jobs")) {
            Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&e - Enabling Jobs Formatting"));
        }
        if (pluginManager.isPluginEnabled("Factions")) {
            String version = pluginManager.getPlugin("Factions").getDescription().getVersion();
            Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&e - Enabling Factions Formatting version " + version));
        }
        if (pluginManager.isPluginEnabled("Heroes")) {
            Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&e - Enabling Heroes Formatting"));
        }
        if (pluginManager.isPluginEnabled("PlaceholderAPI")) {
            Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&e - Enabling PlaceholderAPI Hook"));
        }
        new VentureChatPlaceholders().register();
        Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&e - Loading player data"));
        BukkitScheduler scheduler = Bukkit.getServer().getScheduler();
        scheduler.runTaskTimerAsynchronously((Plugin)this, new Runnable(){

            @Override
            public void run() {
                PlayerData.savePlayerData();
                if (MineverseChat.this.getConfig().getString("loglevel", "info").equals("debug")) {
                    Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&e - Saving Player Data"));
                }
            }
        }, 0L, (long)(this.getConfig().getInt("saveinterval") * 1200));
        scheduler.runTaskTimerAsynchronously((Plugin)this, new Runnable(){

            @Override
            public void run() {
                for (MineverseChatPlayer p : onlinePlayers) {
                    int time = Format.currentTimeMillis();
                    Iterator<String> iterator = p.getMutes().keySet().iterator();
                    while (iterator.hasNext()) {
                        ChatChannel channel = ChatChannel.getChannel(iterator.next());
                        int timemark = p.getMutes().get(channel.getName());
                        if (timemark == 0) continue;
                        if (MineverseChat.this.getConfig().getString("loglevel", "info").equals("debug")) {
                            System.out.println(String.valueOf(time) + " " + timemark);
                        }
                        if (time < timemark) continue;
                        iterator.remove();
                        if (p.isOnline()) {
                            p.getPlayer().sendMessage(LocalizedMessage.UNMUTE_PLAYER_PLAYER.toString().replace("{player}", p.getName()).replace("{channel_color}", channel.getColor()).replace("{channel_name}", channel.getName()));
                            continue;
                        }
                        p.setModified(true);
                    }
                }
                if (MineverseChat.this.getConfig().getString("loglevel", "info").equals("debug")) {
                    Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&e - Updating Player Mutes"));
                }
            }
        }, 0L, 1200L);
        this.firstRun = false;
    }

    public void unregister(String name) {
        try {
            ((Map)knownCommands.get((SimpleCommandMap)commandMap.get(Bukkit.getServer()))).remove(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadCommandMap() {
        try {
            commandMap = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            commandMap.setAccessible(true);
            knownCommands = SimpleCommandMap.class.getDeclaredField("knownCommands");
            knownCommands.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public CommandMap getCommandMap() {
        return cmap;
    }

    public static MineverseChat getInstance() {
        return (MineverseChat)MineverseChat.getPlugin(MineverseChat.class);
    }

    private void registerPacketListeners() {
        ProtocolLibrary.getProtocolManager().addPacketListener((com.comphenix.protocol.events.PacketListener)new PacketListener());
    }

    private void loadNMS() {
        try {
            posField = MinecraftReflection.getMinecraftClass((String)"PacketPlayOutChat").getDeclaredField("b");
            posField.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!(VersionHandler.is1_7_10() || VersionHandler.is1_8() || VersionHandler.is1_9() || VersionHandler.is1_10() || VersionHandler.is1_11())) {
            try {
                chatMessageType = this.getNMSClass("ChatMessageType");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Class<?> getNMSClass(String name) {
        try {
            return Class.forName("net.minecraft.server." + this.getVersion() + "." + name);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getVersion() {
        return Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
    }

    private boolean setupPermissions() {
        RegisteredServiceProvider permissionProvider = this.getServer().getServicesManager().getRegistration(Permission.class);
        if (permissionProvider != null) {
            permission = (Permission)permissionProvider.getProvider();
        }
        return permission != null;
    }

    private boolean setupChat() {
        RegisteredServiceProvider chatProvider = this.getServer().getServicesManager().getRegistration(Chat.class);
        if (chatProvider != null) {
            chat = (Chat)chatProvider.getProvider();
        }
        return chat != null;
    }

    public long getLineLength() {
        return this.LINELENGTH;
    }

    public void onDisable() {
        PlayerData.savePlayerData();
        Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&e - Disabling..."));
        Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&e - Disabled Successfully"));
    }

    public void setLogLevel(String loglevel) {
        this.curLogLevel = LogLevels.valueOf(loglevel) != null ? LogLevels.valueOf(loglevel) : LogLevels.INFO;
    }

    public void logme(LogLevels level, String location, String logline) {
        if (level.ordinal() >= this.curLogLevel.ordinal()) {
            log.log(Level.INFO, "[VentureChat]: {0}:{1} : {2}", new Object[]{level.toString(), location, logline});
        }
    }

    public void synchronize(MineverseChatPlayer mcp, boolean changes) {
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(outstream);
        try {
            out.writeUTF("Sync");
            if (!changes) {
                out.writeUTF("Receive");
                out.writeUTF(mcp.getUUID().toString());
            } else {
                ChatChannel channel;
                Object channel2;
                out.writeUTF("Update");
                out.writeUTF(mcp.getUUID().toString());
                int channelCount = 0;
                for (String c : mcp.getListening()) {
                    channel2 = ChatChannel.getChannel(c);
                    if (!((ChatChannel)channel2).getBungee().booleanValue()) continue;
                    ++channelCount;
                }
                out.write(channelCount);
                for (String c : mcp.getListening()) {
                    channel2 = ChatChannel.getChannel(c);
                    if (!((ChatChannel)channel2).getBungee().booleanValue()) continue;
                    out.writeUTF(((ChatChannel)channel2).getName());
                }
                int muteCount = 0;
                for (String c : mcp.getMutes().keySet()) {
                    channel = ChatChannel.getChannel(c);
                    if (!channel.getBungee().booleanValue()) continue;
                    ++muteCount;
                }
                out.write(muteCount);
                for (String c : mcp.getMutes().keySet()) {
                    channel = ChatChannel.getChannel(c);
                    if (!channel.getBungee().booleanValue()) continue;
                    out.writeUTF(channel.getName());
                }
                int ignoreCount = 0;
                for (UUID c : mcp.getIgnores()) {
                    ++ignoreCount;
                }
                out.write(ignoreCount);
                for (UUID c : mcp.getIgnores()) {
                    out.writeUTF(c.toString());
                }
                out.writeBoolean(mcp.isSpy());
                out.writeBoolean(mcp.getMessageToggle());
            }
            Iterator<MineverseChatPlayer> iterator = onlinePlayers.iterator();
            if (iterator.hasNext()) {
                MineverseChatPlayer p = iterator.next();
                p.getPlayer().sendPluginMessage((Plugin)this, PLUGIN_MESSAGING_CHANNEL, outstream.toByteArray());
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void updatePlayerList(MineverseChatPlayer mcp, boolean request) {
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(outstream);
        try {
            out.writeUTF("Sync");
            if (request) {
                out.writeUTF("PlayersReceive");
                out.writeUTF(this.getServer().getName());
            } else {
                out.writeUTF("PlayersUpdate");
                out.write(networkPlayers.keySet().size());
                for (String p : networkPlayers.keySet()) {
                    out.writeUTF(String.valueOf(p) + "," + networkPlayers.get(p));
                }
            }
            mcp.getPlayer().sendPluginMessage((Plugin)this, PLUGIN_MESSAGING_CHANNEL, outstream.toByteArray());
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void sendDiscordSRVPluginMessage(String chatChannel, String message) {
        if (onlinePlayers.size() == 0) {
            return;
        }
        Player host = onlinePlayers.iterator().next().getPlayer();
        ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteOutStream);
        try {
            out.writeUTF("DiscordSRV");
            out.writeUTF(chatChannel);
            out.writeUTF(message);
            host.sendPluginMessage((Plugin)MineverseChat.getInstance(), PLUGIN_MESSAGING_CHANNEL, byteOutStream.toByteArray());
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onPluginMessageReceived(String channel, Player player, byte[] inputStream) {
        block137: {
            if (!channel.equals(PLUGIN_MESSAGING_CHANNEL)) {
                return;
            }
            try {
                ChatChannel[] chatChannelArray;
                Object playerList;
                int hash;
                DataInputStream msgin = new DataInputStream(new ByteArrayInputStream(inputStream));
                if (this.getConfig().getString("loglevel", "info").equals("debug")) {
                    System.out.println(String.valueOf(msgin.available()) + " size on receiving end");
                }
                String subchannel = msgin.readUTF();
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                DataOutputStream out = new DataOutputStream(stream);
                if (subchannel.equals("Chat")) {
                    String server = msgin.readUTF();
                    String chatchannel = msgin.readUTF();
                    final String senderName = msgin.readUTF();
                    UUID senderUUID = UUID.fromString(msgin.readUTF());
                    hash = msgin.readInt();
                    final String format = msgin.readUTF();
                    Iterator<MineverseChatPlayer> chat = msgin.readUTF();
                    String consoleChat = String.valueOf(format) + (String)((Object)chat);
                    String globalJSON = msgin.readUTF();
                    final String primaryGroup = msgin.readUTF();
                    final String nickname = msgin.readUTF();
                    if (!ChatChannel.isChannel(chatchannel)) {
                        return;
                    }
                    final ChatChannel chatChannelObject = ChatChannel.getChannel(chatchannel);
                    if (!chatChannelObject.getBungee().booleanValue()) {
                        return;
                    }
                    final HashSet<Player> recipients = new HashSet<Player>();
                    for (MineverseChatPlayer p : onlinePlayers) {
                        if (!p.isListening(chatChannelObject.getName())) continue;
                        recipients.add(p.getPlayer());
                    }
                    Bukkit.getServer().getScheduler().runTaskAsynchronously((Plugin)this, new Runnable((String)((Object)chat), globalJSON, hash){
                        private final /* synthetic */ String val$chat;
                        private final /* synthetic */ String val$globalJSON;
                        private final /* synthetic */ int val$hash;
                        {
                            this.val$chat = string5;
                            this.val$globalJSON = string6;
                            this.val$hash = n;
                        }

                        @Override
                        public void run() {
                            VentureChatEvent ventureChatEvent = new VentureChatEvent(null, senderName, nickname, primaryGroup, chatChannelObject, recipients, recipients.size(), format, this.val$chat, this.val$globalJSON, this.val$hash, false);
                            Bukkit.getServer().getPluginManager().callEvent((Event)ventureChatEvent);
                        }
                    });
                    Bukkit.getConsoleSender().sendMessage(consoleChat);
                    if (this.db != null) {
                        Calendar currentDate = Calendar.getInstance();
                        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        String date = formatter.format(currentDate.getTime());
                        this.db.writeVentureChat(date, senderUUID.toString(), senderName, server, chatchannel, ((String)((Object)chat)).replace("'", "''"), "Chat");
                    }
                    for (MineverseChatPlayer p : onlinePlayers) {
                        if (!p.isListening(chatChannelObject.getName()) || !p.getBungeeToggle() && MineverseChatAPI.getOnlineMineverseChatPlayer(senderName) == null) continue;
                        String json = Format.formatModerationGUI(globalJSON, p.getPlayer(), senderName, chatchannel, hash);
                        PacketContainer packet = Format.createPacketPlayOutChat(json);
                        if (this.getConfig().getBoolean("ignorechat", false)) {
                            if (p.getIgnores().contains(senderUUID)) continue;
                            Format.sendPacketPlayOutChat(p.getPlayer(), packet);
                            continue;
                        }
                        Format.sendPacketPlayOutChat(p.getPlayer(), packet);
                    }
                }
                if (subchannel.equals("DiscordSRV")) {
                    String chatChannel = msgin.readUTF();
                    String message = msgin.readUTF();
                    if (!ChatChannel.isChannel(chatChannel)) {
                        return;
                    }
                    ChatChannel chatChannelObj = ChatChannel.getChannel(chatChannel);
                    if (!chatChannelObj.getBungee().booleanValue()) {
                        return;
                    }
                    String json = Format.convertPlainTextToJson(message, true);
                    hash = message.replaceAll("([\u00a7]([a-z0-9]))", "").hashCode();
                    for (MineverseChatPlayer p : onlinePlayers) {
                        String finalJSON = Format.formatModerationGUI(json, p.getPlayer(), "Discord", chatChannelObj.getName(), hash);
                        PacketContainer packet = Format.createPacketPlayOutChat(finalJSON);
                        Format.sendPacketPlayOutChat(p.getPlayer(), packet);
                    }
                }
                if (subchannel.equals("Chwho")) {
                    String sender;
                    String identifier = msgin.readUTF();
                    if (identifier.equals("Get")) {
                        sender = msgin.readUTF();
                        String name = msgin.readUTF();
                        String chatchannel = msgin.readUTF();
                        ArrayList<String> listening = new ArrayList<String>();
                        if (ChatChannel.isChannel(chatchannel)) {
                            for (MineverseChatPlayer mcp : onlinePlayers) {
                                if (!mcp.isListening(chatchannel)) continue;
                                String entry = "&f" + mcp.getName();
                                if (mcp.isMuted(chatchannel)) {
                                    entry = "&c" + mcp.getName();
                                }
                                listening.add(entry);
                            }
                        }
                        out.writeUTF("Chwho");
                        out.writeUTF("Receive");
                        out.writeUTF(sender);
                        out.writeUTF(name);
                        out.writeUTF(chatchannel);
                        out.writeInt(listening.size());
                        for (String s : listening) {
                            out.writeUTF(s);
                        }
                        player.sendPluginMessage((Plugin)this, PLUGIN_MESSAGING_CHANNEL, stream.toByteArray());
                    }
                    if (identifier.equals("Receive")) {
                        sender = msgin.readUTF();
                        String stringchannel = msgin.readUTF();
                        MineverseChatPlayer mcp = MineverseChatAPI.getOnlineMineverseChatPlayer(UUID.fromString(sender));
                        ChatChannel chatchannel = ChatChannel.getChannel(stringchannel);
                        playerList = "";
                        int size = msgin.readInt();
                        int a = 0;
                        while (a < size) {
                            playerList = String.valueOf(playerList) + msgin.readUTF() + ChatColor.WHITE + ", ";
                            ++a;
                        }
                        if (playerList.length() > 2) {
                            playerList = playerList.substring(0, playerList.length() - 2);
                        }
                        mcp.getPlayer().sendMessage(LocalizedMessage.CHANNEL_PLAYER_LIST_HEADER.toString().replace("{channel_color}", chatchannel.getColor().toString()).replace("{channel_name}", chatchannel.getName()));
                        mcp.getPlayer().sendMessage(Format.FormatStringAll((String)playerList));
                    }
                }
                if (subchannel.equals("RemoveMessage")) {
                    String hash2 = msgin.readUTF();
                    this.getServer().dispatchCommand((CommandSender)this.getServer().getConsoleSender(), "removemessage " + hash2);
                }
                if (subchannel.equals("PlayersUpdate")) {
                    networkPlayers.clear();
                    int size = msgin.read();
                    int a = 1;
                    while (a <= size) {
                        String p = msgin.readUTF();
                        String[] parts = p.split(",");
                        networkPlayers.put(parts[0], parts[1]);
                        System.out.print(p);
                        ++a;
                    }
                }
                if (subchannel.equals("Sync")) {
                    if (this.getConfig().getString("loglevel", "info").equals("debug")) {
                        Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&e - Received update..."));
                    }
                    String uuid = msgin.readUTF();
                    MineverseChatPlayer p = MineverseChatAPI.getMineverseChatPlayer(UUID.fromString(uuid));
                    playerList = p.getListening().toArray();
                    int chatchannel = ((Object[])playerList).length;
                    int parts = 0;
                    while (parts < chatchannel) {
                        Object ch = playerList[parts];
                        String c22 = ch.toString();
                        ChatChannel cha = ChatChannel.getChannel(c22);
                        if (cha.getBungee().booleanValue()) {
                            p.removeListening(c22);
                        }
                        ++parts;
                    }
                    int size = msgin.read();
                    int a = 0;
                    while (a < size) {
                        ChatChannel cha;
                        String ch = msgin.readUTF();
                        if (ChatChannel.isChannel(ch) && (cha = ChatChannel.getChannel(ch)).hasPermission().booleanValue() && p.getPlayer().hasPermission(cha.getPermission())) {
                            p.addListening(ch);
                        }
                        ++a;
                    }
                    Object[] c22 = p.getMutes().keySet().toArray();
                    int cha = c22.length;
                    int ch = 0;
                    while (ch < cha) {
                        Object o = c22[ch];
                        ChatChannel ch2 = ChatChannel.getChannel((String)o);
                        if (ch2.getBungee().booleanValue()) {
                            p.removeMute(ch2.getName());
                        }
                        ++ch;
                    }
                    int sizeB = msgin.read();
                    int b = 0;
                    while (b < sizeB) {
                        String ch3 = msgin.readUTF();
                        if (ChatChannel.isChannel(ch3)) {
                            p.addMute(ch3, 0);
                        }
                        ++b;
                    }
                    p.setSpy(msgin.readBoolean());
                    p.setMessageToggle(msgin.readBoolean());
                    Object[] ch2 = p.getIgnores().toArray();
                    int c22 = ch2.length;
                    int ch3 = 0;
                    while (ch3 < c22) {
                        Object o = ch2[ch3];
                        p.removeIgnore((UUID)o);
                        ++ch3;
                    }
                    int sizeC = msgin.read();
                    int c = 0;
                    while (c < sizeC) {
                        String i = msgin.readUTF();
                        p.addIgnore(UUID.fromString(i));
                        ++c;
                    }
                    if (!p.hasPlayed()) {
                        for (ChatChannel ch4 : ChatChannel.getAutojoinList()) {
                            if (ch4.hasPermission().booleanValue()) {
                                if (!p.getPlayer().hasPermission(ch4.getPermission())) continue;
                                p.addListening(ch4.getName());
                                continue;
                            }
                            p.addListening(ch4.getName());
                        }
                        p.setHasPlayed(true);
                        this.synchronize(p, true);
                    }
                }
                if (subchannel.equals("Ignore")) {
                    String identifier = msgin.readUTF();
                    if (identifier.equals("Send")) {
                        String server = msgin.readUTF();
                        String receiver = msgin.readUTF();
                        MineverseChatPlayer p = MineverseChatAPI.getOnlineMineverseChatPlayer(receiver);
                        UUID sender = UUID.fromString(msgin.readUTF());
                        if (!this.getConfig().getBoolean("bungeecordmessaging", true) || p == null || !p.isOnline()) {
                            out.writeUTF("Ignore");
                            out.writeUTF("Offline");
                            out.writeUTF(server);
                            out.writeUTF(receiver);
                            out.writeUTF(sender.toString());
                            player.sendPluginMessage((Plugin)this, PLUGIN_MESSAGING_CHANNEL, stream.toByteArray());
                            return;
                        }
                        out.writeUTF("Ignore");
                        out.writeUTF("Echo");
                        out.writeUTF(server);
                        out.writeUTF(p.getUUID().toString());
                        out.writeUTF(sender.toString());
                        player.sendPluginMessage((Plugin)this, PLUGIN_MESSAGING_CHANNEL, stream.toByteArray());
                        return;
                    }
                    if (identifier.equals("Offline")) {
                        String receiver = msgin.readUTF();
                        UUID sender = UUID.fromString(msgin.readUTF());
                        MineverseChatPlayer p = MineverseChatAPI.getOnlineMineverseChatPlayer(sender);
                        p.getPlayer().sendMessage(LocalizedMessage.PLAYER_OFFLINE.toString().replace("{args}", receiver));
                    }
                    if (identifier.equals("Echo")) {
                        UUID receiver = UUID.fromString(msgin.readUTF());
                        UUID sender = UUID.fromString(msgin.readUTF());
                        MineverseChatPlayer p = MineverseChatAPI.getOnlineMineverseChatPlayer(sender);
                        MineverseChatPlayer r = MineverseChatAPI.getMineverseChatPlayer(receiver);
                        String rName = receiver.toString();
                        if (r != null) {
                            rName = Format.FormatStringAll(r.getNickname());
                        }
                        if (p.getIgnores().contains(receiver)) {
                            p.getPlayer().sendMessage(ChatColor.GOLD + "You are no longer ignoring player: " + ChatColor.RED + rName);
                            p.removeIgnore(receiver);
                            this.synchronize(p, true);
                            return;
                        }
                        p.addIgnore(receiver);
                        p.getPlayer().sendMessage(LocalizedMessage.IGNORE_PLAYER_ON.toString().replace("{player}", rName));
                        this.synchronize(p, true);
                    }
                }
                if (subchannel.equals("Message")) {
                    String identifier = msgin.readUTF();
                    if (identifier.equals("Send")) {
                        String server = msgin.readUTF();
                        String receiver = msgin.readUTF();
                        MineverseChatPlayer p = MineverseChatAPI.getOnlineMineverseChatPlayer(receiver);
                        UUID sender = UUID.fromString(msgin.readUTF());
                        String sName = msgin.readUTF();
                        MineverseChatPlayer s = MineverseChatAPI.getMineverseChatPlayer(sender);
                        String msg = msgin.readUTF();
                        String echo = msgin.readUTF();
                        String spy = msgin.readUTF();
                        if (!this.getConfig().getBoolean("bungeecordmessaging", true) || p == null || !p.isOnline()) {
                            out.writeUTF("Message");
                            out.writeUTF("Offline");
                            out.writeUTF(server);
                            out.writeUTF(receiver);
                            out.writeUTF(sender.toString());
                            player.sendPluginMessage((Plugin)this, PLUGIN_MESSAGING_CHANNEL, stream.toByteArray());
                            return;
                        }
                        if (p.getIgnores().contains(sender)) {
                            out.writeUTF("Message");
                            out.writeUTF("Ignore");
                            out.writeUTF(server);
                            out.writeUTF(receiver);
                            out.writeUTF(sender.toString());
                            player.sendPluginMessage((Plugin)this, PLUGIN_MESSAGING_CHANNEL, stream.toByteArray());
                            return;
                        }
                        if (!p.getMessageToggle()) {
                            out.writeUTF("Message");
                            out.writeUTF("Blocked");
                            out.writeUTF(server);
                            out.writeUTF(receiver);
                            out.writeUTF(sender.toString());
                            player.sendPluginMessage((Plugin)this, PLUGIN_MESSAGING_CHANNEL, stream.toByteArray());
                            return;
                        }
                        if (s != null) {
                            sName = Format.FormatStringAll(s.getNickname());
                        } else {
                            UUID uuid = sender;
                            String name = sName;
                            ChatChannel current = ChatChannel.getDefaultChannel();
                            HashSet<UUID> ignores = new HashSet<UUID>();
                            HashSet<String> listening = new HashSet<String>();
                            listening.add(current.getName());
                            HashMap<String, Integer> mutes = new HashMap<String, Integer>();
                            HashSet<String> blockedCommands = new HashSet<String>();
                            String jsonFormat = "Default";
                            s = new MineverseChatPlayer(uuid, name, current, ignores, listening, mutes, blockedCommands, false, null, true, true, name, jsonFormat, false, false, false, true, true);
                            players.add(s);
                        }
                        p.getPlayer().sendMessage(msg.replace("{playerfrom}", sName).replace("{playerto}", Format.FormatStringAll(p.getNickname())));
                        if (p.hasNotifications()) {
                            if (VersionHandler.is1_8() || VersionHandler.is1_7_10() || VersionHandler.is1_7_2() || VersionHandler.is1_7_9()) {
                                p.getPlayer().playSound(p.getPlayer().getLocation(), Sound.valueOf((String)"LEVEL_UP"), 1.0f, 0.0f);
                            } else {
                                p.getPlayer().playSound(p.getPlayer().getLocation(), Sound.valueOf((String)"ENTITY_PLAYER_LEVELUP"), 1.0f, 0.0f);
                            }
                        }
                        p.setReplyPlayer(sender);
                        out.writeUTF("Message");
                        out.writeUTF("Echo");
                        out.writeUTF(server);
                        out.writeUTF(p.getNickname());
                        out.writeUTF(sender.toString());
                        out.writeUTF(sName);
                        out.writeUTF(echo);
                        out.writeUTF(spy);
                        player.sendPluginMessage((Plugin)this, PLUGIN_MESSAGING_CHANNEL, stream.toByteArray());
                        return;
                    }
                    if (identifier.equals("Offline")) {
                        String receiver = msgin.readUTF();
                        UUID sender = UUID.fromString(msgin.readUTF());
                        MineverseChatPlayer p = MineverseChatAPI.getOnlineMineverseChatPlayer(sender);
                        p.getPlayer().sendMessage(LocalizedMessage.PLAYER_OFFLINE.toString().replace("{args}", receiver));
                        p.setReplyPlayer(null);
                    }
                    if (identifier.equals("Ignore")) {
                        String receiver = msgin.readUTF();
                        UUID sender = UUID.fromString(msgin.readUTF());
                        MineverseChatPlayer p = MineverseChatAPI.getOnlineMineverseChatPlayer(sender);
                        p.getPlayer().sendMessage(LocalizedMessage.IGNORING_MESSAGE.toString().replace("{player}", receiver));
                    }
                    if (identifier.equals("Blocked")) {
                        String receiver = msgin.readUTF();
                        UUID sender = UUID.fromString(msgin.readUTF());
                        MineverseChatPlayer p = MineverseChatAPI.getOnlineMineverseChatPlayer(sender);
                        p.getPlayer().sendMessage(LocalizedMessage.BLOCKING_MESSAGE.toString().replace("{player}", receiver));
                    }
                    if (identifier.equals("Echo")) {
                        String receiver = msgin.readUTF();
                        UUID sender = UUID.fromString(msgin.readUTF());
                        MineverseChatPlayer p = MineverseChatAPI.getOnlineMineverseChatPlayer(sender);
                        MineverseChatPlayer r = MineverseChatAPI.getMineverseChatPlayer(receiver);
                        String echo = msgin.readUTF();
                        String rName = Format.FormatStringAll(receiver);
                        if (r != null) {
                            rName = Format.FormatStringAll(r.getNickname());
                            p.setReplyPlayer(r.getUUID());
                        }
                        p.getPlayer().sendMessage(echo.replace("{playerfrom}", Format.FormatStringAll(p.getNickname())).replace("{playerto}", rName));
                    }
                    if (identifier.equals("Spy")) {
                        String receiver = msgin.readUTF();
                        MineverseChatPlayer r = MineverseChatAPI.getMineverseChatPlayer(receiver);
                        UUID sender = UUID.fromString(msgin.readUTF());
                        MineverseChatPlayer p = MineverseChatAPI.getOnlineMineverseChatPlayer(sender);
                        String sName = msgin.readUTF();
                        String spy = msgin.readUTF();
                        String rName = receiver;
                        if (r != null) {
                            rName = Format.FormatStringAll(r.getNickname());
                        }
                        if (p != null) {
                            sName = Format.FormatStringAll(p.getNickname());
                        }
                        for (MineverseChatPlayer pl : onlinePlayers) {
                            if (!pl.isSpy() || pl.getName().equals(sName) || pl.getName().equals(rName)) continue;
                            pl.getPlayer().sendMessage(spy.replace("{playerto}", rName).replace("{playerfrom}", sName));
                        }
                    }
                }
                if (subchannel.equals("Mute")) {
                    String sendplayer = msgin.readUTF();
                    String mutePlayer = msgin.readUTF();
                    String chatchannel = msgin.readUTF();
                    String server = msgin.readUTF();
                    String time = msgin.readUTF();
                    int numtime = 0;
                    MineverseChatPlayer p = MineverseChatAPI.getMineverseChatPlayer(mutePlayer);
                    ChatChannel cc = ChatChannel.getChannel(chatchannel);
                    if (cc == null) {
                        try {
                            out.writeUTF("Mute");
                            out.writeUTF("Channel");
                            out.writeUTF(sendplayer);
                            out.writeUTF(chatchannel);
                            player.sendPluginMessage((Plugin)this, PLUGIN_MESSAGING_CHANNEL, stream.toByteArray());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        return;
                    }
                    if (p == null) {
                        try {
                            out.writeUTF("Mute");
                            out.writeUTF("Player");
                            out.writeUTF(sendplayer);
                            out.writeUTF(mutePlayer);
                            out.writeUTF(server);
                            player.sendPluginMessage((Plugin)this, PLUGIN_MESSAGING_CHANNEL, stream.toByteArray());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        return;
                    }
                    if (!cc.isMutable().booleanValue()) {
                        try {
                            out.writeUTF("Mute");
                            out.writeUTF("Mutable");
                            out.writeUTF(sendplayer);
                            out.writeUTF(cc.getName());
                            out.writeUTF(cc.getColor());
                            player.sendPluginMessage((Plugin)this, PLUGIN_MESSAGING_CHANNEL, stream.toByteArray());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        return;
                    }
                    if (p.isMuted(cc.getName())) {
                        try {
                            out.writeUTF("Mute");
                            out.writeUTF("Already");
                            out.writeUTF(sendplayer);
                            out.writeUTF(mutePlayer);
                            out.writeUTF(cc.getName());
                            out.writeUTF(cc.getColor());
                            player.sendPluginMessage((Plugin)this, PLUGIN_MESSAGING_CHANNEL, stream.toByteArray());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        return;
                    }
                    if (!time.equals("None\n")) {
                        try {
                            numtime = Integer.parseInt(time);
                            if (numtime > 0) {
                                Calendar currentDate = Calendar.getInstance();
                                SimpleDateFormat formatter = new SimpleDateFormat("dd:HH:mm:ss");
                                String date = formatter.format(currentDate.getTime());
                                String[] datearray = date.split(":");
                                int datetime = Integer.parseInt(datearray[0]) * 1440 + Integer.parseInt(datearray[1]) * 60 + Integer.parseInt(datearray[2]);
                                p.addMute(cc.getName(), datetime + numtime);
                                String keyword = "minutes";
                                if (numtime == 1) {
                                    keyword = "minute";
                                }
                                if (p.isOnline()) {
                                    p.getPlayer().sendMessage(ChatColor.RED + "You have just been muted in: " + ChatColor.valueOf((String)cc.getColor().toUpperCase()) + cc.getName() + ChatColor.RED + " for " + time + " " + keyword);
                                } else {
                                    p.setModified(true);
                                }
                                if (cc.getBungee().booleanValue()) {
                                    MineverseChat.getInstance().synchronize(p, true);
                                }
                                try {
                                    out.writeUTF("Mute");
                                    out.writeUTF("Valid");
                                    out.writeUTF(sendplayer);
                                    out.writeUTF(mutePlayer);
                                    out.writeUTF(cc.getName());
                                    out.writeUTF(cc.getColor());
                                    out.writeUTF(time);
                                    player.sendPluginMessage((Plugin)this, PLUGIN_MESSAGING_CHANNEL, stream.toByteArray());
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                return;
                            }
                            try {
                                out.writeUTF("Mute");
                                out.writeUTF("Time");
                                out.writeUTF(sendplayer);
                                out.writeUTF(time);
                                player.sendPluginMessage((Plugin)this, PLUGIN_MESSAGING_CHANNEL, stream.toByteArray());
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            return;
                        }
                        catch (Exception e) {
                            try {
                                out.writeUTF("Mute");
                                out.writeUTF("Time");
                                out.writeUTF(sendplayer);
                                out.writeUTF(time);
                                player.sendPluginMessage((Plugin)this, PLUGIN_MESSAGING_CHANNEL, stream.toByteArray());
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                            }
                            return;
                        }
                    }
                    p.addMute(cc.getName(), 0);
                    if (p.isOnline()) {
                        p.getPlayer().sendMessage(ChatColor.RED + "You have just been muted in: " + ChatColor.valueOf((String)cc.getColor().toUpperCase()) + cc.getName());
                    } else {
                        p.setModified(true);
                    }
                    if (cc.getBungee().booleanValue()) {
                        MineverseChat.getInstance().synchronize(p, true);
                    }
                    try {
                        out.writeUTF("Mute");
                        out.writeUTF("Valid");
                        out.writeUTF(sendplayer);
                        out.writeUTF(mutePlayer);
                        out.writeUTF(cc.getName());
                        out.writeUTF(cc.getColor());
                        out.writeUTF(time);
                        player.sendPluginMessage((Plugin)this, PLUGIN_MESSAGING_CHANNEL, stream.toByteArray());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return;
                }
                if (subchannel.equals("Muteall")) {
                    String sendplayer = msgin.readUTF();
                    String muteplayer = msgin.readUTF();
                    String server = msgin.readUTF();
                    Player mp = Bukkit.getPlayer((String)muteplayer);
                    MineverseChatPlayer p = MineverseChatAPI.getMineverseChatPlayer(mp);
                    if (mp == null) {
                        try {
                            out.writeUTF("Muteall");
                            out.writeUTF("Player");
                            out.writeUTF(sendplayer);
                            out.writeUTF(muteplayer);
                            out.writeUTF(server);
                            player.sendPluginMessage((Plugin)this, PLUGIN_MESSAGING_CHANNEL, stream.toByteArray());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        return;
                    }
                    boolean bungee = false;
                    chatChannelArray = ChatChannel.getChannels();
                    int n = chatChannelArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ChatChannel c = chatChannelArray[n2];
                        if (c.isMutable().booleanValue()) {
                            p.addMute(c.getName(), 0);
                            if (c.getBungee().booleanValue()) {
                                bungee = true;
                            }
                        }
                        ++n2;
                    }
                    if (bungee) {
                        MineverseChat.getInstance().synchronize(p, true);
                    }
                    if (p.isOnline()) {
                        p.getPlayer().sendMessage(ChatColor.RED + "You have just been muted in all channels.");
                    } else {
                        p.setModified(true);
                    }
                    try {
                        out.writeUTF("Muteall");
                        out.writeUTF("Valid");
                        out.writeUTF(sendplayer);
                        out.writeUTF(muteplayer);
                        player.sendPluginMessage((Plugin)this, PLUGIN_MESSAGING_CHANNEL, stream.toByteArray());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return;
                }
                if (subchannel.equals("Unmuteall")) {
                    String sendplayer = msgin.readUTF();
                    String muteplayer = msgin.readUTF();
                    String server = msgin.readUTF();
                    Player mp = Bukkit.getPlayer((String)muteplayer);
                    MineverseChatPlayer p = MineverseChatAPI.getMineverseChatPlayer(mp);
                    if (mp == null) {
                        try {
                            out.writeUTF("Unmuteall");
                            out.writeUTF("Player");
                            out.writeUTF(sendplayer);
                            out.writeUTF(muteplayer);
                            out.writeUTF(server);
                            player.sendPluginMessage((Plugin)this, PLUGIN_MESSAGING_CHANNEL, stream.toByteArray());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        return;
                    }
                    boolean bungee = false;
                    chatChannelArray = ChatChannel.getChannels();
                    int n = chatChannelArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        ChatChannel c = chatChannelArray[n3];
                        p.removeMute(c.getName());
                        if (c.getBungee().booleanValue()) {
                            bungee = true;
                        }
                        ++n3;
                    }
                    if (bungee) {
                        MineverseChat.getInstance().synchronize(p, true);
                    }
                    if (p.isOnline()) {
                        p.getPlayer().sendMessage(ChatColor.RED + "You have just been unmuted in all channels.");
                    } else {
                        p.setModified(true);
                    }
                    try {
                        out.writeUTF("Unmuteall");
                        out.writeUTF("Valid");
                        out.writeUTF(sendplayer);
                        out.writeUTF(muteplayer);
                        player.sendPluginMessage((Plugin)this, PLUGIN_MESSAGING_CHANNEL, stream.toByteArray());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return;
                }
                if (!subchannel.equals("Unmute")) break block137;
                String sendplayer = msgin.readUTF();
                String mutePlayer = msgin.readUTF();
                String chatchannel = msgin.readUTF();
                String server = msgin.readUTF();
                MineverseChatPlayer p = MineverseChatAPI.getMineverseChatPlayer(mutePlayer);
                ChatChannel cc = ChatChannel.getChannel(chatchannel);
                if (cc == null) {
                    try {
                        out.writeUTF("Unmute");
                        out.writeUTF("Channel");
                        out.writeUTF(sendplayer);
                        out.writeUTF(chatchannel);
                        player.sendPluginMessage((Plugin)this, PLUGIN_MESSAGING_CHANNEL, stream.toByteArray());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return;
                }
                if (p == null) {
                    try {
                        out.writeUTF("Unmute");
                        out.writeUTF("Player");
                        out.writeUTF(sendplayer);
                        out.writeUTF(mutePlayer);
                        out.writeUTF(server);
                        player.sendPluginMessage((Plugin)this, PLUGIN_MESSAGING_CHANNEL, stream.toByteArray());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return;
                }
                if (!p.isMuted(cc.getName())) {
                    try {
                        out.writeUTF("Unmute");
                        out.writeUTF("Already");
                        out.writeUTF(sendplayer);
                        out.writeUTF(mutePlayer);
                        out.writeUTF(cc.getName());
                        out.writeUTF(cc.getColor());
                        player.sendPluginMessage((Plugin)this, PLUGIN_MESSAGING_CHANNEL, stream.toByteArray());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return;
                }
                p.removeMute(cc.getName());
                if (p.isOnline()) {
                    p.getPlayer().sendMessage(ChatColor.RED + "You have just been unmuted in: " + ChatColor.valueOf((String)cc.getColor().toUpperCase()) + cc.getName());
                } else {
                    p.setModified(true);
                }
                if (cc.getBungee().booleanValue()) {
                    MineverseChat.getInstance().synchronize(p, true);
                }
                try {
                    out.writeUTF("Unmute");
                    out.writeUTF("Valid");
                    out.writeUTF(sendplayer);
                    out.writeUTF(mutePlayer);
                    out.writeUTF(cc.getName());
                    out.writeUTF(cc.getColor());
                    player.sendPluginMessage((Plugin)this, PLUGIN_MESSAGING_CHANNEL, stream.toByteArray());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

