/*
 * Decompiled with CFR 0.152.
 */
package mineverse.Aust1n46.chat.channel;

import java.util.ArrayList;
import java.util.List;
import mineverse.Aust1n46.chat.MineverseChat;
import mineverse.Aust1n46.chat.utilities.Format;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;

public class ChatChannel {
    private static final String PERMISSION_PREFIX = "venturechat.";
    private static final String NO_PERMISSIONS = "venturechat.none";
    private static MineverseChat plugin = MineverseChat.getInstance();
    private static ChatChannel defaultChatChannel;
    private static ChatChannel[] channels;
    private static String defaultColor;
    private String name;
    private String permission;
    private String speakPermission;
    private boolean mutable;
    private String color;
    private String chatColor;
    private boolean defaultChannel;
    private boolean autojoin;
    private String alias;
    private double distance;
    private boolean filter;
    private boolean bungee;
    private String format;
    private int cooldown;

    public static void initialize() {
        ConfigurationSection cs = plugin.getConfig().getConfigurationSection("channels");
        int len = cs.getKeys(false).size();
        channels = new ChatChannel[len];
        int counter = 0;
        for (String key : cs.getKeys(false)) {
            String color = cs.getString(String.valueOf(key) + ".color", "white");
            String chatColor = cs.getString(String.valueOf(key) + ".chatcolor", "white");
            String name = key;
            String permission = cs.getString(String.valueOf(key) + ".permissions", "None");
            String speakPermission = cs.getString(String.valueOf(key) + ".speak_permissions", "None");
            boolean mutable = cs.getBoolean(String.valueOf(key) + ".mutable", false);
            boolean filter = cs.getBoolean(String.valueOf(key) + ".filter", true);
            boolean bungee = cs.getBoolean(String.valueOf(key) + ".bungeecord", false);
            String format = cs.getString(String.valueOf(key) + ".format", "Default");
            boolean defaultChannel = cs.getBoolean(String.valueOf(key) + ".default", false);
            String alias = cs.getString(String.valueOf(key) + ".alias", "None");
            double distance = cs.getDouble(String.valueOf(key) + ".distance", 0.0);
            int cooldown = cs.getInt(String.valueOf(key) + ".cooldown", 0);
            boolean autojoin = cs.getBoolean(String.valueOf(key) + ".autojoin", false);
            ChatChannel chatChannel = new ChatChannel(name, color, chatColor, permission, speakPermission, mutable, filter, defaultChannel, alias, distance, autojoin, bungee, cooldown, format);
            ChatChannel.channels[counter++] = chatChannel;
            if (!defaultChannel) continue;
            defaultChatChannel = chatChannel;
            defaultColor = color;
        }
    }

    public static ChatChannel[] getChannels() {
        return channels;
    }

    public static ChatChannel getChannel(String channelName) {
        ChatChannel[] chatChannelArray = channels;
        int n = channels.length;
        int n2 = 0;
        while (n2 < n) {
            ChatChannel c = chatChannelArray[n2];
            if (c.getName().equalsIgnoreCase(channelName) || c.getAlias().equalsIgnoreCase(channelName)) {
                return c;
            }
            ++n2;
        }
        return null;
    }

    public static boolean isChannel(String channelName) {
        return ChatChannel.getChannel(channelName) != null;
    }

    public static String getDefaultColor() {
        return defaultColor;
    }

    public static ChatChannel getDefaultChannel() {
        return defaultChatChannel;
    }

    public static List<ChatChannel> getAutojoinList() {
        ArrayList<ChatChannel> joinlist = new ArrayList<ChatChannel>();
        ChatChannel[] chatChannelArray = channels;
        int n = channels.length;
        int n2 = 0;
        while (n2 < n) {
            ChatChannel c = chatChannelArray[n2];
            if (c.getAutojoin().booleanValue()) {
                joinlist.add(c);
            }
            ++n2;
        }
        return joinlist;
    }

    public ChatChannel(String name, String color, String chatColor, String permission, String speakPermission, boolean mutable, boolean filter, boolean defaultChannel, String alias, double distance, boolean autojoin, boolean bungee, int cooldown, String format) {
        this.name = name;
        this.color = color;
        this.chatColor = chatColor;
        this.permission = PERMISSION_PREFIX + permission;
        this.speakPermission = PERMISSION_PREFIX + speakPermission;
        this.mutable = mutable;
        this.filter = filter;
        this.defaultChannel = defaultChannel;
        this.alias = alias;
        this.distance = distance;
        this.autojoin = autojoin;
        this.bungee = bungee;
        this.cooldown = cooldown;
        this.format = format;
    }

    @Deprecated
    public ChatChannel(String name, String color, String chatColor, String permission, String speakPermission, Boolean mutable, Boolean filter, Boolean defaultChannel, String alias, Double distance, Boolean autojoin, Boolean bungee, int cooldown, String format) {
        this.name = name;
        this.color = color;
        this.chatColor = chatColor;
        this.permission = PERMISSION_PREFIX + permission;
        this.speakPermission = PERMISSION_PREFIX + speakPermission;
        this.mutable = mutable;
        this.filter = filter;
        this.defaultChannel = defaultChannel;
        this.alias = alias;
        this.distance = distance;
        this.autojoin = autojoin;
        this.bungee = bungee;
        this.cooldown = cooldown;
        this.format = format;
    }

    public String getName() {
        return this.name;
    }

    public String getFormat() {
        return this.format;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public Boolean getBungee() {
        return this.bungee;
    }

    public String getPermission() {
        return this.permission;
    }

    public Boolean getAutojoin() {
        return this.autojoin;
    }

    public Boolean isMutable() {
        return this.mutable;
    }

    public String getColor() {
        if (Format.isValidColor(this.color)) {
            return String.valueOf(ChatColor.valueOf((String)this.color.toUpperCase()));
        }
        if (Format.isValidHexColor(this.color)) {
            return Format.convertHexColorCodeToBukkitColorCode(this.color);
        }
        return Format.DEFAULT_COLOR_CODE;
    }

    public String getColorRaw() {
        return this.color;
    }

    public String getChatColor() {
        if (this.chatColor.equalsIgnoreCase("None")) {
            return this.chatColor;
        }
        if (Format.isValidColor(this.chatColor)) {
            return String.valueOf(ChatColor.valueOf((String)this.chatColor.toUpperCase()));
        }
        if (Format.isValidHexColor(this.chatColor)) {
            return Format.convertHexColorCodeToBukkitColorCode(this.chatColor);
        }
        return Format.DEFAULT_COLOR_CODE;
    }

    public String getChatColorRaw() {
        return this.chatColor;
    }

    public Boolean isDefaultchannel() {
        return this.defaultChannel;
    }

    public String getAlias() {
        return this.alias;
    }

    public Double getDistance() {
        return this.distance;
    }

    public Boolean hasDistance() {
        return this.distance > 0.0;
    }

    public Boolean hasCooldown() {
        return this.cooldown > 0;
    }

    public Boolean hasPermission() {
        return !this.permission.equalsIgnoreCase(NO_PERMISSIONS);
    }

    public boolean hasSpeakPermission() {
        return !this.speakPermission.equalsIgnoreCase(NO_PERMISSIONS);
    }

    public String getSpeakPermission() {
        return this.speakPermission;
    }

    public Boolean isFiltered() {
        return this.filter;
    }

    public boolean equals(Object channel) {
        return channel instanceof ChatChannel && this.name.equals(((ChatChannel)channel).getName());
    }
}

