/*
 * Decompiled with CFR 0.152.
 */
package mineverse.Aust1n46.chat.command.chat;

import mineverse.Aust1n46.chat.MineverseChat;
import mineverse.Aust1n46.chat.api.MineverseChatAPI;
import mineverse.Aust1n46.chat.api.MineverseChatPlayer;
import mineverse.Aust1n46.chat.api.events.ChannelJoinEvent;
import mineverse.Aust1n46.chat.channel.ChatChannel;
import mineverse.Aust1n46.chat.command.MineverseCommand;
import mineverse.Aust1n46.chat.localization.LocalizedMessage;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class Channel
extends MineverseCommand
implements Listener {
    private MineverseChat plugin = MineverseChat.getInstance();

    public Channel() {
    }

    public Channel(String name) {
        super(name);
    }

    @Override
    public void execute(CommandSender sender, String command, String[] args) {
        if (!(sender instanceof Player)) {
            this.plugin.getServer().getConsoleSender().sendMessage(LocalizedMessage.COMMAND_MUST_BE_RUN_BY_PLAYER.toString());
            return;
        }
        MineverseChatPlayer mcp = MineverseChatAPI.getMineverseChatPlayer((Player)sender);
        if (args.length > 0) {
            if (!ChatChannel.isChannel(args[0])) {
                mcp.getPlayer().sendMessage(LocalizedMessage.INVALID_CHANNEL.toString().replace("{args}", args[0]));
                return;
            }
            ChatChannel channel = ChatChannel.getChannel(args[0]);
            this.plugin.getServer().getPluginManager().callEvent((Event)new ChannelJoinEvent(mcp.getPlayer(), channel, LocalizedMessage.SET_CHANNEL.toString().replace("{channel_color}", String.valueOf(channel.getColor())).replace("{channel_name}", channel.getName())));
            return;
        }
        mcp.getPlayer().sendMessage(LocalizedMessage.COMMAND_INVALID_ARGUMENTS.toString().replace("{command}", "/channel").replace("{args}", "[channel]"));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onChannelJoin(ChannelJoinEvent event) {
        if (event.isCancelled()) {
            return;
        }
        ChatChannel channel = event.getChannel();
        MineverseChatPlayer mcp = MineverseChatAPI.getMineverseChatPlayer(event.getPlayer());
        if (channel.hasPermission().booleanValue() && !mcp.getPlayer().hasPermission(channel.getPermission())) {
            mcp.removeListening(channel.getName());
            mcp.getPlayer().sendMessage(LocalizedMessage.CHANNEL_NO_PERMISSION.toString());
            return;
        }
        if (mcp.hasConversation()) {
            for (MineverseChatPlayer p : MineverseChat.onlinePlayers) {
                if (!p.isSpy()) continue;
                p.getPlayer().sendMessage(LocalizedMessage.EXIT_PRIVATE_CONVERSATION_SPY.toString().replace("{player_sender}", mcp.getName()).replace("{player_receiver}", MineverseChatAPI.getMineverseChatPlayer(mcp.getConversation()).getName()));
            }
            mcp.getPlayer().sendMessage(LocalizedMessage.EXIT_PRIVATE_CONVERSATION.toString().replace("{player_receiver}", MineverseChatAPI.getMineverseChatPlayer(mcp.getConversation()).getName()));
            mcp.setConversation(null);
        }
        mcp.addListening(channel.getName());
        mcp.setCurrentChannel(channel);
        mcp.getPlayer().sendMessage(event.getMessage());
        if (channel.getBungee().booleanValue()) {
            MineverseChat.getInstance().synchronize(mcp, true);
        }
    }
}

