/*
 * Decompiled with CFR 0.152.
 */
package mineverse.Aust1n46.chat.command.chat;

import mineverse.Aust1n46.chat.MineverseChat;
import mineverse.Aust1n46.chat.api.MineverseChatAPI;
import mineverse.Aust1n46.chat.api.MineverseChatPlayer;
import mineverse.Aust1n46.chat.command.MineverseCommand;
import mineverse.Aust1n46.chat.utilities.Format;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Party
extends MineverseCommand {
    private MineverseChat plugin = MineverseChat.getInstance();

    public Party(String name) {
        super(name);
    }

    @Override
    public void execute(CommandSender sender, String command, String[] args) {
        if (!(sender instanceof Player)) {
            this.plugin.getServer().getConsoleSender().sendMessage(ChatColor.RED + "This command must be run by a player.");
            return;
        }
        MineverseChatPlayer mcp = MineverseChatAPI.getMineverseChatPlayer((Player)sender);
        if (!mcp.getPlayer().hasPermission("venturechat.party")) {
            mcp.getPlayer().sendMessage(ChatColor.RED + "You do not have permission for this command!");
            return;
        }
        try {
            switch (args[0]) {
                case "host": {
                    MineverseChatPlayer player22;
                    if (!mcp.getPlayer().hasPermission("venturechat.party.host")) {
                        mcp.getPlayer().sendMessage(ChatColor.RED + "You do not have permission for this command!");
                        return;
                    }
                    if (mcp.isHost()) {
                        mcp.setHost(false);
                        mcp.getPlayer().sendMessage(ChatColor.GREEN + "You are no longer hosting a party.");
                        for (MineverseChatPlayer player22 : MineverseChat.players) {
                            if (!player22.hasParty() || !player22.getParty().equals(mcp.getParty())) continue;
                            player22.setParty(null);
                            if (player22.isOnline()) {
                                player22.getPlayer().sendMessage(ChatColor.RED + mcp.getName() + " is no longer hosting a party.");
                                continue;
                            }
                            player22.setModified(true);
                        }
                        mcp.setParty(null);
                        break;
                    }
                    mcp.setHost(true);
                    mcp.getPlayer().sendMessage(ChatColor.GREEN + "You are now hosting a party.");
                    mcp.setParty(mcp.getUUID());
                    break;
                }
                case "join": {
                    MineverseChatPlayer player22;
                    if (!mcp.getPlayer().hasPermission("venturechat.party.join")) {
                        mcp.getPlayer().sendMessage(ChatColor.RED + "You do not have permission for this command!");
                        return;
                    }
                    if (args.length > 1) {
                        player22 = MineverseChatAPI.getMineverseChatPlayer(args[1]);
                        if (player22 != null) {
                            if (player22.isHost()) {
                                if (!mcp.hasParty()) {
                                    mcp.getPlayer().sendMessage(ChatColor.GREEN + "Joined " + player22.getName() + "'s party.");
                                    mcp.setParty(player22.getUUID());
                                    player22.getPlayer().sendMessage(ChatColor.GREEN + mcp.getName() + " joined your party.");
                                    break;
                                }
                                mcp.getPlayer().sendMessage(ChatColor.RED + "You are already in " + MineverseChatAPI.getMineverseChatPlayer(mcp.getParty()).getName() + "'s party.");
                                break;
                            }
                            mcp.getPlayer().sendMessage(ChatColor.RED + player22.getName() + " is not hosting a party.");
                            break;
                        }
                        mcp.getPlayer().sendMessage(ChatColor.RED + "Player: " + ChatColor.GOLD + args[1] + ChatColor.RED + " is not online.");
                        break;
                    }
                    mcp.getPlayer().sendMessage(ChatColor.RED + "Invalid command: /party join [player]");
                    break;
                }
                case "leave": {
                    MineverseChatPlayer player22;
                    if (!mcp.getPlayer().hasPermission("venturechat.party.leave")) {
                        mcp.getPlayer().sendMessage(ChatColor.RED + "You do not have permission for this command!");
                        return;
                    }
                    if (mcp.hasParty()) {
                        mcp.getPlayer().sendMessage(ChatColor.GREEN + "Leaving " + MineverseChatAPI.getMineverseChatPlayer(mcp.getParty()).getName() + "'s party.");
                        mcp.setParty(null);
                        if (mcp.isHost()) {
                            for (MineverseChatPlayer player22 : MineverseChat.players) {
                                if (!player22.hasParty() || !player22.getParty().equals(mcp.getUUID()) || player22.getName().equals(mcp.getName())) continue;
                                player22.setParty(null);
                                if (player22.isOnline()) {
                                    player22.getPlayer().sendMessage(ChatColor.RED + mcp.getName() + " is no longer hosting a party.");
                                    continue;
                                }
                                player22.setModified(true);
                            }
                        }
                        mcp.setHost(false);
                        break;
                    }
                    mcp.getPlayer().sendMessage(ChatColor.RED + "You are not in a party.");
                    break;
                }
                case "kick": {
                    MineverseChatPlayer player22;
                    if (!mcp.getPlayer().hasPermission("venturechat.party.kick")) {
                        mcp.getPlayer().sendMessage(ChatColor.RED + "You do not have permission for this command!");
                        return;
                    }
                    if (mcp.isHost()) {
                        if (args.length > 1) {
                            player22 = MineverseChatAPI.getMineverseChatPlayer(args[1]);
                            if (player22 != null) {
                                if (!player22.getName().equals(mcp.getName())) {
                                    if (player22.hasParty() && player22.getParty().equals(mcp.getUUID())) {
                                        player22.setParty(null);
                                        player22.getPlayer().sendMessage(ChatColor.RED + "You have been kicked out of " + mcp.getName() + "'s party.");
                                        mcp.getPlayer().sendMessage(ChatColor.RED + "You have kicked " + player22.getName() + " out of your party.");
                                        break;
                                    }
                                    mcp.getPlayer().sendMessage(ChatColor.RED + "Player " + player22.getName() + " is not in your party.");
                                    break;
                                }
                                mcp.getPlayer().sendMessage(ChatColor.RED + "You cannot kick yourself.");
                                break;
                            }
                            mcp.getPlayer().sendMessage(ChatColor.RED + "Player: " + ChatColor.GOLD + args[1] + ChatColor.RED + " is not online.");
                            break;
                        }
                        mcp.getPlayer().sendMessage(ChatColor.RED + "Invalid command: /party kick [playername]");
                        break;
                    }
                    mcp.getPlayer().sendMessage(ChatColor.RED + "You are not hosting a party.");
                    break;
                }
                case "info": {
                    if (!mcp.getPlayer().hasPermission("venturechat.party.info")) {
                        mcp.getPlayer().sendMessage(ChatColor.RED + "You do not have permission for this command!");
                        return;
                    }
                    if (mcp.hasParty() && !mcp.isHost()) {
                        mcp.getPlayer().sendMessage(ChatColor.GREEN + "You are in " + MineverseChatAPI.getMineverseChatPlayer(mcp.getParty()).getName() + "'s party.");
                    } else if (mcp.isHost()) {
                        mcp.getPlayer().sendMessage(ChatColor.GREEN + "You are hosting a party.");
                    } else {
                        mcp.getPlayer().sendMessage(ChatColor.RED + "You are not hosting a party and you are not in a party.");
                    }
                    if (mcp.isPartyChat()) {
                        mcp.getPlayer().sendMessage(ChatColor.GREEN + "Party chat on.");
                        break;
                    }
                    mcp.getPlayer().sendMessage(ChatColor.GREEN + "Party chat off.");
                    break;
                }
                case "chat": {
                    if (!mcp.getPlayer().hasPermission("venturechat.party.chat")) {
                        mcp.getPlayer().sendMessage(ChatColor.RED + "You do not have permission for this command!");
                        return;
                    }
                    if (mcp.isPartyChat()) {
                        mcp.setPartyChat(false);
                        mcp.getPlayer().sendMessage(ChatColor.GREEN + "Toggled party chat off.");
                        break;
                    }
                    if (mcp.hasConversation()) {
                        String tellChat = MineverseChatAPI.getMineverseChatPlayer(mcp.getConversation()).getName();
                        mcp.setConversation(null);
                        for (MineverseChatPlayer p : MineverseChat.players) {
                            if (!p.isOnline() || !p.isSpy()) continue;
                            p.getPlayer().sendMessage(String.valueOf(mcp.getName()) + " is no longer in a private conversation with " + tellChat + ".");
                        }
                        mcp.getPlayer().sendMessage("You are no longer in private conversation with " + tellChat);
                    }
                    mcp.setPartyChat(true);
                    mcp.getPlayer().sendMessage(ChatColor.GREEN + "Toggled party chat on.");
                    break;
                }
                case "help": {
                    if (!mcp.getPlayer().hasPermission("venturechat.party.help")) {
                        mcp.getPlayer().sendMessage(ChatColor.RED + "You do not have permission for this command!");
                        return;
                    }
                    mcp.getPlayer().sendMessage(ChatColor.GREEN + "/party host\n/party join [player]\n/party leave\n/party kick [player]\n/party ban [player]\n/party unban [player]\n/party info\n/party members [player]\n/party chat\n/party help");
                    break;
                }
                case "members": {
                    MineverseChatPlayer player22;
                    if (!mcp.getPlayer().hasPermission("venturechat.party.members")) {
                        mcp.getPlayer().sendMessage(ChatColor.RED + "You do not have permission for this command!");
                        return;
                    }
                    if (args.length > 1) {
                        player22 = MineverseChatAPI.getMineverseChatPlayer(args[1]);
                        if (player22 != null) {
                            if (player22.isHost()) {
                                String members = "";
                                long linecount = this.plugin.getLineLength();
                                for (MineverseChatPlayer p : MineverseChat.players) {
                                    if (p.getParty() == null || !p.getParty().equals(player22.getUUID())) continue;
                                    if ((long)(members.length() + p.getName().length()) > linecount) {
                                        members = String.valueOf(members) + "\n";
                                        linecount += this.plugin.getLineLength();
                                    }
                                    members = p.isOnline() ? String.valueOf(members) + ChatColor.GREEN + p.getName() + ChatColor.WHITE + ", " : String.valueOf(members) + ChatColor.RED + p.getName() + ChatColor.WHITE + ", ";
                                }
                                if (members.length() > 2) {
                                    members = members.substring(0, members.length() - 2);
                                }
                                mcp.getPlayer().sendMessage(ChatColor.GREEN + "Members in " + player22.getName() + "'s party: " + members);
                                break;
                            }
                            mcp.getPlayer().sendMessage(ChatColor.RED + "Player " + player22.getName() + " is not hosting a party.");
                            break;
                        }
                        mcp.getPlayer().sendMessage(ChatColor.RED + "Player: " + ChatColor.GOLD + args[1] + ChatColor.RED + " is not online.");
                        break;
                    }
                    mcp.getPlayer().sendMessage(ChatColor.RED + "Invalid command: /party members [player]");
                }
            }
            if (!(args[0].length() <= 0 || args[0].equals("host") || args[0].equals("join") || args[0].equals("leave") || args[0].equals("kick") || args[0].equals("info") || args[0].equals("chat") || args[0].equals("help") || args[0].equals("members") || args[0].equals("ban") || args[0].equals("unban"))) {
                if (mcp.hasParty()) {
                    String msg = "";
                    String partyformat = "";
                    int x = 0;
                    while (x < args.length) {
                        if (args[x].length() > 0) {
                            msg = String.valueOf(msg) + " " + args[x];
                        }
                        ++x;
                    }
                    if (mcp.hasFilter()) {
                        msg = Format.FilterChat(msg);
                    }
                    if (mcp.getPlayer().hasPermission("venturechat.color")) {
                        msg = Format.FormatStringColor(msg);
                    }
                    if (mcp.getPlayer().hasPermission("venturechat.format")) {
                        msg = Format.FormatString(msg);
                    }
                    partyformat = this.plugin.getConfig().getString("partyformat").equalsIgnoreCase("Default") ? ChatColor.GREEN + "[" + MineverseChatAPI.getMineverseChatPlayer(mcp.getParty()).getName() + "'s Party] " + mcp.getName() + ":" + msg : String.valueOf(Format.FormatStringAll(this.plugin.getConfig().getString("partyformat").replace("{host}", MineverseChatAPI.getMineverseChatPlayer(mcp.getParty()).getName()).replace("{player}", mcp.getName()))) + msg;
                    for (MineverseChatPlayer p : MineverseChat.players) {
                        if (!p.isOnline() || !p.getParty().equals(mcp.getParty()) && !p.isSpy()) continue;
                        p.getPlayer().sendMessage(partyformat);
                    }
                    return;
                }
                mcp.getPlayer().sendMessage(ChatColor.RED + "You are not in a party.");
            }
        }
        catch (Exception e) {
            mcp.getPlayer().sendMessage(ChatColor.RED + "Invalid arguments, /party help");
        }
    }
}

