/*
 * Decompiled with CFR 0.152.
 */
package mineverse.Aust1n46.chat.command.message;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import mineverse.Aust1n46.chat.MineverseChat;
import mineverse.Aust1n46.chat.api.MineverseChatAPI;
import mineverse.Aust1n46.chat.api.MineverseChatPlayer;
import mineverse.Aust1n46.chat.command.MineverseCommand;
import mineverse.Aust1n46.chat.localization.LocalizedMessage;
import mineverse.Aust1n46.chat.utilities.Format;
import mineverse.Aust1n46.chat.versions.VersionHandler;
import org.bukkit.ChatColor;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class Message
extends MineverseCommand {
    private MineverseChat plugin = MineverseChat.getInstance();

    public Message(String name) {
        super(name);
    }

    @Override
    public void execute(CommandSender sender, String command, String[] args) {
        if (!(sender instanceof Player)) {
            this.plugin.getServer().getConsoleSender().sendMessage(LocalizedMessage.COMMAND_MUST_BE_RUN_BY_PLAYER.toString());
            return;
        }
        MineverseChatPlayer mcp = MineverseChatAPI.getMineverseChatPlayer((Player)sender);
        if (args.length == 0) {
            mcp.getPlayer().sendMessage(LocalizedMessage.COMMAND_INVALID_ARGUMENTS.toString().replace("{command}", "/" + command).replace("{args}", "[player] [message]"));
            return;
        }
        if (this.plugin.getConfig().getBoolean("bungeecordmessaging", true)) {
            if (args.length < 2) {
                mcp.getPlayer().sendMessage(LocalizedMessage.COMMAND_INVALID_ARGUMENTS.toString().replace("{command}", "/" + command).replace("{args}", "[player] [message]"));
                return;
            }
            ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(byteOutStream);
            String msg = "";
            String send = "";
            String echo = "";
            String spy = "";
            int r = 1;
            while (r < args.length) {
                msg = String.valueOf(msg) + " " + args[r];
                ++r;
            }
            if (mcp.hasFilter()) {
                msg = Format.FilterChat(msg);
            }
            if (mcp.getPlayer().hasPermission("venturechat.color")) {
                msg = Format.FormatStringColor(msg);
            }
            if (mcp.getPlayer().hasPermission("venturechat.format")) {
                msg = Format.FormatString(msg);
            }
            send = String.valueOf(Format.FormatStringAll(this.plugin.getConfig().getString("tellformatfrom"))) + msg;
            echo = String.valueOf(Format.FormatStringAll(this.plugin.getConfig().getString("tellformatto"))) + msg;
            spy = String.valueOf(Format.FormatStringAll(this.plugin.getConfig().getString("tellformatspy"))) + msg;
            try {
                out.writeUTF("Message");
                out.writeUTF("Send");
                out.writeUTF(args[0]);
                out.writeUTF(mcp.getUUID().toString());
                out.writeUTF(mcp.getName());
                out.writeUTF(send);
                out.writeUTF(echo);
                out.writeUTF(spy);
                mcp.getPlayer().sendPluginMessage((Plugin)this.plugin, "venturechat:data", byteOutStream.toByteArray());
                out.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        MineverseChatPlayer player = MineverseChatAPI.getMineverseChatPlayer(args[0]);
        for (MineverseChatPlayer p : MineverseChat.onlinePlayers) {
            if (!ChatColor.stripColor((String)p.getNickname()).equals(args[0])) continue;
            player = p;
            break;
        }
        if (player == null || !player.isOnline()) {
            mcp.getPlayer().sendMessage(LocalizedMessage.PLAYER_OFFLINE.toString().replace("{args}", args[0]));
            return;
        }
        if (!mcp.getPlayer().canSee(player.getPlayer())) {
            mcp.getPlayer().sendMessage(LocalizedMessage.PLAYER_OFFLINE.toString().replace("{args}", args[0]));
            return;
        }
        if (player.getIgnores().contains(mcp.getUUID())) {
            mcp.getPlayer().sendMessage(LocalizedMessage.IGNORING_MESSAGE.toString().replace("{player}", player.getName()));
            return;
        }
        if (!player.getMessageToggle()) {
            mcp.getPlayer().sendMessage(LocalizedMessage.BLOCKING_MESSAGE.toString().replace("{player}", player.getName()));
            return;
        }
        if (args.length >= 2) {
            String msg = "";
            String echo = "";
            String send = "";
            String spy = "";
            String tellColor = this.plugin.getConfig().getString("tellcolor", "gray");
            if (args[1].length() > 0) {
                int r = 1;
                while (r < args.length) {
                    msg = String.valueOf(msg) + " " + args[r];
                    ++r;
                }
                if (mcp.hasFilter()) {
                    msg = Format.FilterChat(msg);
                }
                if (mcp.getPlayer().hasPermission("venturechat.color")) {
                    msg = Format.FormatStringColor(msg);
                }
                if (mcp.getPlayer().hasPermission("venturechat.format")) {
                    msg = Format.FormatString(msg);
                }
                echo = this.plugin.getConfig().getString("tellformatto").equalsIgnoreCase("Default") ? "You message " + player.getNickname() + ":" + ChatColor.valueOf((String)tellColor.toUpperCase()) + msg : String.valueOf(Format.FormatStringAll(this.plugin.getConfig().getString("tellformatto").replace("{playerto}", player.getNickname()).replace("{playerfrom}", mcp.getNickname()))) + msg;
                send = this.plugin.getConfig().getString("tellformatfrom").equalsIgnoreCase("Default") ? String.valueOf(mcp.getNickname()) + " messages you:" + ChatColor.valueOf((String)tellColor.toUpperCase()) + msg : String.valueOf(Format.FormatStringAll(this.plugin.getConfig().getString("tellformatfrom").replace("{playerto}", player.getNickname()).replace("{playerfrom}", mcp.getNickname()))) + msg;
                spy = this.plugin.getConfig().getString("tellformatspy").equalsIgnoreCase("Default") ? String.valueOf(mcp.getName()) + " messages " + player.getName() + ":" + ChatColor.valueOf((String)tellColor.toUpperCase()) + msg : String.valueOf(Format.FormatStringAll(this.plugin.getConfig().getString("tellformatspy").replace("{playerto}", player.getName()).replace("{playerfrom}", mcp.getName()))) + msg;
                player.setReplyPlayer(mcp.getUUID());
                mcp.setReplyPlayer(player.getUUID());
                player.getPlayer().sendMessage(send);
                mcp.getPlayer().sendMessage(echo);
                if (player.hasNotifications()) {
                    if (VersionHandler.is1_8() || VersionHandler.is1_7_10() || VersionHandler.is1_7_2() || VersionHandler.is1_7_9()) {
                        player.getPlayer().playSound(player.getPlayer().getLocation(), Sound.valueOf((String)"LEVEL_UP"), 1.0f, 0.0f);
                    } else {
                        player.getPlayer().playSound(player.getPlayer().getLocation(), Sound.valueOf((String)"ENTITY_PLAYER_LEVELUP"), 1.0f, 0.0f);
                    }
                }
                if (!mcp.getPlayer().hasPermission("venturechat.spy.override")) {
                    for (MineverseChatPlayer sp : MineverseChat.onlinePlayers) {
                        if (!sp.isSpy()) continue;
                        sp.getPlayer().sendMessage(spy);
                    }
                }
            }
        }
        if (args.length == 1 && args[0].length() > 0) {
            if (!mcp.hasConversation() || mcp.hasConversation() && !mcp.getConversation().toString().equals(player.getUUID().toString())) {
                mcp.setConversation(player.getUUID());
                if (!mcp.getPlayer().hasPermission("venturechat.spy.override")) {
                    for (MineverseChatPlayer sp : MineverseChat.onlinePlayers) {
                        if (!sp.isSpy()) continue;
                        sp.getPlayer().sendMessage(LocalizedMessage.ENTER_PRIVATE_CONVERSATION_SPY.toString().replace("{player_sender}", mcp.getName()).replace("{player_receiver}", player.getName()));
                    }
                }
                mcp.getPlayer().sendMessage(LocalizedMessage.ENTER_PRIVATE_CONVERSATION.toString().replace("{player_receiver}", player.getName()));
            } else {
                mcp.setConversation(null);
                if (!mcp.getPlayer().hasPermission("venturechat.spy.override")) {
                    for (MineverseChatPlayer sp : MineverseChat.onlinePlayers) {
                        if (!sp.isSpy()) continue;
                        sp.getPlayer().sendMessage(LocalizedMessage.EXIT_PRIVATE_CONVERSATION_SPY.toString().replace("{player_sender}", mcp.getName()).replace("{player_receiver}", player.getName()));
                    }
                }
                mcp.getPlayer().sendMessage(LocalizedMessage.EXIT_PRIVATE_CONVERSATION.toString().replace("{player_receiver}", player.getName()));
            }
        }
    }
}

