/*
 * Decompiled with CFR 0.152.
 */
package mineverse.Aust1n46.chat.command.message;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import mineverse.Aust1n46.chat.MineverseChat;
import mineverse.Aust1n46.chat.api.MineverseChatAPI;
import mineverse.Aust1n46.chat.api.MineverseChatPlayer;
import mineverse.Aust1n46.chat.command.MineverseCommand;
import mineverse.Aust1n46.chat.localization.LocalizedMessage;
import mineverse.Aust1n46.chat.utilities.Format;
import mineverse.Aust1n46.chat.versions.VersionHandler;
import org.bukkit.ChatColor;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class Reply
extends MineverseCommand {
    private MineverseChat plugin = MineverseChat.getInstance();

    public Reply(String name) {
        super(name);
    }

    @Override
    public void execute(CommandSender sender, String command, String[] args) {
        if (!(sender instanceof Player)) {
            this.plugin.getServer().getConsoleSender().sendMessage(LocalizedMessage.COMMAND_MUST_BE_RUN_BY_PLAYER.toString());
            return;
        }
        MineverseChatPlayer mcp = MineverseChatAPI.getMineverseChatPlayer((Player)sender);
        if (args.length > 0) {
            if (mcp.hasReplyPlayer()) {
                MineverseChatPlayer player = MineverseChatAPI.getMineverseChatPlayer(mcp.getReplyPlayer());
                if (this.plugin.getConfig().getBoolean("bungeecordmessaging", true)) {
                    ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();
                    DataOutputStream out = new DataOutputStream(byteOutStream);
                    String msg = "";
                    String send = "";
                    String echo = "";
                    String spy = "";
                    int r = 0;
                    while (r < args.length) {
                        msg = String.valueOf(msg) + " " + args[r];
                        ++r;
                    }
                    send = String.valueOf(Format.FormatStringAll(this.plugin.getConfig().getString("replyformatfrom"))) + msg;
                    echo = String.valueOf(Format.FormatStringAll(this.plugin.getConfig().getString("replyformatto"))) + msg;
                    spy = String.valueOf(Format.FormatStringAll(this.plugin.getConfig().getString("replyformatspy"))) + msg;
                    try {
                        out.writeUTF("Message");
                        out.writeUTF("Send");
                        out.writeUTF(player.getName());
                        out.writeUTF(mcp.getUUID().toString());
                        out.writeUTF(mcp.getName());
                        out.writeUTF(send);
                        out.writeUTF(echo);
                        out.writeUTF(spy);
                        mcp.getPlayer().sendPluginMessage((Plugin)this.plugin, "venturechat:data", byteOutStream.toByteArray());
                        out.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return;
                }
                if (player == null || !player.isOnline()) {
                    mcp.getPlayer().sendMessage(LocalizedMessage.NO_PLAYER_TO_REPLY_TO.toString());
                    return;
                }
                if (!mcp.getPlayer().canSee(player.getPlayer())) {
                    mcp.getPlayer().sendMessage(LocalizedMessage.NO_PLAYER_TO_REPLY_TO.toString());
                    return;
                }
                if (player.getIgnores().contains(mcp.getUUID())) {
                    mcp.getPlayer().sendMessage(LocalizedMessage.IGNORING_MESSAGE.toString().replace("{player}", player.getName()));
                    return;
                }
                if (!player.getMessageToggle()) {
                    mcp.getPlayer().sendMessage(LocalizedMessage.BLOCKING_MESSAGE.toString().replace("{player}", player.getName()));
                    return;
                }
                String msg = "";
                String echo = "";
                String send = "";
                String spy = "";
                String tellColor = this.plugin.getConfig().getString("tellcolor", "gray");
                if (args.length > 0) {
                    int r = 0;
                    while (r < args.length) {
                        msg = String.valueOf(msg) + " " + args[r];
                        ++r;
                    }
                    if (mcp.hasFilter()) {
                        msg = Format.FilterChat(msg);
                    }
                    if (mcp.getPlayer().hasPermission("venturechat.color")) {
                        msg = Format.FormatStringColor(msg);
                    }
                    if (mcp.getPlayer().hasPermission("venturechat.format")) {
                        msg = Format.FormatString(msg);
                    }
                    echo = this.plugin.getConfig().getString("replyformatto").equalsIgnoreCase("Default") ? "You reply to " + player.getNickname() + ":" + ChatColor.valueOf((String)tellColor.toUpperCase()) + msg : String.valueOf(Format.FormatStringAll(this.plugin.getConfig().getString("replyformatto").replace("{playerto}", player.getNickname()).replace("{playerfrom}", mcp.getNickname()))) + msg;
                    send = this.plugin.getConfig().getString("replyformatfrom").equalsIgnoreCase("Default") ? String.valueOf(mcp.getNickname()) + " replies to you:" + ChatColor.valueOf((String)tellColor.toUpperCase()) + msg : String.valueOf(Format.FormatStringAll(this.plugin.getConfig().getString("replyformatfrom").replace("{playerto}", player.getNickname()).replace("{playerfrom}", mcp.getNickname()))) + msg;
                    spy = this.plugin.getConfig().getString("replyformatspy").equalsIgnoreCase("Default") ? String.valueOf(mcp.getName()) + " replied to " + player.getName() + ":" + ChatColor.valueOf((String)tellColor.toUpperCase()) + msg : String.valueOf(Format.FormatStringAll(this.plugin.getConfig().getString("replyformatspy").replace("{playerto}", player.getName()).replace("{playerfrom}", mcp.getName()))) + msg;
                    if (!mcp.getPlayer().hasPermission("venturechat.spy.override")) {
                        for (MineverseChatPlayer p : MineverseChat.onlinePlayers) {
                            if (!p.isOnline() || !p.isSpy()) continue;
                            p.getPlayer().sendMessage(spy);
                        }
                    }
                    player.getPlayer().sendMessage(send);
                    mcp.getPlayer().sendMessage(echo);
                    if (player.hasNotifications()) {
                        if (VersionHandler.is1_8() || VersionHandler.is1_7_10() || VersionHandler.is1_7_2() || VersionHandler.is1_7_9()) {
                            player.getPlayer().playSound(player.getPlayer().getLocation(), Sound.valueOf((String)"LEVEL_UP"), 1.0f, 0.0f);
                        } else {
                            player.getPlayer().playSound(player.getPlayer().getLocation(), Sound.valueOf((String)"ENTITY_PLAYER_LEVELUP"), 1.0f, 0.0f);
                        }
                    }
                    player.setReplyPlayer(mcp.getUUID());
                    return;
                }
            }
            mcp.getPlayer().sendMessage(LocalizedMessage.NO_PLAYER_TO_REPLY_TO.toString());
            return;
        }
        mcp.getPlayer().sendMessage(LocalizedMessage.COMMAND_INVALID_ARGUMENTS.toString().replace("{command}", "/reply").replace("{args}", "[message]"));
    }
}

