/*
 * Decompiled with CFR 0.152.
 */
package mineverse.Aust1n46.chat.database;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.UUID;
import mineverse.Aust1n46.chat.MineverseChat;
import mineverse.Aust1n46.chat.api.MineverseChatPlayer;
import mineverse.Aust1n46.chat.channel.ChatChannel;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class PlayerData {
    private static FileConfiguration playerData;
    private static File playerDataFile;
    private static MineverseChat plugin;

    public static void initialize() {
        plugin = MineverseChat.getInstance();
        playerDataFile = new File(plugin.getDataFolder().getAbsolutePath(), "Players.yml");
        if (!playerDataFile.isFile()) {
            plugin.saveResource("Players.yml", true);
        }
        playerData = YamlConfiguration.loadConfiguration((File)playerDataFile);
    }

    public static FileConfiguration getPlayerData() {
        return playerData;
    }

    public static void savePlayerData() {
        try {
            for (MineverseChatPlayer p : MineverseChat.players) {
                if (!p.wasModified() && !p.isOnline()) continue;
                ConfigurationSection cs = playerData.getConfigurationSection("players." + p.getUUID().toString());
                String nickname = p.getNickname();
                if (cs == null) {
                    ConfigurationSection ps = playerData.getConfigurationSection("players");
                    if (ps == null) {
                        cs = playerData.createSection("players");
                    }
                    cs = playerData.createSection("players." + p.getUUID().toString());
                }
                cs.set("name", (Object)p.getName());
                cs.set("current", (Object)p.getCurrentChannel().getName());
                String ignores = "";
                for (UUID s : p.getIgnores()) {
                    ignores = String.valueOf(ignores) + s.toString() + ",";
                }
                cs.set("ignores", (Object)ignores);
                String listening = "";
                for (String channel : p.getListening()) {
                    ChatChannel c = ChatChannel.getChannel(channel);
                    listening = String.valueOf(listening) + c.getName() + ",";
                }
                String mutes = "";
                for (String channel : p.getMutes().keySet()) {
                    ChatChannel c = ChatChannel.getChannel(channel);
                    mutes = String.valueOf(mutes) + c.getName() + ":" + p.getMutes().get(c.getName()) + ",";
                }
                String blockedCommands = "";
                for (String s : p.getBlockedCommands()) {
                    blockedCommands = String.valueOf(blockedCommands) + s + ",";
                }
                if (listening.length() > 0) {
                    listening = listening.substring(0, listening.length() - 1);
                }
                cs.set("listen", (Object)listening);
                if (mutes.length() > 0) {
                    mutes = mutes.substring(0, mutes.length() - 1);
                }
                cs.set("mutes", (Object)mutes);
                if (blockedCommands.length() > 0) {
                    blockedCommands = blockedCommands.substring(0, blockedCommands.length() - 1);
                }
                cs.set("blockedcommands", (Object)blockedCommands);
                cs.set("host", (Object)p.isHost());
                cs.set("party", (Object)(p.hasParty() ? p.getParty().toString() : ""));
                cs.set("filter", (Object)p.hasFilter());
                cs.set("notifications", (Object)p.hasNotifications());
                cs.set("nickname", (Object)nickname);
                cs.set("spy", (Object)p.isSpy());
                cs.set("commandspy", (Object)p.hasCommandSpy());
                cs.set("rangedspy", (Object)p.getRangedSpy());
                cs.set("messagetoggle", (Object)p.getMessageToggle());
                cs.set("bungeetoggle", (Object)p.getBungeeToggle());
                Calendar currentDate = Calendar.getInstance();
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MMM/dd HH:mm:ss");
                String dateNow = formatter.format(currentDate.getTime());
                cs.set("date", (Object)dateNow);
                p.setModified(false);
            }
            playerData.save(playerDataFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

