/*
 * Decompiled with CFR 0.152.
 */
package mineverse.Aust1n46.chat.listeners;

import com.comphenix.protocol.events.PacketContainer;
import com.massivecraft.factions.entity.MPlayer;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Set;
import me.clip.placeholderapi.PlaceholderAPI;
import mineverse.Aust1n46.chat.MineverseChat;
import mineverse.Aust1n46.chat.api.MineverseChatAPI;
import mineverse.Aust1n46.chat.api.MineverseChatPlayer;
import mineverse.Aust1n46.chat.api.events.ChannelJoinEvent;
import mineverse.Aust1n46.chat.api.events.VentureChatEvent;
import mineverse.Aust1n46.chat.channel.ChatChannel;
import mineverse.Aust1n46.chat.localization.LocalizedMessage;
import mineverse.Aust1n46.chat.utilities.Format;
import mineverse.Aust1n46.chat.versions.VersionHandler;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class ChatListener
implements Listener {
    private static final int MILLISECONDS_PER_MINUTE = 60000;
    private static final int MILLISECONDS_PER_SECOND = 1000;
    private MineverseChat plugin = MineverseChat.getInstance();

    @EventHandler(priority=EventPriority.NORMAL)
    public void onChannelJoin(ChannelJoinEvent event) {
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onAsyncPlayerChatEvent(final AsyncPlayerChatEvent event) {
        event.setCancelled(true);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                ChatListener.this.handleTrueAsyncPlayerChatEvent(event);
            }
        });
    }

    public void handleTrueAsyncPlayerChatEvent(AsyncPlayerChatEvent event) {
        boolean bungee = false;
        String chat = event.getMessage();
        Set recipients = event.getRecipients();
        int recipientCount = recipients.size();
        MineverseChatPlayer mcp = MineverseChatAPI.getOnlineMineverseChatPlayer(event.getPlayer());
        ChatChannel eventChannel = mcp.getCurrentChannel();
        if (mcp.isEditing()) {
            mcp.getPlayer().sendMessage(Format.FormatStringAll(chat));
            mcp.setEditing(false);
            return;
        }
        if (mcp.isQuickChat()) {
            eventChannel = mcp.getQuickChannel();
        }
        if (mcp.hasConversation() && !mcp.isQuickChat()) {
            MineverseChatPlayer tp = MineverseChatAPI.getMineverseChatPlayer(mcp.getConversation());
            if (!tp.isOnline()) {
                mcp.getPlayer().sendMessage(ChatColor.RED + tp.getName() + " is not available.");
                if (!mcp.getPlayer().hasPermission("venturechat.spy.override")) {
                    for (MineverseChatPlayer p : MineverseChat.onlinePlayers) {
                        if (!p.isSpy()) continue;
                        p.getPlayer().sendMessage(LocalizedMessage.EXIT_PRIVATE_CONVERSATION_SPY.toString().replace("{player_sender}", mcp.getName()).replace("{player_receiver}", tp.getName()));
                    }
                }
                mcp.setConversation(null);
            } else {
                if (tp.getIgnores().contains(mcp.getUUID())) {
                    mcp.getPlayer().sendMessage(LocalizedMessage.IGNORING_MESSAGE.toString().replace("{player}", tp.getName()));
                    event.setCancelled(true);
                    return;
                }
                if (!tp.getMessageToggle()) {
                    mcp.getPlayer().sendMessage(LocalizedMessage.BLOCKING_MESSAGE.toString().replace("{player}", tp.getName()));
                    event.setCancelled(true);
                    return;
                }
                String filtered = chat;
                String echo = "";
                String send = "";
                String spy = "";
                String tellColor = this.plugin.getConfig().getString("tellcolor", "gray");
                if (mcp.hasFilter()) {
                    filtered = Format.FilterChat(filtered);
                }
                if (mcp.getPlayer().hasPermission("venturechat.color")) {
                    filtered = Format.FormatStringColor(filtered);
                }
                if (mcp.getPlayer().hasPermission("venturechat.format")) {
                    filtered = Format.FormatString(filtered);
                }
                filtered = " " + filtered;
                echo = this.plugin.getConfig().getString("tellformatto").equalsIgnoreCase("Default") ? "You message " + tp.getPlayer().getDisplayName() + ":" + ChatColor.valueOf((String)tellColor.toUpperCase()) + filtered : String.valueOf(Format.FormatStringAll(this.plugin.getConfig().getString("tellformatto").replace("{playerto}", tp.getPlayer().getDisplayName()).replace("{playerfrom}", mcp.getPlayer().getDisplayName()))) + filtered;
                send = this.plugin.getConfig().getString("tellformatfrom").equalsIgnoreCase("Default") ? String.valueOf(mcp.getPlayer().getDisplayName()) + " messages you:" + ChatColor.valueOf((String)tellColor.toUpperCase()) + filtered : String.valueOf(Format.FormatStringAll(this.plugin.getConfig().getString("tellformatfrom").replace("{playerto}", tp.getPlayer().getDisplayName()).replace("{playerfrom}", mcp.getPlayer().getDisplayName()))) + filtered;
                spy = this.plugin.getConfig().getString("tellformatspy").equalsIgnoreCase("Default") ? String.valueOf(mcp.getName()) + " messages " + tp.getName() + ":" + ChatColor.valueOf((String)tellColor.toUpperCase()) + filtered : String.valueOf(Format.FormatStringAll(this.plugin.getConfig().getString("tellformatspy").replace("{playerto}", tp.getName()).replace("{playerfrom}", mcp.getName()))) + filtered;
                if (!mcp.getPlayer().hasPermission("venturechat.spy.override")) {
                    for (MineverseChatPlayer p : MineverseChat.onlinePlayers) {
                        if (!p.isOnline() || !p.isSpy()) continue;
                        p.getPlayer().sendMessage(spy);
                    }
                }
                tp.getPlayer().sendMessage(send);
                mcp.getPlayer().sendMessage(echo);
                if (tp.hasNotifications()) {
                    if (VersionHandler.is1_8()) {
                        tp.getPlayer().playSound(tp.getPlayer().getLocation(), Sound.valueOf((String)"LEVEL_UP"), 1.0f, 0.0f);
                    }
                    if (VersionHandler.is1_9()) {
                        tp.getPlayer().playSound(tp.getPlayer().getLocation(), Sound.valueOf((String)"ENTITY_PLAYER_LEVELUP"), 1.0f, 0.0f);
                    }
                }
                mcp.setReplyPlayer(tp.getUUID());
                tp.setReplyPlayer(mcp.getUUID());
                Bukkit.getConsoleSender().sendMessage(String.valueOf(mcp.getName()) + " messages " + tp.getName() + ":" + ChatColor.valueOf((String)tellColor.toUpperCase()) + filtered);
                if (this.plugin.db != null) {
                    Calendar currentDate = Calendar.getInstance();
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String date = formatter.format(currentDate.getTime());
                    this.plugin.db.writeVentureChat(date, mcp.getUUID().toString(), mcp.getName(), "Local", "Messaging_Component", chat.replace("'", "''"), "Chat");
                }
            }
            return;
        }
        if (mcp.isPartyChat() && !mcp.isQuickChat()) {
            if (mcp.hasParty()) {
                String partyformat = "";
                for (MineverseChatPlayer p : MineverseChat.onlinePlayers) {
                    if ((!p.hasParty() || !p.getParty().toString().equals(mcp.getParty().toString())) && !p.isSpy()) continue;
                    String filtered = chat;
                    if (mcp.hasFilter()) {
                        filtered = Format.FilterChat(filtered);
                    }
                    if (mcp.getPlayer().hasPermission("venturechat.color")) {
                        filtered = Format.FormatStringColor(filtered);
                    }
                    if (mcp.getPlayer().hasPermission("venturechat.format")) {
                        filtered = Format.FormatString(filtered);
                    }
                    filtered = " " + filtered;
                    partyformat = this.plugin.getConfig().getString("partyformat").equalsIgnoreCase("Default") ? ChatColor.GREEN + "[" + MineverseChatAPI.getMineverseChatPlayer(mcp.getParty()).getName() + "'s Party] " + mcp.getName() + ":" + filtered : String.valueOf(Format.FormatStringAll(this.plugin.getConfig().getString("partyformat").replace("{host}", MineverseChatAPI.getMineverseChatPlayer(mcp.getParty()).getName()).replace("{player}", mcp.getName()))) + filtered;
                    p.getPlayer().sendMessage(partyformat);
                }
                Bukkit.getConsoleSender().sendMessage(partyformat);
                if (this.plugin.db != null) {
                    Calendar currentDate = Calendar.getInstance();
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String date = formatter.format(currentDate.getTime());
                    this.plugin.db.writeVentureChat(date, mcp.getUUID().toString(), mcp.getName(), "Local", "Party_Component", chat.replace("'", "''"), "Chat");
                }
                return;
            }
            mcp.getPlayer().sendMessage(ChatColor.RED + "You are not in a party.");
            return;
        }
        Location locsender = mcp.getPlayer().getLocation();
        Boolean filterthis = true;
        mcp.addListening(eventChannel.getName());
        if (mcp.isMuted(eventChannel.getName())) {
            if (mcp.getMutes().get(eventChannel.getName()) > 0) {
                int dateTimeMillis = Format.currentTimeMillis();
                String units = LocalizedMessage.UNITS_MINUTE_PLURAL.toString();
                int muteTimeMillis = mcp.getMutes().get(eventChannel.getName());
                int remainingMuteTime = (muteTimeMillis - dateTimeMillis) / 60000;
                if (remainingMuteTime <= 0) {
                    remainingMuteTime = 1;
                }
                if (remainingMuteTime == 1) {
                    units = LocalizedMessage.UNITS_MINUTE_SINGULAR.toString();
                }
                mcp.getPlayer().sendMessage(LocalizedMessage.CHANNEL_MUTED_TIMED.toString().replace("{channel_color}", eventChannel.getColor()).replace("{channel_name}", eventChannel.getName()).replace("{time}", String.valueOf(remainingMuteTime)).replace("{units}", units));
            } else {
                mcp.getPlayer().sendMessage(LocalizedMessage.CHANNEL_MUTED.toString().replace("{channel_color}", eventChannel.getColor()).replace("{channel_name}", eventChannel.getName()));
            }
            mcp.setQuickChat(false);
            return;
        }
        Double chDistance = 0.0;
        int chCooldown = 0;
        String curColor = "";
        if (eventChannel.hasPermission().booleanValue() && !mcp.getPlayer().hasPermission(eventChannel.getPermission())) {
            mcp.getPlayer().sendMessage(LocalizedMessage.CHANNEL_NO_PERMISSION.toString());
            mcp.setQuickChat(false);
            mcp.removeListening(eventChannel.getName());
            mcp.setCurrentChannel(ChatChannel.getDefaultChannel());
            return;
        }
        if (eventChannel.hasSpeakPermission() && !mcp.getPlayer().hasPermission(eventChannel.getSpeakPermission())) {
            mcp.getPlayer().sendMessage(LocalizedMessage.CHANNEL_NO_SPEAK_PERMISSIONS.toString());
            mcp.setQuickChat(false);
            return;
        }
        curColor = eventChannel.getChatColor();
        bungee = eventChannel.getBungee();
        int dateTimeSeconds = Format.currentTimeMillis() / 1000;
        if (eventChannel.hasCooldown().booleanValue()) {
            chCooldown = eventChannel.getCooldown();
        }
        try {
            int cooldownTime;
            if (mcp.hasCooldown(eventChannel) && dateTimeSeconds < (cooldownTime = mcp.getCooldowns().get(eventChannel).intValue())) {
                int remainingCooldownTime = cooldownTime - dateTimeSeconds;
                String units = LocalizedMessage.UNITS_SECOND_PLURAL.toString();
                if (remainingCooldownTime == 1) {
                    units = LocalizedMessage.UNITS_SECOND_SINGULAR.toString();
                }
                mcp.getPlayer().sendMessage(LocalizedMessage.CHANNEL_COOLDOWN.toString().replace("{cooldown}", String.valueOf(remainingCooldownTime)).replace("{units}", units));
                mcp.setQuickChat(false);
                bungee = false;
                return;
            }
            if (eventChannel.hasCooldown().booleanValue() && !mcp.getPlayer().hasPermission("venturechat.cooldown.bypass")) {
                mcp.addCooldown(eventChannel, dateTimeSeconds + chCooldown);
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        if (mcp.hasSpam(eventChannel) && this.plugin.getConfig().getConfigurationSection("antispam").getBoolean("enabled") && !mcp.getPlayer().hasPermission("venturechat.spam.bypass")) {
            int spamcount = mcp.getSpam().get(eventChannel).get(0);
            int spamtime = mcp.getSpam().get(eventChannel).get(1);
            int spamtimeconfig = this.plugin.getConfig().getConfigurationSection("antispam").getInt("spamnumber");
            int mutedForTime = this.plugin.getConfig().getConfigurationSection("antispam").getInt("mutetime", 0);
            int dateTime = Format.currentTimeMillis();
            if (dateTimeSeconds < spamtime + this.plugin.getConfig().getConfigurationSection("antispam").getInt("spamtime")) {
                if (spamcount + 1 >= spamtimeconfig) {
                    if (mutedForTime > 0) {
                        mcp.addMute(eventChannel.getName(), dateTime + mutedForTime * 60000);
                        String units = LocalizedMessage.UNITS_MINUTE_PLURAL.toString();
                        if (mutedForTime == 1) {
                            units = LocalizedMessage.UNITS_MINUTE_SINGULAR.toString();
                        }
                        mcp.getPlayer().sendMessage(LocalizedMessage.MUTE_PLAYER_SPAM_TIME.toString().replace("{channel_color}", eventChannel.getColor()).replace("{channel_name}", eventChannel.getName()).replace("{time}", String.valueOf(mutedForTime)).replace("{units}", units));
                    } else {
                        mcp.addMute(eventChannel.getName(), 0);
                        mcp.getPlayer().sendMessage(LocalizedMessage.MUTE_PLAYER_SPAM.toString().replace("{channel_color}", eventChannel.getColor()).replace("{channel_name}", eventChannel.getName()));
                    }
                    mcp.getSpam().get(eventChannel).set(0, 0);
                    mcp.setQuickChat(false);
                    return;
                }
                if (spamtimeconfig % 2 != 0) {
                    ++spamtimeconfig;
                }
                if (spamcount + 1 == spamtimeconfig / 2) {
                    mcp.getPlayer().sendMessage(LocalizedMessage.SPAM_WARNING.toString());
                }
                mcp.getSpam().get(eventChannel).set(0, spamcount + 1);
            } else {
                mcp.getSpam().get(eventChannel).set(0, 1);
                mcp.getSpam().get(eventChannel).set(1, dateTimeSeconds);
            }
        } else {
            mcp.addSpam(eventChannel);
            mcp.getSpam().get(eventChannel).add(0, 1);
            mcp.getSpam().get(eventChannel).add(1, dateTimeSeconds);
        }
        if (eventChannel.hasDistance().booleanValue()) {
            chDistance = eventChannel.getDistance();
        }
        String format = Format.FormatStringAll(PlaceholderAPI.setBracketPlaceholders((Player)mcp.getPlayer(), (String)Format.FormatStringAll(this.plugin.getConfig().getConfigurationSection("channels." + eventChannel.getName()).getString("format"))));
        if (this.plugin.getConfig().getBoolean("formatcleaner", false)) {
            format = format.replace("[]", " ");
            format = format.replace("    ", " ").replace("   ", " ").replace("  ", " ");
        }
        if ((filterthis = eventChannel.isFiltered()).booleanValue() && mcp.hasFilter()) {
            chat = Format.FilterChat(chat);
        }
        PluginManager pluginManager = this.plugin.getServer().getPluginManager();
        for (MineverseChatPlayer p : MineverseChat.onlinePlayers) {
            if (p.getPlayer() == mcp.getPlayer()) continue;
            if (!p.isListening(eventChannel.getName())) {
                recipients.remove(p.getPlayer());
                --recipientCount;
                continue;
            }
            if (this.plugin.getConfig().getBoolean("ignorechat", false) && p.getIgnores().contains(mcp.getUUID())) {
                recipients.remove(p.getPlayer());
                --recipientCount;
                continue;
            }
            if (this.plugin.getConfig().getBoolean("enable_towny_channel") && pluginManager.isPluginEnabled("Towny")) {
                try {
                    if (eventChannel.getName().equalsIgnoreCase("Town")) {
                        Resident r = TownyUniverse.getDataSource().getResident(p.getName());
                        Resident pp = TownyUniverse.getDataSource().getResident(mcp.getName());
                        if (!pp.hasTown()) {
                            recipients.remove(p.getPlayer());
                            --recipientCount;
                            continue;
                        }
                        if (!r.hasTown()) {
                            recipients.remove(p.getPlayer());
                            --recipientCount;
                            continue;
                        }
                        if (!r.getTown().getName().equals(pp.getTown().getName())) {
                            recipients.remove(p.getPlayer());
                            --recipientCount;
                            continue;
                        }
                    }
                    if (eventChannel.getName().equalsIgnoreCase("Nation")) {
                        Resident r = TownyUniverse.getDataSource().getResident(p.getName());
                        Resident pp = TownyUniverse.getDataSource().getResident(mcp.getName());
                        if (!pp.hasNation()) {
                            recipients.remove(p.getPlayer());
                            --recipientCount;
                            continue;
                        }
                        if (!r.hasNation()) {
                            recipients.remove(p.getPlayer());
                            --recipientCount;
                            continue;
                        }
                        if (!r.getTown().getNation().getName().equals(pp.getTown().getNation().getName())) {
                            recipients.remove(p.getPlayer());
                            --recipientCount;
                            continue;
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (this.plugin.getConfig().getBoolean("enable_factions_channel") && pluginManager.isPluginEnabled("Factions")) {
                try {
                    if (eventChannel.getName().equalsIgnoreCase("Faction")) {
                        MPlayer mplayer = MPlayer.get((Object)mcp.getPlayer());
                        MPlayer mplayerp = MPlayer.get((Object)p.getPlayer());
                        if (!mplayer.hasFaction()) {
                            recipients.remove(p.getPlayer());
                            --recipientCount;
                        } else if (!mplayerp.hasFaction()) {
                            recipients.remove(p.getPlayer());
                            --recipientCount;
                        } else if (!mplayer.getFactionName().equals(mplayerp.getFactionName())) {
                            recipients.remove(p.getPlayer());
                            --recipientCount;
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (chDistance > 0.0 && !bungee && !p.getRangedSpy()) {
                Location locreceip = p.getPlayer().getLocation();
                if (locreceip.getWorld() == mcp.getPlayer().getWorld()) {
                    Location diff = locreceip.subtract(locsender);
                    if (Math.abs(diff.getX()) > chDistance || Math.abs(diff.getZ()) > chDistance || Math.abs(diff.getY()) > chDistance) {
                        recipients.remove(p.getPlayer());
                        --recipientCount;
                        continue;
                    }
                    if (!mcp.getPlayer().canSee(p.getPlayer())) {
                        --recipientCount;
                        continue;
                    }
                } else {
                    recipients.remove(p.getPlayer());
                    --recipientCount;
                    continue;
                }
            }
            if (mcp.getPlayer().canSee(p.getPlayer())) continue;
            --recipientCount;
        }
        if (mcp.getPlayer().hasPermission("venturechat.color")) {
            chat = Format.FormatStringColor(chat);
        }
        if (mcp.getPlayer().hasPermission("venturechat.format")) {
            chat = Format.FormatString(chat);
        }
        if (!mcp.isQuickChat()) {
            chat = " " + chat;
        }
        mcp.setQuickChat(false);
        chat = curColor.equalsIgnoreCase("None") ? String.valueOf(Format.getLastCode(format)) + chat : String.valueOf(curColor) + chat;
        String globalJSON = Format.convertToJson(mcp, format, chat);
        String consoleChat = String.valueOf(format) + chat;
        String message = consoleChat.replaceAll("(\u00a7([a-z0-9]))", "");
        int hash = message.hashCode();
        VentureChatEvent ventureChatEvent = new VentureChatEvent(mcp, mcp.getName(), mcp.getNickname(), MineverseChat.permission.getPrimaryGroup(mcp.getPlayer()), eventChannel, recipients, recipientCount, format, chat, globalJSON, hash, bungee);
        Bukkit.getServer().getPluginManager().callEvent((Event)ventureChatEvent);
        this.handleVentureChatEvent(ventureChatEvent);
    }

    public void handleVentureChatEvent(VentureChatEvent event) {
        MineverseChatPlayer mcp = event.getMineverseChatPlayer();
        ChatChannel channel = event.getChannel();
        Set<Player> recipients = event.getRecipients();
        int recipientCount = event.getRecipientCount();
        String format = event.getFormat();
        String chat = event.getChat();
        String consoleChat = event.getConsoleChat();
        String globalJSON = event.getGlobalJSON();
        int hash = event.getHash();
        boolean bungee = event.isBungee();
        if (!bungee) {
            if (this.plugin.db != null) {
                Calendar currentDate = Calendar.getInstance();
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String date = formatter.format(currentDate.getTime());
                this.plugin.db.writeVentureChat(date, mcp.getUUID().toString(), mcp.getName(), "Local", channel.getName(), chat.replace("'", "''"), "Chat");
            }
            if (recipientCount == 1 && !this.plugin.getConfig().getString("emptychannelalert", "&6No one is listening to you.").equals("")) {
                mcp.getPlayer().sendMessage(Format.FormatStringAll(this.plugin.getConfig().getString("emptychannelalert", "&6No one is listening to you.")));
            }
            for (Player p : recipients) {
                String json = Format.formatModerationGUI(globalJSON, p, mcp.getName(), channel.getName(), hash);
                PacketContainer packet = Format.createPacketPlayOutChat(json);
                Format.sendPacketPlayOutChat(p, packet);
            }
            Bukkit.getConsoleSender().sendMessage(consoleChat);
            return;
        }
        ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteOutStream);
        try {
            out.writeUTF("Chat");
            out.writeUTF(channel.getName());
            out.writeUTF(mcp.getName());
            out.writeUTF(mcp.getUUID().toString());
            out.writeBoolean(mcp.getBungeeToggle());
            out.writeInt(hash);
            out.writeUTF(format);
            out.writeUTF(chat);
            if (this.plugin.getConfig().getString("loglevel", "info").equals("debug")) {
                System.out.println(String.valueOf(out.size()) + " size bytes without json");
            }
            out.writeUTF(globalJSON);
            if (this.plugin.getConfig().getString("loglevel", "info").equals("debug")) {
                System.out.println(String.valueOf(out.size()) + " bytes size with json");
            }
            out.writeUTF(MineverseChat.permission.getPrimaryGroup(mcp.getPlayer()));
            out.writeUTF(mcp.getNickname());
            mcp.getPlayer().sendPluginMessage((Plugin)this.plugin, "venturechat:data", byteOutStream.toByteArray());
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

