/*
 * Decompiled with CFR 0.152.
 */
package mineverse.Aust1n46.chat.listeners;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import mineverse.Aust1n46.chat.MineverseChat;
import mineverse.Aust1n46.chat.api.MineverseChatAPI;
import mineverse.Aust1n46.chat.api.MineverseChatPlayer;
import mineverse.Aust1n46.chat.channel.ChatChannel;
import mineverse.Aust1n46.chat.database.PlayerData;
import mineverse.Aust1n46.chat.utilities.Format;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class LoginListener
implements Listener {
    private MineverseChat plugin = MineverseChat.getInstance();
    private FileConfiguration playerData = PlayerData.getPlayerData();

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerKick(PlayerKickEvent plog) {
        if (!this.plugin.getConfig().getConfigurationSection("logout").getString("message", "Default").equalsIgnoreCase("Default")) {
            plog.setLeaveMessage(Format.FormatStringAll(this.plugin.getConfig().getConfigurationSection("logout").getString("message", "Default").replace("{player}", plog.getPlayer().getName())));
        }
        if (!this.plugin.getConfig().getConfigurationSection("logout").getBoolean("enabled", true)) {
            plog.setLeaveMessage("");
        }
        this.playerLeaving(plog.getPlayer());
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerQuit(PlayerQuitEvent plog) {
        if (!this.plugin.getConfig().getConfigurationSection("logout").getString("message", "Default").equalsIgnoreCase("Default")) {
            plog.setQuitMessage(Format.FormatStringAll(this.plugin.getConfig().getConfigurationSection("logout").getString("message", "Default").replace("{player}", plog.getPlayer().getName())));
        }
        if (!this.plugin.getConfig().getConfigurationSection("logout").getBoolean("enabled", true)) {
            plog.setQuitMessage("");
        }
        this.playerLeaving(plog.getPlayer());
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerJoin(PlayerJoinEvent event) throws Exception {
        MineverseChatPlayer mcp = MineverseChatAPI.getMineverseChatPlayer(event.getPlayer());
        if (mcp == null) {
            Player player = event.getPlayer();
            String name = player.getName();
            UUID uuid = player.getUniqueId();
            ChatChannel current = ChatChannel.getDefaultChannel();
            HashSet<UUID> ignores = new HashSet<UUID>();
            HashSet<String> listening = new HashSet<String>();
            listening.add(current.getName());
            HashMap<String, Integer> mutes = new HashMap<String, Integer>();
            HashSet<String> blockedCommands = new HashSet<String>();
            String jsonFormat = "Default";
            mcp = new MineverseChatPlayer(uuid, name, current, ignores, listening, mutes, blockedCommands, false, null, true, true, name, jsonFormat, false, false, false, true, true);
            MineverseChat.players.add(mcp);
        }
        mcp.setName(event.getPlayer().getName());
        if (!event.getPlayer().getDisplayName().equals(mcp.getName())) {
            mcp.setNickname(event.getPlayer().getDisplayName());
        }
        event.getPlayer().setDisplayName(Format.FormatStringAll(mcp.getNickname()));
        mcp.setOnline(true);
        mcp.setHasPlayed(false);
        MineverseChat.onlinePlayers.add(mcp);
        mcp.setJsonFormat();
        if (this.plugin.getConfig().getBoolean("nickname-in-tablist", false)) {
            String nick = mcp.getNickname();
            if (nick.length() >= 16) {
                nick = nick.substring(0, 16);
            }
            mcp.getPlayer().setPlayerListName(Format.FormatStringAll(nick));
        }
        for (ChatChannel ch : ChatChannel.getAutojoinList()) {
            if (ch.hasPermission().booleanValue()) {
                if (!mcp.getPlayer().hasPermission(ch.getPermission())) continue;
                mcp.addListening(ch.getName());
                continue;
            }
            mcp.addListening(ch.getName());
        }
        final MineverseChatPlayer sync = mcp;
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                LoginListener.this.plugin.synchronize(sync, false);
            }
        }, 10L);
        if (!this.plugin.getConfig().getConfigurationSection("login").getString("message", "Default").equalsIgnoreCase("Default")) {
            event.setJoinMessage(Format.FormatStringAll(this.plugin.getConfig().getConfigurationSection("login").getString("message", "Default").replace("{player}", event.getPlayer().getName())));
        }
        if (!this.plugin.getConfig().getConfigurationSection("login").getBoolean("enabled", true)) {
            event.setJoinMessage("");
        }
    }

    private void playerLeaving(Player player) {
        MineverseChatPlayer mcp = MineverseChatAPI.getMineverseChatPlayer(player);
        ConfigurationSection cs = this.playerData.getConfigurationSection("players." + mcp.getUUID().toString());
        if (mcp.getPlayer() == null) {
            return;
        }
        if (cs == null) {
            ConfigurationSection ps = this.playerData.getConfigurationSection("players");
            if (ps == null) {
                cs = this.playerData.createSection("players");
            }
            cs = this.playerData.createSection("players." + mcp.getUUID().toString());
        }
        cs.set("name", (Object)mcp.getName());
        cs.set("current", (Object)mcp.getCurrentChannel().getName());
        String ignores = "";
        for (UUID s : mcp.getIgnores()) {
            ignores = String.valueOf(ignores) + s.toString() + ",";
        }
        cs.set("ignores", (Object)ignores);
        String listening = "";
        for (String channel : mcp.getListening()) {
            ChatChannel c = ChatChannel.getChannel(channel);
            listening = String.valueOf(listening) + c.getName() + ",";
        }
        String mutes = "";
        for (String channel : mcp.getMutes().keySet()) {
            ChatChannel c = ChatChannel.getChannel(channel);
            mutes = String.valueOf(mutes) + c.getName() + ":" + mcp.getMutes().get(c.getName()) + ",";
        }
        String blockedCommands = "";
        for (String s : mcp.getBlockedCommands()) {
            blockedCommands = String.valueOf(blockedCommands) + s + ",";
        }
        if (listening.length() > 0) {
            listening = listening.substring(0, listening.length() - 1);
        }
        cs.set("listen", (Object)listening);
        if (mutes.length() > 0) {
            mutes = mutes.substring(0, mutes.length() - 1);
        }
        cs.set("mutes", (Object)mutes);
        if (blockedCommands.length() > 0) {
            blockedCommands = blockedCommands.substring(0, blockedCommands.length() - 1);
        }
        cs.set("blockedcommands", (Object)blockedCommands);
        cs.set("host", (Object)mcp.isHost());
        cs.set("party", (Object)(mcp.hasParty() ? mcp.getParty().toString() : ""));
        cs.set("filter", (Object)mcp.hasFilter());
        cs.set("notifications", (Object)mcp.hasNotifications());
        cs.set("nickname", (Object)mcp.getPlayer().getDisplayName());
        mcp.setNickname(mcp.getPlayer().getDisplayName());
        Calendar currentDate = Calendar.getInstance();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MMM/dd HH:mm:ss");
        String dateNow = formatter.format(currentDate.getTime());
        cs.set("date", (Object)dateNow);
        mcp.clearMessages();
        mcp.setOnline(false);
        MineverseChat.onlinePlayers.remove(mcp);
    }
}

