/*
 * Decompiled with CFR 0.152.
 */
package mineverse.Aust1n46.chat.utilities;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import mineverse.Aust1n46.chat.MineverseChat;
import mineverse.Aust1n46.chat.api.MineverseChatPlayer;
import mineverse.Aust1n46.chat.json.JsonFormat;
import mineverse.Aust1n46.chat.versions.VersionHandler;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class Format {
    private static MineverseChat plugin = MineverseChat.getInstance();
    public static final int LEGACY_COLOR_CODE_LENGTH = 2;
    public static final int HEX_COLOR_CODE_LENGTH = 14;
    public static final String DEFAULT_COLOR_CODE = String.valueOf(ChatColor.WHITE);
    public static final String HEX_COLOR_CODE_PREFIX = "#";
    public static final String BUKKIT_COLOR_CODE_PREFIX = "\u00a7";
    public static final String BUKKIT_HEX_COLOR_CODE_PREFIX = "x";
    protected static Pattern chatColorPattern = Pattern.compile("(?i)&([0-9])");

    public static String convertToJson(MineverseChatPlayer sender, String format, String chat) {
        JsonFormat JSONformat = MineverseChat.jfInfo.getJsonFormat(sender.getJsonFormat());
        String f = format.replace("\\", "\\\\").replace("\"", "\\\"");
        String c = chat.replace("\\", "\\\\").replace("\"", "\\\"");
        String json = "[\"\",{\"text\":\"\",\"extra\":[";
        String prefix = "";
        String suffix = "";
        try {
            prefix = Format.FormatStringAll(MineverseChat.chat.getPlayerPrefix(sender.getPlayer()));
            suffix = Format.FormatStringAll(MineverseChat.chat.getPlayerSuffix(sender.getPlayer()));
            if (suffix.isEmpty() || suffix.length() == 2 && suffix.substring(1).matches("[0-9a-fA-F]")) {
                suffix = "venturechat_no_suffix_code";
            }
            if (prefix.isEmpty() || prefix.length() == 2 && prefix.substring(1).matches("[0-9a-fA-F]")) {
                prefix = "venturechat_no_prefix_code";
            }
        }
        catch (Exception e) {
            System.out.println("Exception?" + e.getLocalizedMessage());
            if (plugin.getConfig().getString("loglevel", "info").equals("debug")) {
                Bukkit.getConsoleSender().sendMessage(Format.FormatStringAll("&8[&eVentureChat&8]&e - Prefix and / or suffix don't exist, setting to nothing."));
            }
            suffix = "venturechat_no_suffix_code";
            prefix = "venturechat_no_prefix_code";
        }
        String nickname = "";
        if (sender.getPlayer() != null) {
            nickname = Format.FormatStringAll(sender.getPlayer().getDisplayName());
        }
        json = String.valueOf(json) + Format.convertPlaceholders(f, JSONformat, prefix, nickname, suffix, sender);
        json = String.valueOf(json) + "]}";
        json = String.valueOf(json) + "," + Format.convertLinks(c);
        json = String.valueOf(json) + "]";
        if (plugin.getConfig().getString("loglevel", "info").equals("debug")) {
            System.out.println(json);
            System.out.println("END OF JSON");
            System.out.println("END OF JSON");
            System.out.println("END OF JSON");
            System.out.println("END OF JSON");
            System.out.println("END OF JSON");
        }
        return json;
    }

    private static String convertPlaceholders(String s, JsonFormat format, String prefix, String nickname, String suffix, MineverseChatPlayer icp) {
        Pattern pattern;
        Matcher matcher;
        String remaining = s;
        String temp = "";
        int indexStart = -1;
        int indexEnd = -1;
        String placeholder = "";
        String lastCode = "\u00a7f";
        while ((matcher = (pattern = Pattern.compile("(" + Format.escapeAllRegex(prefix) + "|" + Format.escapeAllRegex(nickname) + "|" + Format.escapeAllRegex(suffix) + ")")).matcher(remaining)).find()) {
            indexStart = matcher.start();
            indexEnd = matcher.end();
            placeholder = remaining.substring(indexStart, indexEnd);
            temp = String.valueOf(temp) + Format.convertToJsonColors(String.valueOf(lastCode) + remaining.substring(0, indexStart)) + ",";
            lastCode = Format.getLastCode(String.valueOf(lastCode) + remaining.substring(0, indexStart));
            String action = "";
            String text = "";
            String hover = "";
            if (placeholder.contains(prefix)) {
                action = format.getClickPrefix();
                text = Format.FormatStringAll(PlaceholderAPI.setBracketPlaceholders((Player)icp.getPlayer(), (String)format.getClickPrefixText()));
                for (String st : format.getHoverTextPrefix()) {
                    hover = String.valueOf(hover) + Format.FormatStringAll(st) + "\n";
                }
            }
            if (placeholder.contains(nickname)) {
                action = format.getClickName();
                text = Format.FormatStringAll(PlaceholderAPI.setBracketPlaceholders((Player)icp.getPlayer(), (String)format.getClickNameText()));
                for (String st : format.getHoverTextName()) {
                    hover = String.valueOf(hover) + Format.FormatStringAll(st) + "\n";
                }
            }
            if (placeholder.contains(suffix)) {
                action = format.getClickSuffix();
                text = Format.FormatStringAll(PlaceholderAPI.setBracketPlaceholders((Player)icp.getPlayer(), (String)format.getClickSuffixText()));
                for (String st : format.getHoverTextSuffix()) {
                    hover = String.valueOf(hover) + Format.FormatStringAll(st) + "\n";
                }
            }
            hover = Format.FormatStringAll(PlaceholderAPI.setBracketPlaceholders((Player)icp.getPlayer(), (String)hover.substring(0, hover.length() - 1)));
            temp = String.valueOf(temp) + Format.convertToJsonColors(String.valueOf(lastCode) + placeholder, ",\"clickEvent\":{\"action\":\"" + action + "\",\"value\":\"" + text + "\"},\"hoverEvent\":{\"action\":\"show_text\",\"value\":{\"text\":\"\",\"extra\":[" + Format.convertToJsonColors(hover) + "]}}") + ",";
            lastCode = Format.getLastCode(String.valueOf(lastCode) + placeholder);
            remaining = remaining.substring(indexEnd);
        }
        temp = String.valueOf(temp) + Format.convertToJsonColors(String.valueOf(lastCode) + remaining);
        return temp;
    }

    private static String convertLinks(String s) {
        Pattern pattern;
        Matcher matcher;
        String remaining = s;
        String temp = "";
        int indexLink = -1;
        int indexLinkEnd = -1;
        String link = "";
        String lastCode = "\u00a7f";
        while ((matcher = (pattern = Pattern.compile("([a-zA-Z0-9\u00a7\\-:/]+\\.[a-zA-Z/0-9\u00a7\\-:_#]+(\\.[a-zA-Z/0-9.\u00a7\\-:#\\?\\+=_]+)?)")).matcher(remaining)).find()) {
            indexLink = matcher.start();
            indexLinkEnd = matcher.end();
            link = remaining.substring(indexLink, indexLinkEnd);
            temp = String.valueOf(temp) + Format.convertToJsonColors(String.valueOf(lastCode) + remaining.substring(0, indexLink)) + ",";
            lastCode = Format.getLastCode(String.valueOf(lastCode) + remaining.substring(0, indexLink));
            String https = "";
            if (ChatColor.stripColor((String)link).contains("https://")) {
                https = "s";
            }
            temp = String.valueOf(temp) + Format.convertToJsonColors(String.valueOf(lastCode) + link, ",\"underlined\":\"" + Format.underlineURLs() + "\",\"clickEvent\":{\"action\":\"open_url\",\"value\":\"http" + https + "://" + ChatColor.stripColor((String)link.replace("http://", "").replace("https://", "")) + "\"},\"hoverEvent\":{\"action\":\"show_text\",\"value\":{\"text\":\"\",\"extra\":[" + Format.convertToJsonColors(String.valueOf(lastCode) + link) + "]}}") + ",";
            lastCode = Format.getLastCode(String.valueOf(lastCode) + link);
            remaining = remaining.substring(indexLinkEnd);
        }
        temp = String.valueOf(temp) + Format.convertToJsonColors(String.valueOf(lastCode) + remaining);
        return temp;
    }

    public static String getLastCode(String s) {
        String ts = "";
        char[] ch = s.toCharArray();
        int a = 0;
        while (a < s.length() - 1) {
            if (String.valueOf(ch[a + 1]).matches("[lkomnLKOMN]") && ch[a] == '\u00a7') {
                ts = String.valueOf(ts) + String.valueOf(ch[a]) + ch[a + 1];
                ++a;
            } else if (String.valueOf(ch[a + 1]).matches("[0123456789abcdefrABCDEFR]") && ch[a] == '\u00a7') {
                ts = String.valueOf(String.valueOf(ch[a])) + ch[a + 1];
                ++a;
            } else if (ch[a + 1] == 'x' && ch[a] == '\u00a7' && ch.length > a + 13 && String.valueOf(ch[a + 3]).matches("[0123456789abcdefABCDEF]") && String.valueOf(ch[a + 5]).matches("[0123456789abcdefABCDEF]") && String.valueOf(ch[a + 7]).matches("[0123456789abcdefABCDEF]") && String.valueOf(ch[a + 9]).matches("[0123456789abcdefABCDEF]") && String.valueOf(ch[a + 11]).matches("[0123456789abcdefABCDEF]") && String.valueOf(ch[a + 13]).matches("[0123456789abcdefABCDEF]") && ch[a + 2] == '\u00a7' && ch[a + 4] == '\u00a7' && ch[a + 6] == '\u00a7' && ch[a + 8] == '\u00a7' && ch[a + 10] == '\u00a7' && ch[a + 12] == '\u00a7') {
                ts = String.valueOf(String.valueOf(ch[a])) + ch[a + 1] + ch[a + 2] + ch[a + 3] + ch[a + 4] + ch[a + 5] + ch[a + 6] + ch[a + 7] + ch[a + 8] + ch[a + 9] + ch[a + 10] + ch[a + 11] + ch[a + 12] + ch[a + 13];
                a += 13;
            }
            ++a;
        }
        return ts;
    }

    private static String convertToJsonColors(String s) {
        return Format.convertToJsonColors(s, "");
    }

    private static String convertToJsonColors(String s, String extensions) {
        String remaining = s;
        String temp = "";
        int indexColor = -1;
        int indexNextColor = -1;
        String color = "";
        String modifier = "";
        boolean bold = false;
        boolean obfuscated = false;
        boolean italic = false;
        boolean strikethrough = false;
        boolean underlined = false;
        String previousColor = "";
        int colorLength = 2;
        do {
            block47: {
                block48: {
                    block46: {
                        if (remaining.length() < 2) {
                            temp = "{\"text\":\"" + remaining + "\"},";
                            break;
                        }
                        modifier = "";
                        indexColor = remaining.indexOf(BUKKIT_COLOR_CODE_PREFIX);
                        previousColor = color;
                        color = remaining.substring(1, indexColor + 2);
                        if (!color.equals(BUKKIT_HEX_COLOR_CODE_PREFIX)) break block46;
                        if (remaining.length() >= 14) {
                            color = HEX_COLOR_CODE_PREFIX + remaining.substring(2, indexColor + 14).replace(BUKKIT_COLOR_CODE_PREFIX, "");
                            colorLength = 14;
                            bold = false;
                            obfuscated = false;
                            italic = false;
                            strikethrough = false;
                            underlined = false;
                        }
                        break block47;
                    }
                    if (color.matches("[0123456789abcdefABCDEF]")) break block48;
                    switch (color) {
                        case "L": 
                        case "l": {
                            bold = true;
                            break;
                        }
                        case "K": 
                        case "k": {
                            obfuscated = true;
                            break;
                        }
                        case "O": 
                        case "o": {
                            italic = true;
                            break;
                        }
                        case "M": 
                        case "m": {
                            strikethrough = true;
                            break;
                        }
                        case "N": 
                        case "n": {
                            underlined = true;
                            break;
                        }
                        case "R": 
                        case "r": {
                            bold = false;
                            obfuscated = false;
                            italic = false;
                            strikethrough = false;
                            underlined = false;
                            color = "f";
                        }
                    }
                    if (!color.equals("f")) {
                        color = previousColor;
                    }
                    if (color.length() == 0) {
                        color = "f";
                    }
                    break block47;
                }
                bold = false;
                obfuscated = false;
                italic = false;
                strikethrough = false;
                underlined = false;
            }
            if (bold) {
                modifier = String.valueOf(modifier) + ",\"bold\":\"true\"";
            }
            if (obfuscated) {
                modifier = String.valueOf(modifier) + ",\"obfuscated\":\"true\"";
            }
            if (italic) {
                modifier = String.valueOf(modifier) + ",\"italic\":\"true\"";
            }
            if (underlined) {
                modifier = String.valueOf(modifier) + ",\"underlined\":\"true\"";
            }
            if (strikethrough) {
                modifier = String.valueOf(modifier) + ",\"strikethrough\":\"true\"";
            }
            remaining = remaining.substring(colorLength);
            colorLength = 2;
            indexNextColor = remaining.indexOf(BUKKIT_COLOR_CODE_PREFIX);
            if (indexNextColor == -1) {
                indexNextColor = remaining.length();
            }
            temp = String.valueOf(temp) + "{\"text\":\"" + remaining.substring(0, indexNextColor) + "\",\"color\":\"" + Format.hexidecimalToJsonColorRGB(color) + "\"" + modifier + extensions + "},";
        } while ((remaining = remaining.substring(indexNextColor)).length() > 1 && indexColor != -1);
        if (temp.length() > 1) {
            temp = temp.substring(0, temp.length() - 1);
        }
        return temp;
    }

    private static String hexidecimalToJsonColorRGB(String c) {
        block65: {
            if (c.length() != 1) break block65;
            switch (c) {
                case "0": {
                    return "black";
                }
                case "1": {
                    return "dark_blue";
                }
                case "2": {
                    return "dark_green";
                }
                case "3": {
                    return "dark_aqua";
                }
                case "4": {
                    return "dark_red";
                }
                case "5": {
                    return "dark_purple";
                }
                case "6": {
                    return "gold";
                }
                case "7": {
                    return "gray";
                }
                case "8": {
                    return "dark_gray";
                }
                case "9": {
                    return "blue";
                }
                case "A": 
                case "a": {
                    return "green";
                }
                case "B": 
                case "b": {
                    return "aqua";
                }
                case "C": 
                case "c": {
                    return "red";
                }
                case "D": 
                case "d": {
                    return "light_purple";
                }
                case "E": 
                case "e": {
                    return "yellow";
                }
                case "F": 
                case "f": {
                    return "white";
                }
            }
            return "white";
        }
        if (Format.isValidHexColor(c)) {
            return c;
        }
        return "white";
    }

    public static String convertPlainTextToJson(String s, boolean convertURL) {
        if (convertURL) {
            return "[" + Format.convertLinks(s) + "]";
        }
        return "[" + Format.convertToJsonColors("\u00a7f" + s) + "]";
    }

    public static String formatModerationGUI(String json, Player player, String sender, String channelName, int hash) {
        if (player.hasPermission("venturechat.gui")) {
            json = json.substring(0, json.length() - 1);
            json = String.valueOf(json) + "," + Format.convertToJsonColors(Format.FormatStringAll(plugin.getConfig().getString("guiicon")), ",\"clickEvent\":{\"action\":\"run_command\",\"value\":\"/vchatgui " + sender + " " + channelName + " " + hash + "\"},\"hoverEvent\":{\"action\":\"show_text\",\"value\":{\"text\":\"\",\"extra\":[" + Format.convertToJsonColors(Format.FormatStringAll(plugin.getConfig().getString("guitext"))) + "]}}") + "]";
        }
        return json;
    }

    public static PacketContainer createPacketPlayOutChat(String json) {
        WrappedChatComponent component = WrappedChatComponent.fromJson((String)json);
        PacketContainer container = new PacketContainer(PacketType.Play.Server.CHAT);
        container.getModifier().writeDefaults();
        container.getChatComponents().write(0, (Object)component);
        return container;
    }

    public static PacketContainer createPacketPlayOutChat(WrappedChatComponent component) {
        PacketContainer container = new PacketContainer(PacketType.Play.Server.CHAT);
        container.getModifier().writeDefaults();
        container.getChatComponents().write(0, (Object)component);
        return container;
    }

    public static void sendPacketPlayOutChat(Player player, PacketContainer packet) {
        try {
            ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String toPlainText(Object o, Class<?> c) {
        ArrayList<Object> finalList = new ArrayList<Object>();
        StringBuilder stringbuilder = new StringBuilder();
        try {
            Format.splitComponents(finalList, o, c);
            for (Object e : finalList) {
                if (VersionHandler.is1_7_10()) {
                    stringbuilder.append((String)e.getClass().getMethod("e", new Class[0]).invoke(e, new Object[0]));
                    continue;
                }
                stringbuilder.append((String)e.getClass().getMethod("getText", new Class[0]).invoke(e, new Object[0]));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringbuilder.toString();
    }

    private static void splitComponents(List<Object> finalList, Object o, Class<?> c) throws Exception {
        if (VersionHandler.is1_7() || VersionHandler.is1_8() || VersionHandler.is1_9() || VersionHandler.is1_10() || VersionHandler.is1_11() || VersionHandler.is1_12() || VersionHandler.is1_13() || VersionHandler.is1_14() && !VersionHandler.is1_14_4()) {
            ArrayList list = (ArrayList)c.getMethod("a", new Class[0]).invoke(o, new Object[0]);
            for (Object component : list) {
                ArrayList innerList = (ArrayList)c.getMethod("a", new Class[0]).invoke(component, new Object[0]);
                if (innerList.size() > 0) {
                    Format.splitComponents(finalList, component, c);
                    continue;
                }
                finalList.add(component);
            }
        } else {
            ArrayList list = (ArrayList)c.getMethod("getSiblings", new Class[0]).invoke(o, new Object[0]);
            for (Object component : list) {
                ArrayList innerList = (ArrayList)c.getMethod("getSiblings", new Class[0]).invoke(component, new Object[0]);
                if (innerList.size() > 0) {
                    Format.splitComponents(finalList, component, c);
                    continue;
                }
                finalList.add(component);
            }
        }
    }

    public static String FormatStringColor(String string) {
        String allFormated = string;
        allFormated = chatColorPattern.matcher(allFormated).replaceAll("\u00a7$1");
        allFormated = allFormated.replaceAll("&[x]", "\u00a7x");
        allFormated = allFormated.replaceAll("&[aA]", "\u00a7a");
        allFormated = allFormated.replaceAll("&[bB]", "\u00a7b");
        allFormated = allFormated.replaceAll("&[cC]", "\u00a7c");
        allFormated = allFormated.replaceAll("&[dD]", "\u00a7d");
        allFormated = allFormated.replaceAll("&[eE]", "\u00a7e");
        allFormated = allFormated.replaceAll("&[fF]", "\u00a7f");
        allFormated = allFormated.replaceAll("%", "\\%");
        allFormated = Format.convertHexColorCodeStringToBukkitColorCodeString(allFormated);
        return allFormated;
    }

    public static String FormatString(String string) {
        String allFormated = string;
        allFormated = allFormated.replaceAll("&[kK]", "\u00a7k");
        allFormated = allFormated.replaceAll("&[lL]", "\u00a7l");
        allFormated = allFormated.replaceAll("&[mM]", "\u00a7m");
        allFormated = allFormated.replaceAll("&[nN]", "\u00a7n");
        allFormated = allFormated.replaceAll("&[oO]", "\u00a7o");
        allFormated = allFormated.replaceAll("&[rR]", "\u00a7r");
        allFormated = allFormated.replaceAll("%", "\\%");
        return allFormated;
    }

    public static String FormatStringAll(String string) {
        String allFormated = Format.FormatString(string);
        allFormated = Format.FormatStringColor(allFormated);
        return allFormated;
    }

    public static String FilterChat(String msg) {
        int t = 0;
        List filters = plugin.getConfig().getStringList("filters");
        for (String s : filters) {
            t = 0;
            String[] pparse = new String[]{" ", " "};
            StringTokenizer st = new StringTokenizer(s, ",");
            while (st.hasMoreTokens()) {
                if (t >= 2) continue;
                pparse[t++] = st.nextToken();
            }
            msg = msg.replaceAll("(?i)" + pparse[0], pparse[1]);
        }
        return msg;
    }

    public static boolean isValidColor(String color) {
        Boolean bFound = false;
        ChatColor[] chatColorArray = ChatColor.values();
        int n = chatColorArray.length;
        int n2 = 0;
        while (n2 < n) {
            ChatColor bkColors = chatColorArray[n2];
            if (color.equalsIgnoreCase(bkColors.name())) {
                bFound = true;
            }
            ++n2;
        }
        return bFound;
    }

    public static boolean isValidHexColor(String color) {
        Pattern pattern = Pattern.compile("(^#[0-9a-fA-F]{6}\\b)");
        Matcher matcher = pattern.matcher(color);
        return matcher.find();
    }

    public static String convertHexColorCodeToBukkitColorCode(String color) {
        StringBuilder bukkitColorCode = new StringBuilder("\u00a7x");
        int a = 1;
        while (a < color.length()) {
            bukkitColorCode.append(BUKKIT_COLOR_CODE_PREFIX + color.charAt(a));
            ++a;
        }
        return bukkitColorCode.toString().toLowerCase();
    }

    public static String convertHexColorCodeStringToBukkitColorCodeString(String string) {
        Pattern pattern = Pattern.compile("(#[0-9a-fA-F]{6})");
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            int indexStart = matcher.start();
            int indexEnd = matcher.end();
            String hexColor = string.substring(indexStart, indexEnd);
            String bukkitColor = Format.convertHexColorCodeToBukkitColorCode(hexColor);
            string = string.replaceAll(hexColor, bukkitColor);
            matcher.reset(string);
        }
        return string;
    }

    public static String escapeAllRegex(String input) {
        return input.replace("[", "\\[").replace("]", "\\]").replace("{", "\\{").replace("}", "\\}").replace("(", "\\(").replace(")", "\\)").replace("|", "\\|").replace("+", "\\+").replace("*", "\\*");
    }

    public static boolean underlineURLs() {
        return plugin.getConfig().getBoolean("underlineurls", true);
    }

    public static int currentTimeMillis() {
        return (int)(System.currentTimeMillis() % Integer.MAX_VALUE);
    }
}

