/*
 * Decompiled with CFR 0.152.
 */
package mineverse.Aust1n46.chat.utilities;

import java.util.ArrayList;
import java.util.List;
import mineverse.Aust1n46.chat.MineverseChat;
import mineverse.Aust1n46.chat.utilities.Format;
import org.bukkit.configuration.file.FileConfiguration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={MineverseChat.class})
public class FormatTest {
    private MineverseChat mockPlugin;
    private FileConfiguration mockConfig;
    private List<String> filters;

    @Before
    public void setUp() {
        this.filters = new ArrayList<String>();
        this.filters.add("ass,donut");
        this.mockPlugin = (MineverseChat)((Object)Mockito.mock(MineverseChat.class));
        this.mockConfig = (FileConfiguration)Mockito.mock(FileConfiguration.class);
        PowerMockito.mockStatic(MineverseChat.class, (Class[])new Class[0]);
        PowerMockito.when((Object)((Object)MineverseChat.getInstance())).thenReturn((Object)this.mockPlugin);
        Mockito.when((Object)this.mockPlugin.getConfig()).thenReturn((Object)this.mockConfig);
        Mockito.when((Object)this.mockConfig.getStringList("filters")).thenReturn(this.filters);
    }

    @After
    public void tearDown() {
        this.mockPlugin = null;
        this.mockConfig = null;
        this.filters = new ArrayList<String>();
    }

    @Test
    public void testGetLastCodeSingleColor() {
        String input = "\u00a7cHello";
        String expectedResult = "\u00a7c";
        String result = Format.getLastCode(input);
        Assert.assertEquals((Object)expectedResult, (Object)result);
    }

    @Test
    public void testGetLastCodeColorAfterFormat() {
        String input = "\u00a7o\u00a7cHello";
        String expectedResult = "\u00a7c";
        String result = Format.getLastCode(input);
        Assert.assertEquals((Object)expectedResult, (Object)result);
    }

    @Test
    public void testGetLastCodeColorBeforeFormat() {
        String input = "\u00a7c\u00a7oHello";
        String expectedResult = "\u00a7c\u00a7o";
        String result = Format.getLastCode(input);
        Assert.assertEquals((Object)expectedResult, (Object)result);
    }

    @Test
    public void testFilterChat() {
        String test = "I am an ass";
        String expectedResult = "I am an donut";
        String result = Format.FilterChat(test);
        Assert.assertEquals((Object)expectedResult, (Object)result);
    }

    @Test
    public void testIsValidColor() {
        String color = "red";
        boolean result = Format.isValidColor(color);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testIsInvalidColor() {
        String color = "randomString";
        boolean result = Format.isValidColor(color);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testIsValidHexColor() {
        String hexColor = "#ff00ff";
        boolean result = Format.isValidHexColor(hexColor);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testIsInvalidHexColor() {
        String hexColor = "#random";
        boolean result = Format.isValidHexColor(hexColor);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testConvertHexColorCodeToBukkitColorCode() {
        String hexColor = "#ff00ff";
        String expectedResult = "\u00a7x\u00a7f\u00a7f\u00a70\u00a70\u00a7f\u00a7f";
        String result = Format.convertHexColorCodeToBukkitColorCode(hexColor);
        Assert.assertEquals((Object)expectedResult, (Object)result);
    }

    @Test
    public void testConvertHexColorCodeStringToBukkitColorCodeString() {
        String input = "#ff00ffHello\u00a7cThere#00ff00Austin";
        String expectedResult = "\u00a7x\u00a7f\u00a7f\u00a70\u00a70\u00a7f\u00a7fHello\u00a7cThere\u00a7x\u00a70\u00a70\u00a7f\u00a7f\u00a70\u00a70Austin";
        String result = Format.convertHexColorCodeStringToBukkitColorCodeString(input);
        Assert.assertEquals((Object)expectedResult, (Object)result);
    }
}

