/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.OfflinePlayer;
import com.earth2me.essentials.User;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.ess3.api.IEssentials;
import net.essentialsx.api.v2.services.BalanceTop;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;

public class BalanceTopImpl
implements BalanceTop {
    private final IEssentials ess;
    private LinkedHashMap<UUID, BalanceTop.Entry> topCache = new LinkedHashMap();
    private BigDecimal balanceTopTotal = BigDecimal.ZERO;
    private long cacheAge = 0L;
    private CompletableFuture<Void> cacheLock;

    public BalanceTopImpl(IEssentials ess) {
        this.ess = ess;
        ess.getServer().getServicesManager().register(BalanceTop.class, (Object)this, (Plugin)ess, ServicePriority.Normal);
    }

    private void calculateBalanceTopMap() {
        LinkedList<BalanceTop.Entry> entries = new LinkedList<BalanceTop.Entry>();
        BigDecimal newTotal = BigDecimal.ZERO;
        for (UUID u : this.ess.getUserMap().getAllUniqueUsers()) {
            User user = this.ess.getUserMap().getUser(u);
            if (user == null || !this.ess.getSettings().isNpcsInBalanceRanking() && user.isNPC() || user.isBaltopExempt()) continue;
            BigDecimal userMoney = user.getMoney();
            user.updateMoneyCache(userMoney);
            newTotal = newTotal.add(userMoney);
            String name = user.getBase() instanceof OfflinePlayer ? user.getLastAccountName() : (user.isHidden() ? user.getName() : user.getDisplayName());
            entries.add(new BalanceTop.Entry(user.getUUID(), name, userMoney));
        }
        LinkedHashMap<UUID, BalanceTop.Entry> sortedMap = new LinkedHashMap<UUID, BalanceTop.Entry>();
        entries.sort((entry1, entry2) -> entry2.getBalance().compareTo(entry1.getBalance()));
        for (BalanceTop.Entry entry : entries) {
            sortedMap.put(entry.getUuid(), entry);
        }
        this.topCache = sortedMap;
        this.balanceTopTotal = newTotal;
        this.cacheAge = System.currentTimeMillis();
        this.cacheLock.complete(null);
        this.cacheLock = null;
    }

    @Override
    public CompletableFuture<Void> calculateBalanceTopMapAsync() {
        if (this.cacheLock != null) {
            return this.cacheLock;
        }
        this.cacheLock = new CompletableFuture();
        this.ess.runTaskAsynchronously(this::calculateBalanceTopMap);
        return this.cacheLock;
    }

    @Override
    public Map<UUID, BalanceTop.Entry> getBalanceTopCache() {
        return Collections.unmodifiableMap(this.topCache);
    }

    @Override
    public long getCacheAge() {
        return this.cacheAge;
    }

    @Override
    public BigDecimal getBalanceTopTotal() {
        return this.balanceTopTotal;
    }

    @Override
    public boolean isCacheLocked() {
        return this.cacheLock != null;
    }
}

