/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.MetaItemStack;
import com.earth2me.essentials.Trade;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.NoChargeException;
import com.earth2me.essentials.craftbukkit.InventoryWorkaround;
import com.earth2me.essentials.libs.snakeyaml.external.biz.base64Coder.Base64Coder;
import com.earth2me.essentials.textreader.KeywordReplacer;
import com.earth2me.essentials.textreader.SimpleTextInput;
import com.earth2me.essentials.utils.DateUtil;
import com.earth2me.essentials.utils.MaterialUtil;
import com.earth2me.essentials.utils.NumberUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import net.ess3.api.IEssentials;
import net.ess3.api.events.KitClaimEvent;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class Kit {
    final IEssentials ess;
    final String kitName;
    final Map<String, Object> kit;
    final Trade charge;

    public Kit(String kitName, IEssentials ess) throws Exception {
        this.kitName = kitName;
        this.ess = ess;
        this.kit = ess.getKits().getKit(kitName);
        this.charge = new Trade("kit-" + kitName, new Trade("kit-kit", ess), ess);
        if (this.kit == null) {
            throw new Exception(I18n.tl("kitNotFound", new Object[0]));
        }
    }

    public String getName() {
        return this.kitName;
    }

    public void checkPerms(User user) throws Exception {
        if (!user.isAuthorized("essentials.kits." + this.kitName)) {
            throw new Exception(I18n.tl("noKitPermission", "essentials.kits." + this.kitName));
        }
    }

    public void checkDelay(User user) throws Exception {
        long nextUse = this.getNextUse(user);
        if (nextUse != 0L) {
            if (nextUse < 0L) {
                user.sendMessage(I18n.tl("kitOnce", new Object[0]));
                throw new NoChargeException();
            }
            user.sendMessage(I18n.tl("kitTimed", DateUtil.formatDateDiff(nextUse)));
            throw new NoChargeException();
        }
    }

    public void checkAffordable(User user) throws Exception {
        this.charge.isAffordableFor(user);
    }

    public void setTime(User user) throws Exception {
        GregorianCalendar time = new GregorianCalendar();
        user.setKitTimestamp(this.kitName, time.getTimeInMillis());
    }

    public void resetTime(User user) {
        user.setKitTimestamp(this.kitName, 0L);
    }

    public void chargeUser(User user) throws Exception {
        this.charge.charge(user);
    }

    public long getNextUse(User user) throws Exception {
        if (user.isAuthorized("essentials.kit.exemptdelay")) {
            return 0L;
        }
        GregorianCalendar time = new GregorianCalendar();
        double delay = 0.0;
        try {
            delay = this.kit.containsKey("delay") ? ((Number)this.kit.get("delay")).doubleValue() : 0.0;
        }
        catch (Exception e) {
            throw new Exception(I18n.tl("kitError2", new Object[0]));
        }
        long lastTime = user.getKitTimestamp(this.kitName);
        GregorianCalendar delayTime = new GregorianCalendar();
        delayTime.setTimeInMillis(lastTime);
        ((Calendar)delayTime).add(13, (int)delay);
        ((Calendar)delayTime).add(14, (int)(delay * 1000.0 % 1000.0));
        if (lastTime == 0L || lastTime > time.getTimeInMillis()) {
            return 0L;
        }
        if (delay < 0.0) {
            return -1L;
        }
        if (delayTime.before(time)) {
            return 0L;
        }
        return delayTime.getTimeInMillis();
    }

    @Deprecated
    public List<String> getItems(User user) throws Exception {
        return this.getItems();
    }

    public List<String> getItems() throws Exception {
        if (this.kit == null) {
            throw new Exception(I18n.tl("kitNotFound", new Object[0]));
        }
        try {
            ArrayList<String> itemList = new ArrayList<String>();
            Object kitItems = this.kit.get("items");
            if (kitItems instanceof List) {
                for (Object item : (List)kitItems) {
                    if (item instanceof String) {
                        itemList.add(item.toString());
                        continue;
                    }
                    throw new Exception("Invalid kit item: " + item.toString());
                }
                return itemList;
            }
            throw new Exception("Invalid item list");
        }
        catch (Exception e) {
            this.ess.getLogger().log(Level.WARNING, "Error parsing kit " + this.kitName + ": " + e.getMessage());
            throw new Exception(I18n.tl("kitError2", new Object[0]), e);
        }
    }

    public boolean expandItems(User user) throws Exception {
        return this.expandItems(user, this.getItems(user));
    }

    public boolean expandItems(User user, List<String> items) throws Exception {
        try {
            Map<Integer, ItemStack> overfilled;
            SimpleTextInput input = new SimpleTextInput(items);
            KeywordReplacer output = new KeywordReplacer(input, user.getSource(), this.ess, true, true);
            KitClaimEvent event = new KitClaimEvent(user, this);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return false;
            }
            boolean spew = false;
            boolean allowUnsafe = this.ess.getSettings().allowUnsafeEnchantments();
            boolean autoEquip = this.ess.getSettings().isKitAutoEquip();
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
            ArrayList<String> commandQueue = new ArrayList<String>();
            ArrayList<String> moneyQueue = new ArrayList<String>();
            String currencySymbol = this.ess.getSettings().getCurrencySymbol().isEmpty() ? "$" : this.ess.getSettings().getCurrencySymbol();
            for (String kitItem : output.getLines()) {
                if (kitItem.startsWith("$") || kitItem.startsWith(currencySymbol)) {
                    moneyQueue.add(NumberUtil.sanitizeCurrencyString(kitItem, this.ess));
                    continue;
                }
                if (kitItem.startsWith("/")) {
                    String command = kitItem.substring(1);
                    String name = user.getName();
                    command = command.replace("{player}", name);
                    commandQueue.add(command);
                    continue;
                }
                if (kitItem.startsWith("@")) {
                    if (this.ess.getSerializationProvider() == null) {
                        this.ess.getLogger().log(Level.WARNING, I18n.tl("kitError3", this.kitName, user.getName()));
                        continue;
                    }
                    itemList.add(this.ess.getSerializationProvider().deserializeItem(Base64Coder.decodeLines(kitItem.substring(1))));
                    continue;
                }
                String[] parts = kitItem.split(" +");
                ItemStack parseStack = this.ess.getItemDb().get(parts[0], parts.length > 1 ? Integer.parseInt(parts[1]) : 1);
                if (parseStack.getType() == Material.AIR) continue;
                MetaItemStack metaStack = new MetaItemStack(parseStack);
                if (parts.length > 2) {
                    metaStack.parseStringMeta(null, allowUnsafe, parts, 2, this.ess);
                }
                if (autoEquip) {
                    ItemStack stack = metaStack.getItemStack();
                    Material material = stack.getType();
                    PlayerInventory inventory = user.getBase().getInventory();
                    if (MaterialUtil.isHelmet(material) && this.isEmptyStack(inventory.getHelmet())) {
                        inventory.setHelmet(stack);
                        continue;
                    }
                    if (MaterialUtil.isChestplate(material) && this.isEmptyStack(inventory.getChestplate())) {
                        inventory.setChestplate(stack);
                        continue;
                    }
                    if (MaterialUtil.isLeggings(material) && this.isEmptyStack(inventory.getLeggings())) {
                        inventory.setLeggings(stack);
                        continue;
                    }
                    if (MaterialUtil.isBoots(material) && this.isEmptyStack(inventory.getBoots())) {
                        inventory.setBoots(stack);
                        continue;
                    }
                }
                itemList.add(metaStack.getItemStack());
            }
            boolean allowOversizedStacks = user.isAuthorized("essentials.oversizedstacks");
            boolean isDropItemsIfFull = this.ess.getSettings().isDropItemsIfFull();
            if (isDropItemsIfFull) {
                overfilled = allowOversizedStacks ? InventoryWorkaround.addOversizedItems((Inventory)user.getBase().getInventory(), this.ess.getSettings().getOversizedStackSize(), itemList.toArray(new ItemStack[0])) : InventoryWorkaround.addItems((Inventory)user.getBase().getInventory(), itemList.toArray(new ItemStack[0]));
                for (ItemStack itemStack : overfilled.values()) {
                    int spillAmount = itemStack.getAmount();
                    if (!allowOversizedStacks) {
                        itemStack.setAmount(Math.min(spillAmount, itemStack.getMaxStackSize()));
                    }
                    while (spillAmount > 0) {
                        user.getWorld().dropItemNaturally(user.getLocation(), itemStack);
                        spillAmount -= itemStack.getAmount();
                    }
                    spew = true;
                }
            } else {
                overfilled = allowOversizedStacks ? InventoryWorkaround.addAllOversizedItems((Inventory)user.getBase().getInventory(), this.ess.getSettings().getOversizedStackSize(), itemList.toArray(new ItemStack[0])) : InventoryWorkaround.addAllItems((Inventory)user.getBase().getInventory(), itemList.toArray(new ItemStack[0]));
                if (overfilled != null) {
                    user.sendMessage(I18n.tl("kitInvFullNoDrop", new Object[0]));
                    return false;
                }
            }
            user.getBase().updateInventory();
            for (String valueString : moneyQueue) {
                BigDecimal value = new BigDecimal(valueString.trim());
                Trade t = new Trade(value, this.ess);
                t.pay(user, Trade.OverflowType.DROP);
            }
            for (String cmd : commandQueue) {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)cmd);
            }
            if (spew) {
                user.sendMessage(I18n.tl("kitInvFull", new Object[0]));
            }
        }
        catch (Exception e) {
            user.getBase().updateInventory();
            this.ess.getLogger().log(Level.WARNING, e.getMessage());
            throw new Exception(I18n.tl("kitError2", new Object[0]), e);
        }
        return true;
    }

    private boolean isEmptyStack(ItemStack stack) {
        return stack == null || MaterialUtil.isAir(stack.getType());
    }
}

