/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.libs.configurate.ConfigurationNode;
import com.earth2me.essentials.libs.configurate.yaml.NodeStyle;
import com.earth2me.essentials.libs.configurate.yaml.YamlConfigurationLoader;
import com.earth2me.essentials.libs.snakeyaml.external.biz.base64Coder.Base64Coder;
import com.earth2me.essentials.utils.DateUtil;
import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.inventory.ItemStack;

public class Commandcreatekit
extends EssentialsCommand {
    private static final String PASTE_URL = "https://paste.gg/";
    private static final String PASTE_UPLOAD_URL = "https://api.paste.gg/v1/pastes";
    private static final Gson GSON = new Gson();
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();

    public Commandcreatekit() {
        super("createkit");
    }

    @Override
    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        if (args.length != 2) {
            throw new NotEnoughArgumentsException();
        }
        long delay = Long.parseLong(args[1]);
        String kitname = args[0];
        ItemStack[] items = user.getBase().getInventory().getContents();
        ArrayList<String> list = new ArrayList<String>();
        boolean useSerializationProvider = this.ess.getSettings().isUseBetterKits();
        if (useSerializationProvider && this.ess.getSerializationProvider() == null) {
            this.ess.showError(user.getSource(), new Exception(I18n.tl("createKitUnsupported", new Object[0])), commandLabel);
            useSerializationProvider = false;
        }
        for (ItemStack is : items) {
            if (is == null || is.getType() == null || is.getType() == Material.AIR) continue;
            String serialized = useSerializationProvider ? "@" + Base64Coder.encodeLines(this.ess.getSerializationProvider().serializeItem(is)) : this.ess.getItemDb().serialize(is);
            list.add(serialized);
        }
        if (!this.ess.getSettings().isPastebinCreateKit()) {
            this.ess.getKits().addKit(kitname, list, delay);
            user.sendMessage(I18n.tl("createdKit", kitname, list.size(), delay));
        } else {
            this.uploadPaste(user.getSource(), kitname, delay, list);
        }
    }

    private void uploadPaste(CommandSource sender, String kitName, long delay, List<String> list) {
        this.executorService.submit(() -> {
            try {
                StringWriter sw = new StringWriter();
                YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().sink(() -> new BufferedWriter(sw))).indent(2).nodeStyle(NodeStyle.BLOCK).build();
                Object config = loader.createNode();
                config.node("kits", kitName, "delay").set(delay);
                config.node("kits", kitName, "items").set(list);
                sw.append("# Copy the kit code below into the kits section in your config.yml file\n");
                loader.save((ConfigurationNode)config);
                String fileContents = sw.toString();
                HttpURLConnection connection = (HttpURLConnection)new URL(PASTE_UPLOAD_URL).openConnection();
                connection.setRequestMethod("POST");
                connection.setDoInput(true);
                connection.setDoOutput(true);
                connection.setRequestProperty("User-Agent", "EssentialsX plugin");
                connection.setRequestProperty("Content-Type", "application/json");
                JsonObject body = new JsonObject();
                JsonArray files = new JsonArray();
                JsonObject file = new JsonObject();
                JsonObject content = new JsonObject();
                content.addProperty("format", "text");
                content.addProperty("value", fileContents);
                file.add("content", (JsonElement)content);
                files.add((JsonElement)file);
                body.add("files", (JsonElement)files);
                try (OutputStream os = connection.getOutputStream();){
                    os.write(body.toString().getBytes(Charsets.UTF_8));
                }
                if (connection.getResponseCode() >= 400) {
                    sender.sendMessage(I18n.tl("createKitFailed", kitName));
                    String message = CharStreams.toString((Readable)new InputStreamReader(connection.getErrorStream(), Charsets.UTF_8));
                    this.ess.getLogger().severe("Error creating kit: " + message);
                    return;
                }
                JsonObject object = (JsonObject)GSON.fromJson((Reader)new InputStreamReader(connection.getInputStream(), Charsets.UTF_8), JsonObject.class);
                String pasteUrl = PASTE_URL + object.get("result").getAsJsonObject().get("id").getAsString();
                connection.disconnect();
                String separator = I18n.tl("createKitSeparator", new Object[0]);
                String delayFormat = "0";
                if (delay > 0L) {
                    delayFormat = DateUtil.formatDateDiff(System.currentTimeMillis() + delay * 1000L);
                }
                sender.sendMessage(separator);
                sender.sendMessage(I18n.tl("createKitSuccess", kitName, delayFormat, pasteUrl));
                sender.sendMessage(separator);
                if (this.ess.getSettings().isDebug()) {
                    this.ess.getLogger().info(sender.getSender().getName() + " created a kit: " + pasteUrl);
                }
            }
            catch (Exception e) {
                sender.sendMessage(I18n.tl("createKitFailed", kitName));
                e.printStackTrace();
            }
        });
    }
}

