/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.utils.DateUtil;
import com.earth2me.essentials.utils.FormatUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class Commandme
extends EssentialsCommand {
    public Commandme() {
        super("me");
    }

    @Override
    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        if (user.isMuted()) {
            String dateDiff;
            String string = dateDiff = user.getMuteTimeout() > 0L ? DateUtil.formatDateDiff(user.getMuteTimeout()) : null;
            if (dateDiff == null) {
                throw new Exception(user.hasMuteReason() ? I18n.tl("voiceSilencedReason", user.getMuteReason()) : I18n.tl("voiceSilenced", new Object[0]));
            }
            throw new Exception(user.hasMuteReason() ? I18n.tl("voiceSilencedReasonTime", dateDiff, user.getMuteReason()) : I18n.tl("voiceSilencedTime", dateDiff));
        }
        if (args.length < 1) {
            throw new NotEnoughArgumentsException();
        }
        String message = Commandme.getFinalArg(args, 0);
        message = FormatUtil.formatMessage(user, "essentials.chat", message);
        user.setDisplayNick();
        long radius = this.ess.getSettings().getChatRadius();
        String toSend = I18n.tl("action", user.getDisplayName(), message);
        if (radius < 1L) {
            this.ess.broadcastMessage(user, toSend);
            return;
        }
        radius *= radius;
        World world = user.getWorld();
        Location loc = user.getLocation();
        HashSet<Player> outList = new HashSet<Player>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            User onlineUser = this.ess.getUser(player);
            if (!onlineUser.equals(user)) {
                boolean abort = false;
                Location playerLoc = onlineUser.getLocation();
                if (playerLoc.getWorld() != world) {
                    abort = true;
                } else if (onlineUser.isIgnoredPlayer(user)) {
                    abort = true;
                } else {
                    double delta = playerLoc.distanceSquared(loc);
                    if (delta > (double)radius) {
                        abort = true;
                    }
                }
                if (abort) {
                    if (!onlineUser.isAuthorized("essentials.chat.spy")) continue;
                    outList.add(player);
                    continue;
                }
                outList.add(player);
                continue;
            }
            outList.add(player);
        }
        if (outList.size() < 2) {
            user.sendMessage(I18n.tl("localNoOne", new Object[0]));
        }
        for (Player onlinePlayer : outList) {
            onlinePlayer.sendMessage(toSend);
        }
    }

    @Override
    public void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        if (args.length < 1) {
            throw new NotEnoughArgumentsException();
        }
        String message = Commandme.getFinalArg(args, 0);
        message = FormatUtil.replaceFormat(message);
        this.ess.getServer().broadcastMessage(I18n.tl("action", "@", message));
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        return Collections.emptyList();
    }
}

