/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.IUser;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsLoopCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.commands.PlayerExemptException;
import com.earth2me.essentials.utils.VersionUtil;
import java.util.Collections;
import java.util.List;
import org.bukkit.Server;
import org.bukkit.Statistic;

public class Commandrest
extends EssentialsLoopCommand {
    public Commandrest() {
        super("rest");
    }

    @Override
    public void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        if (VersionUtil.getServerBukkitVersion().isLowerThan(VersionUtil.v1_13_0_R01)) {
            sender.sendMessage(I18n.tl("unsupportedFeature", new Object[0]));
            return;
        }
        if (args.length == 0 && !sender.isPlayer()) {
            throw new NotEnoughArgumentsException();
        }
        if (args.length > 0 && sender.isAuthorized("essentials.rest.others", this.ess)) {
            this.loopOnlinePlayers(server, sender, false, true, args[0], null);
            return;
        }
        this.restPlayer(sender.getUser(this.ess));
    }

    @Override
    protected void updatePlayer(Server server, CommandSource sender, User player, String[] args) throws PlayerExemptException {
        this.restPlayer(player);
        sender.sendMessage(I18n.tl("restOther", player.getDisplayName()));
    }

    private void restPlayer(IUser user) {
        user.getBase().setStatistic(Statistic.TIME_SINCE_REST, 0);
        user.sendMessage(I18n.tl("rest", new Object[0]));
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (args.length == 1 && sender.isAuthorized("essentials.rest.others", this.ess)) {
            return this.getPlayers(server, sender);
        }
        return Collections.emptyList();
    }
}

