/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.ISettings;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.utils.DateUtil;
import com.earth2me.essentials.utils.EnumUtil;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.ess3.api.events.JailStatusChangeEvent;
import org.bukkit.Server;
import org.bukkit.Statistic;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerTeleportEvent;

public class Commandtogglejail
extends EssentialsCommand {
    private static final Statistic PLAY_ONE_TICK = EnumUtil.getStatistic("PLAY_ONE_MINUTE", "PLAY_ONE_TICK");

    public Commandtogglejail() {
        super("togglejail");
    }

    @Override
    public void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        User player;
        block19: {
            String jailName;
            block21: {
                block20: {
                    if (args.length == 0) {
                        throw new NotEnoughArgumentsException();
                    }
                    player = this.getPlayer(server, args, 0, true, true);
                    if (player.isJailed()) break block19;
                    if (!player.getBase().isOnline() && sender.isPlayer() && !this.ess.getUser(sender.getPlayer()).isAuthorized("essentials.togglejail.offline")) {
                        sender.sendMessage(I18n.tl("mayNotJailOffline", new Object[0]));
                        return;
                    }
                    if (player.isAuthorized("essentials.jail.exempt")) {
                        sender.sendMessage(I18n.tl("mayNotJail", new Object[0]));
                        return;
                    }
                    if (args.length <= 1) break block20;
                    jailName = args[1];
                    break block21;
                }
                if (this.ess.getJails().getCount() != 1) break block19;
                jailName = (String)Iterables.get(this.ess.getJails().getList(), (int)0);
            }
            this.ess.getJails().getJail(jailName);
            JailStatusChangeEvent event = new JailStatusChangeEvent(player, sender.isPlayer() ? this.ess.getUser(sender.getPlayer()) : null, true);
            this.ess.getServer().getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                long displayTime = 0L;
                long preTimeDiff = 0L;
                if (args.length > 2) {
                    String time = Commandtogglejail.getFinalArg(args, 2);
                    displayTime = DateUtil.parseDateDiff(time, true);
                    preTimeDiff = DateUtil.parseDateDiff(time, true, this.ess.getSettings().isJailOnlineTime());
                }
                long timeDiff = preTimeDiff;
                long finalDisplayTime = displayTime;
                CompletableFuture<Boolean> future = this.getNewExceptionFuture(sender, commandLabel);
                future.thenAccept(success -> {
                    if (success.booleanValue()) {
                        player.setJailed(true);
                        player.sendMessage(I18n.tl("userJailed", new Object[0]));
                        player.setJail(null);
                        player.setJail(jailName);
                        if (args.length > 2) {
                            player.setJailTimeout(timeDiff);
                            player.setOnlineJailedTime(this.ess.getSettings().isJailOnlineTime() ? (long)player.getBase().getStatistic(PLAY_ONE_TICK) + timeDiff / 50L : 0L);
                        }
                        sender.sendMessage(timeDiff > 0L ? I18n.tl("playerJailedFor", player.getName(), DateUtil.formatDateDiff(finalDisplayTime)) : I18n.tl("playerJailed", player.getName()));
                    }
                });
                if (player.getBase().isOnline()) {
                    this.ess.getJails().sendToJail(player, jailName, future);
                } else {
                    future.complete(true);
                }
            }
            return;
        }
        if (args.length >= 2 && player.isJailed() && !args[1].equalsIgnoreCase(player.getJail())) {
            sender.sendMessage(I18n.tl("jailAlreadyIncarcerated", player.getJail()));
            return;
        }
        if (args.length >= 2 && player.isJailed() && args[1].equalsIgnoreCase(player.getJail())) {
            String unparsedTime = Commandtogglejail.getFinalArg(args, 2);
            long displayTimeDiff = DateUtil.parseDateDiff(unparsedTime, true);
            long timeDiff = DateUtil.parseDateDiff(unparsedTime, true, this.ess.getSettings().isJailOnlineTime());
            player.setJailTimeout(timeDiff);
            player.setOnlineJailedTime(this.ess.getSettings().isJailOnlineTime() ? (long)player.getBase().getStatistic(PLAY_ONE_TICK) + timeDiff / 50L : 0L);
            sender.sendMessage(I18n.tl("jailSentenceExtended", DateUtil.formatDateDiff(displayTimeDiff)));
            return;
        }
        if (args.length == 1 || args.length == 2 && args[1].equalsIgnoreCase(player.getJail())) {
            if (!player.isJailed()) {
                throw new NotEnoughArgumentsException();
            }
            JailStatusChangeEvent event = new JailStatusChangeEvent(player, sender.isPlayer() ? this.ess.getUser(sender.getPlayer()) : null, false);
            this.ess.getServer().getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                player.setJailed(false);
                player.setJailTimeout(0L);
                player.sendMessage(I18n.tl("jailReleasedPlayerNotify", new Object[0]));
                player.setJail(null);
                if (player.getBase().isOnline()) {
                    CompletableFuture<Boolean> future = this.getNewExceptionFuture(sender, commandLabel);
                    future.thenAccept(success -> {
                        if (success.booleanValue()) {
                            sender.sendMessage(I18n.tl("jailReleased", player.getName()));
                        }
                    });
                    if (this.ess.getSettings().getTeleportWhenFreePolicy() == ISettings.TeleportWhenFreePolicy.BACK) {
                        player.getAsyncTeleport().back(future);
                        future.exceptionally(e -> {
                            player.getAsyncTeleport().respawn(null, PlayerTeleportEvent.TeleportCause.PLUGIN, new CompletableFuture<Boolean>());
                            sender.sendMessage(I18n.tl("jailReleased", player.getName()));
                            return false;
                        });
                    } else if (this.ess.getSettings().getTeleportWhenFreePolicy() == ISettings.TeleportWhenFreePolicy.SPAWN) {
                        player.getAsyncTeleport().respawn(null, PlayerTeleportEvent.TeleportCause.PLUGIN, future);
                    }
                    return;
                }
                sender.sendMessage(I18n.tl("jailReleased", player.getName()));
            }
        }
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (args.length == 1) {
            return this.getPlayers(server, sender);
        }
        if (args.length == 2) {
            try {
                return new ArrayList<String>(this.ess.getJails().getList());
            }
            catch (Exception e) {
                return Collections.emptyList();
            }
        }
        return COMMON_DATE_DIFFS;
    }
}

