/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.utils.LocationUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.TreeType;
import org.bukkit.entity.LivingEntity;

public class Commandtree
extends EssentialsCommand {
    public Commandtree() {
        super("tree");
    }

    @Override
    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        TreeType tree = null;
        if (args.length < 1) {
            throw new NotEnoughArgumentsException();
        }
        for (TreeType type : TreeType.values()) {
            if (!type.name().replace("_", "").equalsIgnoreCase(args[0])) continue;
            tree = type;
            break;
        }
        if (args[0].equalsIgnoreCase("jungle")) {
            tree = TreeType.SMALL_JUNGLE;
        }
        if (tree == null) {
            throw new NotEnoughArgumentsException();
        }
        Location loc = LocationUtil.getTarget((LivingEntity)user.getBase()).add(0.0, 1.0, 0.0);
        if (loc.getBlock().getType().isSolid()) {
            throw new Exception(I18n.tl("treeFailure", new Object[0]));
        }
        if (user.getWorld().generateTree(loc, tree)) {
            user.sendMessage(I18n.tl("treeSpawned", new Object[0]));
            return;
        }
        user.sendMessage(I18n.tl("treeFailure", new Object[0]));
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, User user, String commandLabel, String[] args) {
        if (args.length == 1) {
            ArrayList options = Lists.newArrayList();
            for (TreeType type : TreeType.values()) {
                options.add(type.name().toLowerCase(Locale.ENGLISH).replace("_", ""));
            }
            return options;
        }
        return Collections.emptyList();
    }
}

