/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.utils;

import com.earth2me.essentials.I18n;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import net.ess3.api.IEssentials;

public final class NumberUtil {
    private static final DecimalFormat twoDPlaces = new DecimalFormat("#,###.##");
    private static final DecimalFormat currencyFormat = new DecimalFormat("#0.00", DecimalFormatSymbols.getInstance(Locale.US));
    private static NumberFormat PRETTY_FORMAT = NumberFormat.getInstance(Locale.US);

    private NumberUtil() {
    }

    public static void internalSetPrettyFormat(NumberFormat prettyFormat) {
        PRETTY_FORMAT = prettyFormat;
    }

    public static String shortCurrency(BigDecimal value, IEssentials ess) {
        if (ess.getSettings().isCurrencySymbolSuffixed()) {
            return NumberUtil.formatAsCurrency(value) + ess.getSettings().getCurrencySymbol();
        }
        return ess.getSettings().getCurrencySymbol() + NumberUtil.formatAsCurrency(value);
    }

    public static String formatDouble(double value) {
        return twoDPlaces.format(value);
    }

    public static String formatAsCurrency(BigDecimal value) {
        String str = currencyFormat.format(value);
        if (str.endsWith(".00")) {
            str = str.substring(0, str.length() - 3);
        }
        return str;
    }

    public static String formatAsPrettyCurrency(BigDecimal value) {
        String str = PRETTY_FORMAT.format(value);
        if (str.endsWith(".00")) {
            str = str.substring(0, str.length() - 3);
        }
        return str;
    }

    public static String displayCurrency(BigDecimal value, IEssentials ess) {
        String currency = NumberUtil.formatAsPrettyCurrency(value);
        String sign = "";
        if (value.signum() < 0) {
            currency = currency.substring(1);
            sign = "-";
        }
        if (ess.getSettings().isCurrencySymbolSuffixed()) {
            return sign + I18n.tl("currency", currency, ess.getSettings().getCurrencySymbol());
        }
        return sign + I18n.tl("currency", ess.getSettings().getCurrencySymbol(), currency);
    }

    public static String displayCurrencyExactly(BigDecimal value, IEssentials ess) {
        String currency = value.toPlainString();
        String sign = "";
        if (value.signum() < 0) {
            currency = currency.substring(1);
            sign = "-";
        }
        if (ess.getSettings().isCurrencySymbolSuffixed()) {
            return sign + I18n.tl("currency", currency, ess.getSettings().getCurrencySymbol());
        }
        return sign + I18n.tl("currency", ess.getSettings().getCurrencySymbol(), currency);
    }

    public static String sanitizeCurrencyString(String input, IEssentials ess) {
        return input.replace(ess.getSettings().getCurrencySymbol(), "");
    }

    public static boolean isInt(String sInt) {
        try {
            Integer.parseInt(sInt);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static boolean isPositiveInt(String sInt) {
        if (!NumberUtil.isInt(sInt)) {
            return false;
        }
        return Integer.parseInt(sInt) > 0;
    }

    static {
        twoDPlaces.setRoundingMode(RoundingMode.HALF_UP);
        currencyFormat.setRoundingMode(RoundingMode.FLOOR);
        PRETTY_FORMAT.setRoundingMode(RoundingMode.FLOOR);
        PRETTY_FORMAT.setGroupingUsed(true);
        PRETTY_FORMAT.setMinimumFractionDigits(2);
        PRETTY_FORMAT.setMaximumFractionDigits(2);
    }
}

