/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.AsyncTimedTeleport;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.ITarget;
import com.earth2me.essentials.LocationTarget;
import com.earth2me.essentials.PlayerTarget;
import com.earth2me.essentials.Trade;
import com.earth2me.essentials.api.IAsyncTeleport;
import com.earth2me.essentials.commands.WarpNotFoundException;
import com.earth2me.essentials.paperlib.PaperLib;
import com.earth2me.essentials.utils.DateUtil;
import com.earth2me.essentials.utils.LocationUtil;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import net.ess3.api.IEssentials;
import net.ess3.api.IUser;
import net.ess3.api.InvalidWorldException;
import net.ess3.api.events.UserWarpEvent;
import net.ess3.api.events.teleport.PreTeleportEvent;
import net.ess3.api.events.teleport.TeleportWarmupEvent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class AsyncTeleport
implements IAsyncTeleport {
    private final IUser teleportOwner;
    private final IEssentials ess;
    private AsyncTimedTeleport timedTeleport;
    private TeleportType tpType;

    public AsyncTeleport(IUser user, IEssentials ess) {
        this.teleportOwner = user;
        this.ess = ess;
        this.tpType = TeleportType.NORMAL;
    }

    public void cooldown(boolean check) throws Throwable {
        CompletableFuture<Boolean> exceptionFuture = new CompletableFuture<Boolean>();
        if (this.cooldown(check, exceptionFuture)) {
            try {
                exceptionFuture.get();
            }
            catch (ExecutionException e) {
                throw e.getCause();
            }
        }
    }

    public boolean cooldown(boolean check, CompletableFuture<Boolean> future) {
        GregorianCalendar time = new GregorianCalendar();
        if (this.teleportOwner.getLastTeleportTimestamp() > 0L) {
            double cooldown = this.ess.getSettings().getTeleportCooldown();
            GregorianCalendar earliestTime = new GregorianCalendar();
            ((Calendar)earliestTime).add(13, -((int)cooldown));
            ((Calendar)earliestTime).add(14, -((int)(cooldown * 1000.0 % 1000.0)));
            long earliestLong = earliestTime.getTimeInMillis();
            long lastTime = this.teleportOwner.getLastTeleportTimestamp();
            if (lastTime > time.getTimeInMillis()) {
                this.teleportOwner.setLastTeleportTimestamp(time.getTimeInMillis());
                return false;
            }
            if (lastTime > earliestLong && this.cooldownApplies()) {
                time.setTimeInMillis(lastTime);
                ((Calendar)time).add(13, (int)cooldown);
                ((Calendar)time).add(14, (int)(cooldown * 1000.0 % 1000.0));
                future.completeExceptionally(new Exception(I18n.tl("timeBeforeTeleport", DateUtil.formatDateDiff(time.getTimeInMillis()))));
                return true;
            }
        }
        if (!check) {
            this.teleportOwner.setLastTeleportTimestamp(time.getTimeInMillis());
        }
        return false;
    }

    private boolean cooldownApplies() {
        boolean applies = true;
        String globalBypassPerm = "essentials.teleport.cooldown.bypass";
        switch (this.tpType) {
            case NORMAL: {
                applies = !this.teleportOwner.isAuthorized("essentials.teleport.cooldown.bypass");
                break;
            }
            case BACK: {
                applies = !this.teleportOwner.isAuthorized("essentials.teleport.cooldown.bypass") || !this.teleportOwner.isAuthorized("essentials.teleport.cooldown.bypass.back");
                break;
            }
            case TPA: {
                applies = !this.teleportOwner.isAuthorized("essentials.teleport.cooldown.bypass") || !this.teleportOwner.isAuthorized("essentials.teleport.cooldown.bypass.tpa");
            }
        }
        return applies;
    }

    private void warnUser(IUser user, double delay) {
        GregorianCalendar c = new GregorianCalendar();
        ((Calendar)c).add(13, (int)delay);
        ((Calendar)c).add(14, (int)(delay * 1000.0 % 1000.0));
        user.sendMessage(I18n.tl("dontMoveMessage", DateUtil.formatDateDiff(c.getTimeInMillis())));
    }

    @Override
    public void now(Location loc, boolean cooldown, PlayerTeleportEvent.TeleportCause cause, CompletableFuture<Boolean> future) {
        if (cooldown && this.cooldown(false, future)) {
            return;
        }
        LocationTarget target = new LocationTarget(loc);
        this.nowAsync(this.teleportOwner, target, cause, future);
    }

    @Override
    public void now(Player entity, boolean cooldown, PlayerTeleportEvent.TeleportCause cause, CompletableFuture<Boolean> future) {
        if (cooldown && this.cooldown(false, future)) {
            future.complete(false);
            return;
        }
        PlayerTarget target = new PlayerTarget(entity);
        this.nowAsync(this.teleportOwner, target, cause, future);
        future.thenAccept(success -> {
            if (success.booleanValue()) {
                this.teleportOwner.sendMessage(I18n.tl("teleporting", target.getLocation().getWorld().getName(), target.getLocation().getBlockX(), target.getLocation().getBlockY(), target.getLocation().getBlockZ()));
            }
        });
    }

    @Override
    public void nowUnsafe(Location loc, PlayerTeleportEvent.TeleportCause cause, CompletableFuture<Boolean> future) {
        CompletableFuture<Boolean> paperFuture = PaperLib.teleportAsync((Entity)this.teleportOwner.getBase(), loc, cause);
        paperFuture.thenAccept(future::complete);
        paperFuture.exceptionally(future::completeExceptionally);
    }

    private void runOnMain(Runnable runnable) throws ExecutionException, InterruptedException {
        if (Bukkit.isPrimaryThread()) {
            runnable.run();
            return;
        }
        CompletableFuture taskLock = new CompletableFuture();
        Bukkit.getScheduler().runTask((Plugin)this.ess, () -> {
            runnable.run();
            taskLock.complete(new Object());
        });
        taskLock.get();
    }

    protected void nowAsync(IUser teleportee, ITarget target, PlayerTeleportEvent.TeleportCause cause, CompletableFuture<Boolean> future) {
        this.cancel(false);
        PreTeleportEvent event = new PreTeleportEvent(teleportee, cause, target);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            future.complete(false);
            return;
        }
        if (!this.ess.getSettings().isForcePassengerTeleport() && !teleportee.getBase().isEmpty()) {
            if (!this.ess.getSettings().isTeleportPassengerDismount()) {
                future.completeExceptionally(new Exception(I18n.tl("passengerTeleportFail", new Object[0])));
                return;
            }
            try {
                this.runOnMain(() -> teleportee.getBase().eject());
            }
            catch (InterruptedException | ExecutionException e) {
                future.completeExceptionally(e);
                return;
            }
        }
        if (teleportee.isAuthorized("essentials.back.onteleport")) {
            teleportee.setLastLocation();
        }
        Location targetLoc = target.getLocation();
        if (this.ess.getSettings().isTeleportSafetyEnabled() && !this.ess.getSettings().isForceDisableTeleportSafety() && LocationUtil.isBlockOutsideWorldBorder(targetLoc.getWorld(), targetLoc.getBlockX(), targetLoc.getBlockZ())) {
            targetLoc.setX((double)LocationUtil.getXInsideWorldBorder(targetLoc.getWorld(), targetLoc.getBlockX()));
            targetLoc.setZ((double)LocationUtil.getZInsideWorldBorder(targetLoc.getWorld(), targetLoc.getBlockZ()));
        }
        ((CompletableFuture)PaperLib.getChunkAtAsync(targetLoc.getWorld(), targetLoc.getBlockX() >> 4, targetLoc.getBlockZ() >> 4, true, true).thenAccept(chunk -> {
            Location loc = targetLoc;
            if (LocationUtil.isBlockUnsafeForUser(teleportee, chunk.getWorld(), loc.getBlockX(), loc.getBlockY(), loc.getBlockZ())) {
                if (!this.ess.getSettings().isTeleportSafetyEnabled()) {
                    future.completeExceptionally(new Exception(I18n.tl("unsafeTeleportDestination", loc.getWorld().getName(), loc.getBlockX(), loc.getBlockY(), loc.getBlockZ())));
                    return;
                }
                if (this.ess.getSettings().isForceDisableTeleportSafety()) {
                    teleportee.getBase().teleport(loc, cause);
                } else {
                    try {
                        PaperLib.teleportAsync((Entity)teleportee.getBase(), LocationUtil.getSafeDestination(this.ess, teleportee, loc), cause);
                    }
                    catch (Exception e) {
                        future.completeExceptionally(e);
                        return;
                    }
                }
            } else if (this.ess.getSettings().isForceDisableTeleportSafety()) {
                teleportee.getBase().teleport(loc, cause);
            } else {
                if (this.ess.getSettings().isTeleportToCenterLocation()) {
                    loc = LocationUtil.getRoundedDestination(loc);
                }
                PaperLib.teleportAsync((Entity)teleportee.getBase(), loc, cause);
            }
            future.complete(true);
        })).exceptionally(th -> {
            future.completeExceptionally((Throwable)th);
            return null;
        });
    }

    @Override
    public void teleport(Location loc, Trade chargeFor, PlayerTeleportEvent.TeleportCause cause, CompletableFuture<Boolean> future) {
        this.teleport(this.teleportOwner, new LocationTarget(loc), chargeFor, cause, future);
    }

    @Override
    public void teleport(Player entity, Trade chargeFor, PlayerTeleportEvent.TeleportCause cause, CompletableFuture<Boolean> future) {
        this.teleportOwner.sendMessage(I18n.tl("teleportToPlayer", entity.getDisplayName()));
        this.teleport(this.teleportOwner, new PlayerTarget(entity), chargeFor, cause, future);
    }

    @Override
    public void teleportPlayer(IUser otherUser, Location loc, Trade chargeFor, PlayerTeleportEvent.TeleportCause cause, CompletableFuture<Boolean> future) {
        this.teleport(otherUser, new LocationTarget(loc), chargeFor, cause, future);
    }

    @Override
    public void teleportPlayer(IUser otherUser, Player entity, Trade chargeFor, PlayerTeleportEvent.TeleportCause cause, CompletableFuture<Boolean> future) {
        PlayerTarget target = new PlayerTarget(entity);
        this.teleport(otherUser, target, chargeFor, cause, future);
        future.thenAccept(success -> {
            if (success.booleanValue()) {
                otherUser.sendMessage(I18n.tl("teleporting", target.getLocation().getWorld().getName(), target.getLocation().getBlockX(), target.getLocation().getBlockY(), target.getLocation().getBlockZ()));
                this.teleportOwner.sendMessage(I18n.tl("teleporting", target.getLocation().getWorld().getName(), target.getLocation().getBlockX(), target.getLocation().getBlockY(), target.getLocation().getBlockZ()));
            }
        });
    }

    private void teleport(IUser teleportee, ITarget target, Trade chargeFor, PlayerTeleportEvent.TeleportCause cause, CompletableFuture<Boolean> future) {
        double delay = this.ess.getSettings().getTeleportDelay();
        TeleportWarmupEvent event = new TeleportWarmupEvent(teleportee, cause, target, delay);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            future.complete(false);
            return;
        }
        delay = event.getDelay();
        Trade cashCharge = chargeFor;
        if (chargeFor != null) {
            chargeFor.isAffordableFor(this.teleportOwner, future);
            if (future.isCompletedExceptionally()) {
                return;
            }
            if (!chargeFor.getCommandCost(this.teleportOwner).equals(BigDecimal.ZERO)) {
                cashCharge = new Trade(chargeFor.getCommandCost(this.teleportOwner), this.ess);
            }
        }
        if (this.cooldown(true, future)) {
            future.complete(false);
            return;
        }
        if (delay <= 0.0 || this.teleportOwner.isAuthorized("essentials.teleport.timer.bypass") || teleportee.isAuthorized("essentials.teleport.timer.bypass")) {
            if (this.cooldown(false, future)) {
                future.complete(false);
                return;
            }
            this.nowAsync(teleportee, target, cause, future);
            if (cashCharge != null) {
                cashCharge.charge(this.teleportOwner, future);
                if (future.isCompletedExceptionally()) {
                    return;
                }
            }
            future.complete(true);
            return;
        }
        this.cancel(false);
        this.warnUser(teleportee, delay);
        this.initTimer((long)(delay * 1000.0), teleportee, target, cashCharge, cause, false, future);
    }

    private void teleportOther(IUser teleporter, IUser teleportee, ITarget target, Trade chargeFor, PlayerTeleportEvent.TeleportCause cause, CompletableFuture<Boolean> future) {
        double delay = this.ess.getSettings().getTeleportDelay();
        TeleportWarmupEvent event = new TeleportWarmupEvent(teleportee, cause, target, delay);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        delay = event.getDelay();
        Trade cashCharge = chargeFor;
        if (teleporter != null && chargeFor != null) {
            chargeFor.isAffordableFor(teleporter, future);
            if (future.isCompletedExceptionally()) {
                return;
            }
            if (!chargeFor.getCommandCost(teleporter).equals(BigDecimal.ZERO)) {
                cashCharge = new Trade(chargeFor.getCommandCost(teleporter), this.ess);
            }
        }
        if (this.cooldown(true, future)) {
            return;
        }
        if (delay <= 0.0 || teleporter == null || teleporter.isAuthorized("essentials.teleport.timer.bypass") || this.teleportOwner.isAuthorized("essentials.teleport.timer.bypass") || teleportee.isAuthorized("essentials.teleport.timer.bypass")) {
            if (this.cooldown(false, future)) {
                return;
            }
            this.nowAsync(teleportee, target, cause, future);
            if (teleporter != null && cashCharge != null) {
                cashCharge.charge(teleporter, future);
                if (future.isCompletedExceptionally()) {
                    return;
                }
            }
            future.complete(true);
            return;
        }
        this.cancel(false);
        this.warnUser(teleportee, delay);
        this.initTimer((long)(delay * 1000.0), teleportee, target, cashCharge, cause, false, future);
    }

    @Override
    public void respawn(Trade chargeFor, PlayerTeleportEvent.TeleportCause cause, CompletableFuture<Boolean> future) {
        double delay = this.ess.getSettings().getTeleportDelay();
        TeleportWarmupEvent event = new TeleportWarmupEvent(this.teleportOwner, cause, null, delay);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        delay = event.getDelay();
        if (chargeFor != null) {
            chargeFor.isAffordableFor(this.teleportOwner, future);
            if (future.isCompletedExceptionally()) {
                return;
            }
        }
        if (this.cooldown(true, future)) {
            return;
        }
        if (delay <= 0.0 || this.teleportOwner.isAuthorized("essentials.teleport.timer.bypass")) {
            if (this.cooldown(false, future)) {
                return;
            }
            this.respawnNow(this.teleportOwner, cause, future);
            if (chargeFor != null) {
                chargeFor.charge(this.teleportOwner, future);
            }
            future.complete(true);
            return;
        }
        this.cancel(false);
        this.warnUser(this.teleportOwner, delay);
        this.initTimer((long)(delay * 1000.0), this.teleportOwner, null, chargeFor, cause, true, future);
    }

    void respawnNow(IUser teleportee, PlayerTeleportEvent.TeleportCause cause, CompletableFuture<Boolean> future) {
        Player player = teleportee.getBase();
        ((CompletableFuture)PaperLib.getBedSpawnLocationAsync(player, true).thenAccept(location -> {
            if (location != null) {
                this.nowAsync(teleportee, new LocationTarget((Location)location), cause, future);
            } else {
                if (this.ess.getSettings().isDebug()) {
                    this.ess.getLogger().info("Could not find bed spawn, forcing respawn event.");
                }
                PlayerRespawnEvent pre = new PlayerRespawnEvent(player, player.getWorld().getSpawnLocation(), false);
                this.ess.getServer().getPluginManager().callEvent((Event)pre);
                this.nowAsync(teleportee, new LocationTarget(pre.getRespawnLocation()), cause, future);
            }
        })).exceptionally(th -> {
            future.completeExceptionally((Throwable)th);
            return null;
        });
    }

    @Override
    public void warp(IUser otherUser, String warp, Trade chargeFor, PlayerTeleportEvent.TeleportCause cause, CompletableFuture<Boolean> future) {
        Location loc;
        UserWarpEvent event = new UserWarpEvent(otherUser, warp, chargeFor);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        warp = event.getWarp();
        try {
            loc = this.ess.getWarps().getWarp(warp);
        }
        catch (WarpNotFoundException | InvalidWorldException e) {
            future.completeExceptionally(e);
            return;
        }
        String finalWarp = warp;
        future.thenAccept(success -> {
            if (success.booleanValue()) {
                otherUser.sendMessage(I18n.tl("warpingTo", finalWarp, loc.getWorld().getName(), loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()));
                if (!otherUser.equals(this.teleportOwner)) {
                    this.teleportOwner.sendMessage(I18n.tl("warpingTo", finalWarp, loc.getWorld().getName(), loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()));
                }
            }
        });
        this.teleport(otherUser, new LocationTarget(loc), chargeFor, cause, future);
    }

    @Override
    public void back(Trade chargeFor, CompletableFuture<Boolean> future) {
        this.back(this.teleportOwner, chargeFor, future);
    }

    @Override
    public void back(IUser teleporter, Trade chargeFor, CompletableFuture<Boolean> future) {
        this.tpType = TeleportType.BACK;
        Location loc = this.teleportOwner.getLastLocation();
        this.teleportOwner.sendMessage(I18n.tl("backUsageMsg", loc.getWorld().getName(), loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()));
        this.teleportOther(teleporter, this.teleportOwner, new LocationTarget(loc), chargeFor, PlayerTeleportEvent.TeleportCause.COMMAND, future);
    }

    @Override
    public void back(CompletableFuture<Boolean> future) {
        this.nowAsync(this.teleportOwner, new LocationTarget(this.teleportOwner.getLastLocation()), PlayerTeleportEvent.TeleportCause.COMMAND, future);
    }

    public void setTpType(TeleportType tpType) {
        this.tpType = tpType;
    }

    private void cancel(boolean notifyUser) {
        if (this.timedTeleport != null) {
            this.timedTeleport.cancelTimer(notifyUser);
            this.timedTeleport = null;
        }
    }

    private void initTimer(long delay, IUser teleportUser, ITarget target, Trade chargeFor, PlayerTeleportEvent.TeleportCause cause, boolean respawn, CompletableFuture<Boolean> future) {
        this.timedTeleport = new AsyncTimedTeleport(this.teleportOwner, this.ess, this, delay, future, teleportUser, target, chargeFor, cause, respawn);
    }

    public static enum TeleportType {
        TPA,
        BACK,
        NORMAL;

    }
}

