/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.IConf;
import com.earth2me.essentials.IEssentials;
import com.earth2me.essentials.Kit;
import com.earth2me.essentials.Trade;
import com.earth2me.essentials.User;
import com.earth2me.essentials.config.ConfigurateUtil;
import com.earth2me.essentials.config.EssentialsConfiguration;
import com.earth2me.essentials.libs.configurate.CommentedConfigurationNode;
import com.earth2me.essentials.libs.configurate.serialize.SerializationException;
import com.earth2me.essentials.utils.NumberUtil;
import java.io.File;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class Kits
implements IConf {
    private final EssentialsConfiguration config;
    private CommentedConfigurationNode kits;

    public Kits(IEssentials essentials) {
        this.config = new EssentialsConfiguration(new File(essentials.getDataFolder(), "kits.yml"), "/kits.yml");
        this.reloadConfig();
    }

    @Override
    public void reloadConfig() {
        this.config.load();
        this.kits = this._getKits();
    }

    private CommentedConfigurationNode _getKits() {
        CommentedConfigurationNode section = this.config.getSection("kits");
        if (section != null) {
            CommentedConfigurationNode newSection = this.config.newSection();
            for (String kitItem : ConfigurateUtil.getKeys(section)) {
                CommentedConfigurationNode kitSection = (CommentedConfigurationNode)section.node(new Object[]{kitItem});
                if (!kitSection.isMap()) continue;
                try {
                    ((CommentedConfigurationNode)newSection.node(new Object[]{kitItem.toLowerCase(Locale.ENGLISH)})).set(kitSection);
                }
                catch (SerializationException e) {
                    e.printStackTrace();
                }
            }
            return newSection;
        }
        return null;
    }

    public EssentialsConfiguration getConfig() {
        return this.config;
    }

    public CommentedConfigurationNode getKits() {
        return this.kits;
    }

    public Map<String, Object> getKit(String name) {
        CommentedConfigurationNode kits;
        CommentedConfigurationNode kitSection;
        name = name.replace('.', '_').replace('/', '_');
        if (this.getKits() != null && !(kitSection = (CommentedConfigurationNode)(kits = this.getKits()).node(new Object[]{name.toLowerCase()})).virtual() && kitSection.isMap()) {
            return ConfigurateUtil.getRawMap(kitSection);
        }
        return null;
    }

    public String matchKit(String name) {
        CommentedConfigurationNode section = this.config.getSection("kits");
        if (section != null) {
            for (String kitName : ConfigurateUtil.getKeys(section)) {
                if (!kitName.equalsIgnoreCase(name)) continue;
                return kitName;
            }
        }
        return null;
    }

    public void addKit(String name, List<String> lines, long delay) {
        this.config.setProperty("kits." + name + ".delay", delay);
        this.config.setProperty("kits." + name + ".items", lines);
        this.kits = this._getKits();
        this.config.save();
    }

    public void removeKit(String name) {
        this.config.removeProperty("kits." + name);
        this.kits = this._getKits();
        this.config.save();
    }

    public String listKits(net.ess3.api.IEssentials ess, User user) throws Exception {
        try {
            CommentedConfigurationNode kits = this.config.getSection("kits");
            StringBuilder list = new StringBuilder();
            for (String kitItem : ConfigurateUtil.getKeys(kits)) {
                Kit kit;
                double nextUse;
                if (user == null) {
                    list.append(" ").append(I18n.capitalCase(kitItem));
                    continue;
                }
                if (!user.isAuthorized("essentials.kits." + kitItem.toLowerCase(Locale.ENGLISH))) continue;
                String cost = "";
                String name = I18n.capitalCase(kitItem);
                BigDecimal costPrice = new Trade("kit-" + kitItem.toLowerCase(Locale.ENGLISH), ess).getCommandCost(user);
                if (costPrice.signum() > 0) {
                    cost = I18n.tl("kitCost", NumberUtil.displayCurrency(costPrice, ess));
                }
                if ((nextUse = (double)(kit = new Kit(kitItem, ess)).getNextUse(user)) == -1.0 && ess.getSettings().isSkippingUsedOneTimeKitsFromKitList()) continue;
                if (nextUse != 0.0) {
                    name = I18n.tl("kitDelay", name);
                }
                list.append(" ").append(name).append(cost);
            }
            return list.toString().trim();
        }
        catch (Exception ex) {
            throw new Exception(I18n.tl("kitError", new Object[0]), ex);
        }
    }
}

