/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.IConf;
import com.earth2me.essentials.IEssentials;
import com.earth2me.essentials.config.EssentialsConfiguration;
import com.earth2me.essentials.config.entities.LazyLocation;
import com.earth2me.essentials.paperlib.PaperLib;
import com.earth2me.essentials.utils.LocationUtil;
import com.earth2me.essentials.utils.VersionUtil;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.ess3.api.InvalidWorldException;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.plugin.Plugin;

public class RandomTeleport
implements IConf {
    private static final Random RANDOM = new Random();
    private static final int HIGHEST_BLOCK_Y_OFFSET = VersionUtil.getServerBukkitVersion().isHigherThanOrEqualTo(VersionUtil.v1_15_R01) ? 1 : 0;
    private final IEssentials essentials;
    private final EssentialsConfiguration config;
    private final ConcurrentLinkedQueue<Location> cachedLocations = new ConcurrentLinkedQueue();

    public RandomTeleport(IEssentials essentials) {
        this.essentials = essentials;
        this.config = new EssentialsConfiguration(new File(essentials.getDataFolder(), "tpr.yml"), "/tpr.yml", "Configuration for the random teleport command.\nSome settings may be defaulted, and can be changed via the /settpr command in-game.");
        this.reloadConfig();
    }

    @Override
    public void reloadConfig() {
        this.config.load();
        this.cachedLocations.clear();
    }

    public Location getCenter() {
        LazyLocation center2;
        try {
            center2 = this.config.getLocation("center");
            if (center2 != null && center2.location() != null) {
                return center2.location();
            }
        }
        catch (InvalidWorldException center2) {
            // empty catch block
        }
        center2 = ((World)this.essentials.getServer().getWorlds().get(0)).getWorldBorder().getCenter();
        center2.setY(center2.getWorld().getHighestBlockYAt((Location)center2) + 1);
        this.setCenter((Location)center2);
        return center2;
    }

    public void setCenter(Location center) {
        this.config.setProperty("center", center);
        this.config.save();
    }

    public double getMinRange() {
        return this.config.getDouble("min-range", 0.0);
    }

    public void setMinRange(double minRange) {
        this.config.setProperty("min-range", minRange);
        this.config.save();
    }

    public double getMaxRange() {
        return this.config.getDouble("max-range", this.getCenter().getWorld().getWorldBorder().getSize() / 2.0);
    }

    public void setMaxRange(double maxRange) {
        this.config.setProperty("max-range", maxRange);
        this.config.save();
    }

    public Set<Biome> getExcludedBiomes() {
        List<String> biomeNames = this.config.getList("excluded-biomes", String.class);
        HashSet<Biome> excludedBiomes = new HashSet<Biome>();
        for (String biomeName : biomeNames) {
            try {
                excludedBiomes.add(Biome.valueOf((String)biomeName.toUpperCase()));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return excludedBiomes;
    }

    public int getFindAttempts() {
        return this.config.getInt("find-attempts", 10);
    }

    public int getCacheThreshold() {
        return this.config.getInt("cache-threshold", 10);
    }

    public boolean getPreCache() {
        return this.config.getBoolean("pre-cache", false);
    }

    public Queue<Location> getCachedLocations() {
        return this.cachedLocations;
    }

    public CompletableFuture<Location> getRandomLocation(Location center, double minRange, double maxRange) {
        int findAttempts = this.getFindAttempts();
        Queue<Location> cachedLocations = this.getCachedLocations();
        if (cachedLocations.size() < this.getCacheThreshold()) {
            this.cacheRandomLocations(center, minRange, maxRange);
        }
        CompletableFuture<Location> future = new CompletableFuture<Location>();
        if (cachedLocations.isEmpty()) {
            this.attemptRandomLocation(findAttempts, center, minRange, maxRange).thenAccept(future::complete);
        } else {
            future.complete(cachedLocations.poll());
        }
        return future;
    }

    public void cacheRandomLocations(Location center, double minRange, double maxRange) {
        this.essentials.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.essentials, () -> {
            for (int i = 0; i < this.getFindAttempts(); ++i) {
                this.calculateRandomLocation(center, minRange, maxRange).thenAccept(location -> {
                    if (this.isValidRandomLocation((Location)location)) {
                        this.getCachedLocations().add((Location)location);
                    }
                });
            }
        });
    }

    private CompletableFuture<Location> attemptRandomLocation(int attempts, Location center, double minRange, double maxRange) {
        CompletableFuture<Location> future = new CompletableFuture<Location>();
        if (attempts > 0) {
            this.calculateRandomLocation(center, minRange, maxRange).thenAccept(location -> {
                if (this.isValidRandomLocation((Location)location)) {
                    future.complete((Location)location);
                } else {
                    this.attemptRandomLocation(attempts - 1, center, minRange, maxRange).thenAccept(future::complete);
                }
            });
        } else {
            future.complete(center);
        }
        return future;
    }

    private CompletableFuture<Location> calculateRandomLocation(Location center, double minRange, double maxRange) {
        double offsetZ;
        double offsetX;
        CompletableFuture<Location> future = new CompletableFuture<Location>();
        double rectX = RANDOM.nextDouble() * (maxRange - minRange) + minRange;
        double rectZ = RANDOM.nextDouble() * (maxRange + minRange) - minRange;
        int transform = RANDOM.nextInt(4);
        if (transform == 0) {
            offsetX = rectX;
            offsetZ = rectZ;
        } else if (transform == 1) {
            offsetX = -rectZ;
            offsetZ = rectX;
        } else if (transform == 2) {
            offsetX = -rectX;
            offsetZ = -rectZ;
        } else {
            offsetX = rectZ;
            offsetZ = -rectX;
        }
        Location location = new Location(center.getWorld(), center.getX() + offsetX, (double)center.getWorld().getMaxHeight(), center.getZ() + offsetZ, 360.0f * RANDOM.nextFloat() - 180.0f, 0.0f);
        PaperLib.getChunkAtAsync(location).thenAccept(chunk -> {
            if (World.Environment.NETHER.equals((Object)center.getWorld().getEnvironment())) {
                location.setY(this.getNetherYAt(location));
            } else {
                location.setY((double)(center.getWorld().getHighestBlockYAt(location) + HIGHEST_BLOCK_Y_OFFSET));
            }
            future.complete(location);
        });
        return future;
    }

    private double getNetherYAt(Location location) {
        for (int y = 32; y < location.getWorld().getMaxHeight() / 2; ++y) {
            if (LocationUtil.isBlockUnsafe(location.getWorld(), location.getBlockX(), y, location.getBlockZ())) continue;
            return y;
        }
        return -1.0;
    }

    private boolean isValidRandomLocation(Location location) {
        return location.getBlockY() > 0 && !this.getExcludedBiomes().contains(location.getBlock().getBiome());
    }
}

