/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.Kit;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NoChargeException;
import com.earth2me.essentials.config.ConfigurateUtil;
import com.earth2me.essentials.utils.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import org.bukkit.Server;

public class Commandkit
extends EssentialsCommand {
    public Commandkit() {
        super("kit");
    }

    @Override
    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        if (args.length < 1) {
            String kitList = this.ess.getKits().listKits(this.ess, user);
            user.sendMessage(kitList.length() > 0 ? I18n.tl("kits", kitList) : I18n.tl("noKits", new Object[0]));
            throw new NoChargeException();
        }
        if (args.length > 1 && user.isAuthorized("essentials.kit.others")) {
            this.giveKits(this.getPlayer(server, user, args, 1), user, StringUtil.sanitizeString(args[0].toLowerCase(Locale.ENGLISH)).trim());
        } else {
            this.giveKits(user, user, StringUtil.sanitizeString(args[0].toLowerCase(Locale.ENGLISH)).trim());
        }
    }

    @Override
    public void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        if (args.length < 2) {
            String kitList = this.ess.getKits().listKits(this.ess, null);
            sender.sendMessage(kitList.length() > 0 ? I18n.tl("kits", kitList) : I18n.tl("noKits", new Object[0]));
            throw new NoChargeException();
        }
        User userTo = this.getPlayer(server, args, 1, true, false);
        for (String kitName : args[0].toLowerCase(Locale.ENGLISH).split(",")) {
            new Kit(kitName, this.ess).expandItems(userTo);
            sender.sendMessage(I18n.tl("kitGiveTo", kitName, userTo.getDisplayName()));
            userTo.sendMessage(I18n.tl("kitReceive", kitName));
        }
    }

    private void giveKits(User userTo, User userFrom, String kitNames) throws Exception {
        if (kitNames.isEmpty()) {
            throw new Exception(I18n.tl("kitNotFound", new Object[0]));
        }
        ArrayList<Kit> kits = new ArrayList<Kit>();
        for (String kitName : kitNames.split(",")) {
            if (kitName.isEmpty()) {
                throw new Exception(I18n.tl("kitNotFound", new Object[0]));
            }
            Kit kit = new Kit(kitName, this.ess);
            kit.checkPerms(userFrom);
            kit.checkDelay(userFrom);
            kit.checkAffordable(userFrom);
            kits.add(kit);
        }
        for (Kit kit : kits) {
            try {
                kit.checkDelay(userFrom);
                kit.checkAffordable(userFrom);
                if (!kit.expandItems(userTo)) continue;
                kit.setTime(userFrom);
                kit.chargeUser(userTo);
                if (!userFrom.equals(userTo)) {
                    userFrom.sendMessage(I18n.tl("kitGiveTo", kit.getName(), userTo.getDisplayName()));
                }
                userTo.sendMessage(I18n.tl("kitReceive", kit.getName()));
            }
            catch (NoChargeException ex) {
                if (!this.ess.getSettings().isDebug()) continue;
                this.ess.getLogger().log(Level.INFO, "Soft kit error, abort spawning " + kit.getName(), ex);
            }
            catch (Exception ex) {
                this.ess.showError(userFrom.getSource(), ex, "\\ kit: " + kit.getName());
            }
        }
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, User user, String commandLabel, String[] args) {
        if (args.length == 1) {
            ArrayList<String> options = new ArrayList<String>();
            for (String kitName : ConfigurateUtil.getKeys(this.ess.getKits().getKits())) {
                if (!user.isAuthorized("essentials.kits." + kitName)) continue;
                options.add(kitName);
            }
            return options;
        }
        if (args.length == 2 && user.isAuthorized("essentials.kit.others")) {
            return this.getPlayers(server, user);
        }
        return Collections.emptyList();
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (args.length == 1) {
            return new ArrayList<String>(ConfigurateUtil.getKeys(this.ess.getKits().getKits()));
        }
        if (args.length == 2) {
            return this.getPlayers(server, sender);
        }
        return Collections.emptyList();
    }
}

