/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.config.ConfigurateUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Server;

public class Commandkitreset
extends EssentialsCommand {
    public Commandkitreset() {
        super("kitreset");
    }

    @Override
    protected void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        if (args.length < 1) {
            throw new NotEnoughArgumentsException();
        }
        String kitName = args[0];
        if (this.ess.getKits().getKit(kitName) == null) {
            throw new Exception(I18n.tl("kitNotFound", new Object[0]));
        }
        User target = user;
        if (args.length > 1 && user.isAuthorized("essentials.kitreset.others")) {
            target = this.getPlayer(server, user, args, 1);
        }
        target.setKitTimestamp(kitName, 0L);
        if (user.equals(target)) {
            user.sendMessage(I18n.tl("kitReset", kitName));
        } else {
            user.sendMessage(I18n.tl("kitResetOther", kitName, target.getDisplayName()));
        }
    }

    @Override
    protected void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        if (args.length < 2) {
            throw new NotEnoughArgumentsException();
        }
        String kitName = args[0];
        if (this.ess.getKits().getKit(kitName) == null) {
            throw new Exception(I18n.tl("kitNotFound", new Object[0]));
        }
        User target = this.getPlayer(server, sender, args, 1);
        target.setKitTimestamp(kitName, 0L);
        sender.sendMessage(I18n.tl("kitResetOther", kitName, target.getDisplayName()));
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (args.length == 1) {
            return new ArrayList<String>(ConfigurateUtil.getKeys(this.ess.getKits().getKits()));
        }
        if (args.length == 2 && sender.isAuthorized("essentials.kitreset.others", this.ess)) {
            return this.getPlayers(server, sender);
        }
        return Collections.emptyList();
    }
}

