/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.items;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.IConf;
import com.earth2me.essentials.User;
import com.earth2me.essentials.utils.FormatUtil;
import com.earth2me.essentials.utils.MaterialUtil;
import com.earth2me.essentials.utils.VersionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.ess3.api.IEssentials;
import net.ess3.api.IItemDb;
import net.ess3.api.PluginKey;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.block.Banner;
import org.bukkit.block.banner.Pattern;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.Potion;
import org.bukkit.potion.PotionEffect;

public abstract class AbstractItemDb
implements IConf,
IItemDb {
    protected final IEssentials ess;
    private final Map<PluginKey, IItemDb.ItemResolver> resolverMap = new HashMap<PluginKey, IItemDb.ItemResolver>();
    protected boolean ready = false;

    AbstractItemDb(IEssentials ess) {
        this.ess = ess;
    }

    @Override
    public void registerResolver(Plugin plugin, String name, IItemDb.ItemResolver resolver) throws Exception {
        PluginKey key = PluginKey.fromKey(plugin, name);
        if (this.resolverMap.containsKey(key)) {
            throw new Exception("Tried to add a duplicate resolver with name " + key.toString());
        }
        this.resolverMap.put(key, resolver);
    }

    @Override
    public void unregisterResolver(Plugin plugin, String name) throws Exception {
        PluginKey key = PluginKey.fromKey(plugin, name);
        if (!this.resolverMap.containsKey(key)) {
            throw new Exception("Tried to remove nonexistent resolver with name " + key.toString());
        }
        this.resolverMap.remove(key);
    }

    @Override
    public boolean isResolverPresent(Plugin plugin, String name) {
        return this.resolverMap.containsKey(PluginKey.fromKey(plugin, name));
    }

    @Override
    public Map<PluginKey, IItemDb.ItemResolver> getResolvers() {
        return new HashMap<PluginKey, IItemDb.ItemResolver>(this.resolverMap);
    }

    @Override
    public Map<PluginKey, IItemDb.ItemResolver> getResolvers(Plugin plugin) {
        HashMap<PluginKey, IItemDb.ItemResolver> matchingResolvers = new HashMap<PluginKey, IItemDb.ItemResolver>();
        for (PluginKey key : this.resolverMap.keySet()) {
            if (!key.getPlugin().equals(plugin)) continue;
            matchingResolvers.put(key, this.resolverMap.get(key));
        }
        return matchingResolvers;
    }

    @Override
    public IItemDb.ItemResolver getResolver(Plugin plugin, String name) {
        return this.resolverMap.get(PluginKey.fromKey(plugin, name));
    }

    @Override
    public ItemStack get(String id) throws Exception {
        return this.get(id, true);
    }

    ItemStack tryResolverDeserialize(String id) {
        for (PluginKey key : this.resolverMap.keySet()) {
            Function resolver;
            ItemStack stack;
            if (this.ess.getSettings().isDebug()) {
                this.ess.getLogger().info(String.format("Trying to deserialize item '%s' with resolver '%s'...", id, key));
            }
            if ((stack = (ItemStack)(resolver = (Function)this.resolverMap.get(key)).apply(id)) == null) continue;
            return stack;
        }
        return null;
    }

    String tryResolverSerialize(ItemStack stack) {
        for (PluginKey key : this.resolverMap.keySet()) {
            IItemDb.ItemResolver resolver;
            String serialized;
            if (this.ess.getSettings().isDebug()) {
                this.ess.getLogger().info(String.format("Trying to serialize '%s' with resolver '%s'...", stack.toString(), key));
            }
            if ((serialized = (resolver = this.resolverMap.get(key)).serialize(stack)) == null) continue;
            return serialized;
        }
        return null;
    }

    Collection<String> getResolverNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (IItemDb.ItemResolver resolver : this.resolverMap.values()) {
            Collection<String> resolverNames = resolver.getNames();
            if (resolverNames == null) continue;
            result.addAll(resolverNames);
        }
        return result;
    }

    @Override
    public List<ItemStack> getMatching(User user, String[] args) throws Exception {
        ArrayList<ItemStack> is = new ArrayList<ItemStack>();
        if (args.length < 1) {
            is.add(user.getItemInHand().clone());
        } else if (args[0].equalsIgnoreCase("hand")) {
            is.add(user.getItemInHand().clone());
        } else if (args[0].equalsIgnoreCase("inventory") || args[0].equalsIgnoreCase("invent") || args[0].equalsIgnoreCase("all")) {
            for (ItemStack stack : user.getBase().getInventory().getContents()) {
                if (stack == null || stack.getType() == Material.AIR) continue;
                is.add(stack.clone());
            }
        } else if (args[0].equalsIgnoreCase("blocks")) {
            for (ItemStack stack : user.getBase().getInventory().getContents()) {
                if (stack == null || stack.getType() == Material.AIR || !stack.getType().isBlock()) continue;
                is.add(stack.clone());
            }
        } else {
            is.add(this.get(args[0]));
        }
        if (is.isEmpty() || ((ItemStack)is.get(0)).getType() == Material.AIR) {
            throw new Exception(I18n.tl("itemSellAir", new Object[0]));
        }
        return is;
    }

    @Override
    public String serialize(ItemStack is) {
        return this.serialize(is, true);
    }

    @Override
    public String serialize(ItemStack is, boolean useResolvers) {
        String serialized;
        if (useResolvers && (serialized = this.tryResolverSerialize(is)) != null) {
            return serialized;
        }
        String mat = this.name(is);
        if (VersionUtil.getServerBukkitVersion().isLowerThanOrEqualTo(VersionUtil.v1_12_2_R01) && is.getData().getData() != 0) {
            mat = mat + ":" + is.getData().getData();
        }
        int quantity = is.getAmount();
        StringBuilder sb = new StringBuilder();
        sb.append(mat).append(" ").append(quantity).append(" ");
        if (is.hasItemMeta()) {
            Set flags;
            ItemMeta meta = is.getItemMeta();
            if (meta.hasDisplayName()) {
                sb.append("name:").append(FormatUtil.unformatString(meta.getDisplayName()).replace(" ", "_")).append(" ");
            }
            if (meta.hasLore()) {
                sb.append("lore:").append(this.serializeLines(meta.getLore())).append(" ");
            }
            if (meta.hasEnchants()) {
                for (Enchantment e : meta.getEnchants().keySet()) {
                    sb.append(e.getName().toLowerCase()).append(":").append(meta.getEnchantLevel(e)).append(" ");
                }
            }
            if ((flags = meta.getItemFlags()) != null && !flags.isEmpty()) {
                sb.append("itemflags:");
                boolean first = true;
                for (ItemFlag flag : flags) {
                    if (!first) {
                        sb.append(",");
                    }
                    sb.append(flag.name());
                    first = false;
                }
            }
        }
        Material material = is.getType();
        switch (material) {
            case WRITTEN_BOOK: 
            case WRITABLE_BOOK: {
                BookMeta bookMeta = (BookMeta)is.getItemMeta();
                if (bookMeta.hasTitle()) {
                    sb.append("title:").append(FormatUtil.unformatString(bookMeta.getTitle()).replace(' ', '_')).append(" ");
                }
                if (bookMeta.hasAuthor()) {
                    sb.append("author:").append(FormatUtil.unformatString(bookMeta.getAuthor()).replace(' ', '_')).append(" ");
                }
                if (!bookMeta.hasPages()) break;
                List pages = bookMeta.getPages();
                for (int i = 0; i < pages.size(); ++i) {
                    sb.append("page").append(i + 1).append(":");
                    sb.append(this.serializeLines(Arrays.asList(((String)pages.get(i)).split("\n"))));
                    sb.append(" ");
                }
                break;
            }
            case ENCHANTED_BOOK: {
                EnchantmentStorageMeta enchantmentStorageMeta = (EnchantmentStorageMeta)is.getItemMeta();
                for (Enchantment e : enchantmentStorageMeta.getStoredEnchants().keySet()) {
                    sb.append(e.getName().toLowerCase()).append(":").append(enchantmentStorageMeta.getStoredEnchantLevel(e)).append(" ");
                }
                break;
            }
        }
        if (MaterialUtil.isFirework(material)) {
            FireworkMeta fireworkMeta = (FireworkMeta)is.getItemMeta();
            if (fireworkMeta.hasEffects()) {
                for (FireworkEffect effect : fireworkMeta.getEffects()) {
                    this.serializeEffectMeta(sb, effect);
                }
                sb.append("power:").append(fireworkMeta.getPower()).append(" ");
            }
        } else if (MaterialUtil.isFireworkCharge(material)) {
            FireworkEffectMeta fireworkEffectMeta = (FireworkEffectMeta)is.getItemMeta();
            if (fireworkEffectMeta.hasEffect()) {
                this.serializeEffectMeta(sb, fireworkEffectMeta.getEffect());
            }
        } else if (MaterialUtil.isPotion(material)) {
            Potion potion = Potion.fromItemStack((ItemStack)is);
            for (PotionEffect e : potion.getEffects()) {
                sb.append("splash:").append(potion.isSplash()).append(" ").append("effect:").append(e.getType().getName().toLowerCase()).append(" ").append("power:").append(e.getAmplifier()).append(" ").append("duration:").append(e.getDuration() / 20).append(" ");
            }
        } else if (MaterialUtil.isPlayerHead(material, is.getData().getData())) {
            SkullMeta skullMeta = (SkullMeta)is.getItemMeta();
            if (skullMeta != null && skullMeta.hasOwner()) {
                sb.append("player:").append(skullMeta.getOwner()).append(" ");
            }
        } else if (MaterialUtil.isBanner(material)) {
            if (material.toString().contains("SHIELD")) {
                BlockStateMeta shieldMeta = (BlockStateMeta)is.getItemMeta();
                Banner shieldBannerMeta = (Banner)shieldMeta.getBlockState();
                DyeColor baseDyeColor = shieldBannerMeta.getBaseColor();
                if (baseDyeColor != null) {
                    int basecolor = baseDyeColor.getColor().asRGB();
                    sb.append("basecolor:").append(basecolor).append(" ");
                }
                for (Pattern p : shieldBannerMeta.getPatterns()) {
                    String type = p.getPattern().getIdentifier();
                    int color = p.getColor().getColor().asRGB();
                    sb.append(type).append(",").append(color).append(" ");
                }
            } else {
                BannerMeta bannerMeta = (BannerMeta)is.getItemMeta();
                if (bannerMeta != null) {
                    DyeColor baseDyeColor = bannerMeta.getBaseColor();
                    if (baseDyeColor == null) {
                        baseDyeColor = MaterialUtil.getColorOf(material);
                    }
                    if (baseDyeColor != null) {
                        int basecolor = baseDyeColor.getColor().asRGB();
                        sb.append("basecolor:").append(basecolor).append(" ");
                    }
                    for (Pattern p : bannerMeta.getPatterns()) {
                        String type = p.getPattern().getIdentifier();
                        int color = p.getColor().getColor().asRGB();
                        sb.append(type).append(",").append(color).append(" ");
                    }
                }
            }
        } else if (MaterialUtil.isLeatherArmor(material)) {
            LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)is.getItemMeta();
            int rgb = leatherArmorMeta.getColor().asRGB();
            sb.append("color:").append(rgb).append(" ");
        }
        return sb.toString().trim().replaceAll("\u00a7", "&");
    }

    private void serializeEffectMeta(StringBuilder sb, FireworkEffect effect) {
        boolean first;
        if (effect.getColors() != null && !effect.getColors().isEmpty()) {
            sb.append("color:");
            first = true;
            for (Color c : effect.getColors()) {
                if (!first) {
                    sb.append(",");
                }
                sb.append("#").append(Integer.toHexString(c.asRGB()));
                first = false;
            }
            sb.append(" ");
        }
        sb.append("shape:").append(effect.getType().name()).append(" ");
        if (effect.getFadeColors() != null && !effect.getFadeColors().isEmpty()) {
            sb.append("fade:");
            first = true;
            for (Color c : effect.getFadeColors()) {
                if (!first) {
                    sb.append(",");
                }
                sb.append("#").append(Integer.toHexString(c.asRGB()));
                first = false;
            }
            sb.append(" ");
        }
    }

    private String serializeLines(Iterable<String> lines) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String line : lines) {
            if (!first) {
                sb.append("|");
            }
            first = false;
            sb.append(FormatUtil.unformatString(line).replace(" ", "_").replace("|", "\\|"));
        }
        return sb.toString();
    }

    @Override
    public boolean isReady() {
        return this.ready;
    }
}

