/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.libs.configurate.transformation;

import com.earth2me.essentials.libs.checkerframework.checker.nullness.qual.Nullable;
import com.earth2me.essentials.libs.configurate.ConfigurateException;
import com.earth2me.essentials.libs.configurate.ConfigurationNode;
import com.earth2me.essentials.libs.configurate.transformation.ConfigurationTransformation;
import java.util.Arrays;

class ChainedConfigurationTransformation
implements ConfigurationTransformation {
    private final ConfigurationTransformation[] transformations;

    ChainedConfigurationTransformation(ConfigurationTransformation[] transformations) {
        this.transformations = Arrays.copyOf(transformations, transformations.length);
    }

    @Override
    public void apply(ConfigurationNode node) throws ConfigurateException {
        @Nullable ConfigurateException thrown = null;
        for (ConfigurationTransformation transformation : this.transformations) {
            try {
                transformation.apply(node);
            }
            catch (ConfigurateException ex) {
                if (thrown == null) {
                    thrown = ex;
                    continue;
                }
                thrown.addSuppressed(ex);
            }
        }
        if (thrown != null) {
            throw thrown;
        }
    }
}

