/*
 * Decompiled with CFR 0.152.
 */
package net.ess3.nms.refl.providers;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import net.ess3.nms.refl.ReflUtil;
import net.ess3.provider.AbstractAchievementEvent;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerAdvancementDoneEvent;

public class AdvancementListenerProvider
implements Listener {
    private final Object language;
    private final MethodHandle languageGetOrDefault;

    public AdvancementListenerProvider() throws Throwable {
        Class<?> languageClass = ReflUtil.isMojMap() ? ReflUtil.getClassCached("net.minecraft.locale.Language") : (ReflUtil.getNmsVersionObject().isHigherThanOrEqualTo(ReflUtil.V1_17_R1) ? ReflUtil.getClassCached("net.minecraft.locale.LocaleLanguage") : ReflUtil.getNMSClass("LocaleLanguage"));
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        this.language = lookup.findStatic(languageClass, ReflUtil.isMojMap() ? "getInstance" : "a", MethodType.methodType(languageClass)).invoke();
        this.languageGetOrDefault = lookup.findVirtual(languageClass, ReflUtil.isMojMap() ? "getOrDefault" : "a", MethodType.methodType(String.class, String.class));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onAdvancement(PlayerAdvancementDoneEvent event) {
        try {
            String key = "advancements." + event.getAdvancement().getKey().getKey().replace('/', '.') + ".title";
            String translation = this.languageGetOrDefault.invoke(this.language, key);
            if (!key.equals(translation)) {
                Bukkit.getPluginManager().callEvent((Event)new AbstractAchievementEvent(event.getPlayer(), translation));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

